/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCodeCompletion;
import org.netbeans.modules.php.editor.PHPDocParamTagData;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 1px;padding: 1px;border-style: solid;border-color: gray;padding:3px\" ";
    private static final String TABLE_STYLE = "style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\"";
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());

    DocRenderer() {
    }

    static String document(ParserResult info, ElementHandle element) {
        if (element instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)element;
            return pHPDOCTagElement.getDoc();
        }
        if (element instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)element;
            return predefinedSymbolElement.getDoc();
        }
        if (element instanceof PhpElement) {
            return DocRenderer.documentIndexedElement((PhpElement)element);
        }
        if (element instanceof TypeMemberElement) {
            TypeMemberElement indexedClassMember = (TypeMemberElement)element;
            return DocRenderer.documentIndexedElement(indexedClassMember);
        }
        return null;
    }

    private static String documentIndexedElement(PhpElement indexedElement) {
        StringBuilder description = new StringBuilder();
        CCDocHtmlFormatter locationHeader = new CCDocHtmlFormatter();
        CCDocHtmlFormatter header = new CCDocHtmlFormatter();
        String location = DocRenderer.getLocation(indexedElement);
        StringBuilder phpDoc = new StringBuilder();
        ElementQuery elementQuery = indexedElement.getElementQuery();
        if (location != null) {
            locationHeader.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", location));
        }
        if (DocRenderer.canBeProcessed(indexedElement) && DocRenderer.getPhpDoc(indexedElement, header, phpDoc).length() == 0 && indexedElement instanceof MethodElement) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(indexedElement.getName()));
            ElementQuery.Index index = elementQuery.getQueryScope().isIndexScope() ? (ElementQuery.Index)elementQuery : ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(indexedElement.getFileObject()));
            LinkedHashSet<TypeElement> inheritedTypes = index.getInheritedTypes(((MethodElement)indexedElement).getType());
            Iterator typeIt = inheritedTypes.iterator();
            while (phpDoc.length() == 0 && typeIt.hasNext()) {
                Set<MethodElement> inheritedMethods = forName.filter(index.getDeclaredMethods((TypeElement)typeIt.next()));
                Iterator<MethodElement> methodIt = inheritedMethods.iterator();
                while (phpDoc.length() == 0 && methodIt.hasNext()) {
                    header = new CCDocHtmlFormatter();
                    DocRenderer.getPhpDoc(methodIt.next(), header, phpDoc);
                }
            }
        }
        if (phpDoc.length() > 0) {
            description.append((CharSequence)phpDoc);
        } else {
            description.append(NbBundle.getMessage(DocRenderer.class, (String)"PHPDocNotFound"));
        }
        return String.format("%s%s%s", locationHeader.getText(), header.getText(), description.toString());
    }

    private static boolean canBeProcessed(PhpElement indexedElement) {
        return indexedElement != null && indexedElement.getOffset() > -1 && indexedElement.getFileObject() != null;
    }

    private static StringBuilder getPhpDoc(PhpElement indexedElement, CCDocHtmlFormatter header, StringBuilder phpDoc) {
        if (DocRenderer.canBeProcessed(indexedElement)) {
            FileObject nextFo = indexedElement.getFileObject();
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)nextFo)), (UserTask)new PHPDocExtractor(header, phpDoc, indexedElement));
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return phpDoc;
    }

    private static String getLocation(PhpElement indexedElement) {
        String location = null;
        if (indexedElement.isPlatform()) {
            location = NbBundle.getMessage(DocRenderer.class, (String)"PHPPlatform");
        } else {
            FileObject fobj = indexedElement.getFileObject();
            if (fobj != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fobj);
                if (project != null) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup group : sources.getSourceGroups("PHPSOURCE")) {
                        String relativePath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fobj);
                        if (relativePath == null) continue;
                        location = relativePath;
                        break;
                    }
                    if (location == null) {
                        location = fobj.getPath();
                    }
                } else {
                    location = indexedElement.getFilenameUrl();
                }
            }
        }
        return location;
    }

    static final class PHPDocExtractor
    extends UserTask {
        private static final Pattern KEEP_TAGS_PATTERN = Pattern.compile("<(?!(/|b|code|br|i|kbd|li|ol|p|pre|samp|ul|var|table|tr|th|td)(\\b|\\s))", 2);
        private static final Pattern REPLACE_CODE_PATTERN = Pattern.compile("(?<=(</|<))code>", 2);
        private static final Pattern REPLACE_NEWLINE_PATTERN = Pattern.compile("(\r?\n){2,}");
        private static final Pattern KEEP_NEWLINE_PATTERN = Pattern.compile("(\r?\n)(?=(\\s\\S|[-+#o]\\s|\\d\\.?\\s))");
        private CCDocHtmlFormatter header;
        private StringBuilder phpDoc;
        private PhpElement indexedElement;

        public PHPDocExtractor(CCDocHtmlFormatter header, StringBuilder phpDoc, PhpElement indexedElement) {
            this.header = header;
            this.phpDoc = phpDoc;
            this.indexedElement = indexedElement;
        }

        public void cancel() {
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String fname = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(fname);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int paramCount = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < paramCount; ++i) {
                Identifier paramId;
                FormalParameter param = functionDeclaration.getFormalParameters().get(i);
                if (param.getParameterType() != null && (paramId = CodeUtils.extractUnqualifiedIdentifier(param.getParameterType())) != null) {
                    this.header.type(true);
                    this.header.appendText(paramId.getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(param));
                if (param.getDefaultValue() != null) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (param.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)param.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= paramCount) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        private void extractPHPDoc(PHPDocBlock pHPDocBlock) {
            StringBuilder params = new StringBuilder();
            StringBuilder links = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            StringBuilder others = new StringBuilder();
            this.phpDoc.append(PHPDocExtractor.processPhpDoc(pHPDocBlock.getDescription()));
            this.phpDoc.append("<br />\n");
            block5: for (PHPDocTag tag : pHPDocBlock.getTags()) {
                switch (tag.getKind()) {
                    case PARAM: {
                        PHPDocParamTagData tagData = new PHPDocParamTagData(tag.getValue());
                        String pline = String.format("<tr><td valign=\"top\" %s><nobr>%s</nobr></td><td valign=\"top\" %s><nobr><b>%s</b></nobr></td><td valign=\"top\" %s>%s</td></tr>\n", DocRenderer.TD_STYLE, tagData.type, DocRenderer.TD_STYLE, tagData.name, DocRenderer.TD_STYLE, PHPDocExtractor.processPhpDoc(tagData.description));
                        params.append(pline);
                        break;
                    }
                    case LINK: {
                        String lline = String.format("<a href=\"%s\">%s</a><br>\n", tag.getValue().trim(), tag.getValue().trim());
                        links.append(lline);
                        break;
                    }
                    case RETURN: {
                        String[] rparts = tag.getValue().trim().split("\\s+", 2);
                        if (rparts.length <= 0) continue block5;
                        String type = rparts[0];
                        returnValue.append(String.format("<b>%s:</b> %s<br><br>", NbBundle.getMessage(DocRenderer.class, (String)"Type"), type));
                        if (rparts.length <= 1) continue block5;
                        String desc = rparts[1];
                        returnValue.append(PHPDocExtractor.processPhpDoc(desc));
                        break;
                    }
                    default: {
                        String oline = String.format("<tr><th>%s</th><td>%s</td></tr>\n", PHPDocExtractor.processPhpDoc(tag.getKind().toString()), PHPDocExtractor.processPhpDoc(tag.getValue().trim()));
                        others.append(oline);
                    }
                }
            }
            if (params.length() > 0) {
                this.phpDoc.append("<div style=\"padding-top:3px;\"><b>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"Parameters"));
                this.phpDoc.append("</b></div>\n<table cellspacing=0 style=\"border-style:solid; border-color: black; border-width: 1px; width: 100%; border-collapse: collapse;\">\n" + params + "</table>\n");
            }
            if (returnValue.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"ReturnValue"));
                this.phpDoc.append("</h3>\n" + returnValue);
            }
            if (links.length() > 0) {
                this.phpDoc.append("<h3>");
                this.phpDoc.append(NbBundle.getMessage(DocRenderer.class, (String)"OnlineDocs"));
                this.phpDoc.append("</h3>\n" + links);
            }
            if (others.length() > 0) {
                this.phpDoc.append("<table>\n" + others + "</table>\n");
            }
        }

        static String processPhpDoc(String phpDoc) {
            String notags = KEEP_TAGS_PATTERN.matcher(phpDoc).replaceAll("&lt;");
            notags = REPLACE_CODE_PATTERN.matcher(notags).replaceAll("pre>");
            notags = REPLACE_NEWLINE_PATTERN.matcher(notags).replaceAll("<br><br>");
            return KEEP_NEWLINE_PATTERN.matcher(notags).replaceAll("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
        }

        public void run(ResultIterator resultIterator) throws Exception {
            ParserResult presult = (ParserResult)resultIterator.getParserResult();
            Program program = Utils.getRoot(presult);
            if (program != null) {
                ASTNode node = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (node == null) {
                    LOGGER.warning("Could not find AST node for element " + this.indexedElement.getName() + " defined in " + this.indexedElement.getFilenameUrl());
                    return;
                }
                if (node instanceof FunctionDeclaration) {
                    this.doFunctionDeclaration((FunctionDeclaration)node);
                } else {
                    this.header.name(this.indexedElement.getKind(), true);
                    this.header.appendText(this.indexedElement.getName());
                    this.header.name(this.indexedElement.getKind(), false);
                    String value = null;
                    if (this.indexedElement instanceof ConstantElement) {
                        ConstantElement constant = (ConstantElement)this.indexedElement;
                        value = constant.getValue();
                    } else if (this.indexedElement instanceof TypeConstantElement) {
                        TypeConstantElement constant = (TypeConstantElement)this.indexedElement;
                        value = constant.getValue();
                    }
                    if (value != null) {
                        this.header.appendText(" = ");
                        this.header.appendText(value);
                    }
                }
                this.header.appendHtml("<br/><br/>");
                Comment comment = Utils.getCommentForNode(program, node);
                if (comment instanceof PHPDocBlock) {
                    this.extractPHPDoc((PHPDocBlock)comment);
                }
            }
        }
    }
}

