/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.openide.util.Parameters;

public class ClassElementImpl
extends TypeElementImpl
implements ClassElement {
    public static final String IDX_FIELD = "clz";
    private final QualifiedName superClass;

    private ClassElementImpl(QualifiedName qualifiedName, int offset, QualifiedName superClsName, Set<QualifiedName> ifaceNames, int flags, String fileUrl, ElementQuery elementQuery) {
        super(qualifiedName, offset, ifaceNames, flags, fileUrl, elementQuery);
        this.superClass = superClsName;
    }

    public static Set<ClassElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return ClassElementImpl.fromSignature(NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<ClassElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<ClassElement> retval = values.length > 0 ? new HashSet<ClassElement>() : Collections.emptySet();
        for (String val : values) {
            ClassElement clz = ClassElementImpl.fromSignature(query, indexScopeQuery, indexResult, Signature.get(val));
            if (clz == null) continue;
            retval.add(clz);
        }
        return retval;
    }

    private static ClassElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature clsSignature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        ClassSignatureParser signParser = new ClassSignatureParser(clsSignature);
        ClassElementImpl retval = null;
        if (ClassElementImpl.matchesQuery(query, signParser)) {
            retval = new ClassElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getSuperClassName(), signParser.getSuperInterfaces(), signParser.getFlags(), indexResult.getUrl().toString(), indexScopeQuery);
        }
        return retval;
    }

    public static ClassElement fromNode(NamespaceElement namespace, ClassDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        ClassDeclarationInfo info = ClassDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new ClassElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), info.getSuperClassName(), info.getInterfaceNames(), info.getAccessModifiers().toFlags(), fileQuery.getURL().toExternalForm(), fileQuery);
    }

    public static ClassElement fromFrameworks(PhpClass clz, ElementQuery elementQuery) {
        Parameters.notNull((CharSequence)IDX_FIELD, (Object)clz);
        Parameters.notNull((CharSequence)"elementQuery", (Object)clz);
        ClassElementImpl retval = new ClassElementImpl(QualifiedName.create(clz.getFullyQualifiedName()), clz.getOffset(), null, Collections.<QualifiedName>emptySet(), 0, null, elementQuery);
        retval.fileObject = clz.getFile();
        return retval;
    }

    private static boolean matchesQuery(NameKind query, ClassSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(ClassElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return KIND;
    }

    @Override
    public final QualifiedName getSuperClassName() {
        return this.superClass;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(superClassName.toString());
        }
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        StringBuilder ifaceSb = new StringBuilder();
        for (QualifiedName ifaceName : this.getSuperInterfaces()) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append((Object)PhpElementImpl.SEPARATOR.COMMA);
            }
            ifaceSb.append(ifaceName.toString());
        }
        sb.append((CharSequence)ifaceSb);
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkClassSignature(sb);
        return sb.toString();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
            }
            case SuperTypes: {
                Set<QualifiedName> superIfaces;
                QualifiedName superClassName = this.getSuperClassName();
                if (superClassName != null) {
                    retval.append(" extends  ");
                    retval.append(superClassName.getName());
                }
                if (!(superIfaces = this.getSuperInterfaces()).isEmpty()) {
                    retval.append(" implements ");
                }
                StringBuilder ifacesBuffer = new StringBuilder();
                for (QualifiedName qualifiedName : superIfaces) {
                    if (ifacesBuffer.length() > 0) {
                        ifacesBuffer.append(", ");
                    }
                    ifacesBuffer.append(qualifiedName.getName());
                }
                retval.append((CharSequence)ifacesBuffer);
            }
        }
        return retval.toString();
    }

    private void checkClassSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            ClassSignatureParser parser = new ClassSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            QualifiedName superClassName = this.getSuperClassName();
            if (superClassName != null) assert (superClassName.equals(parser.getSuperClassName()));
            assert (this.getSuperInterfaces().size() == parser.getSuperInterfaces().size());
        }
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    private static class ClassSignatureParser {
        private final Signature signature;

        ClassSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(4), this.signature.string(1));
        }

        @CheckForNull
        QualifiedName getSuperClassName() {
            String name = this.signature.string(3);
            return name.trim().length() == 0 ? null : QualifiedName.create(name);
        }

        public Set<QualifiedName> getSuperInterfaces() {
            Set<QualifiedName> ifaces = Collections.emptySet();
            String separatedIfaces = this.signature.string(5);
            if (separatedIfaces != null && separatedIfaces.length() > 0) {
                String[] ifaceNames;
                ifaces = new HashSet<QualifiedName>();
                for (String ifName : ifaceNames = separatedIfaces.split(PhpElementImpl.SEPARATOR.COMMA.toString())) {
                    ifaces.add(QualifiedName.create(ifName));
                }
            }
            return ifaces;
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        int getFlags() {
            return this.signature.integer(6);
        }
    }
}

