/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.PHPNewLineIndenter;
import org.netbeans.modules.php.editor.indent.TokenFormatter;
import org.netbeans.modules.php.editor.indent.WSTransformer;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.util.Exceptions;

public class PHPFormatter
implements Formatter {
    private static final Logger LOG = Logger.getLogger(PHPFormatter.class.getName());
    private static final Set<PHPTokenId> IGNORE_BREAK_IN = new HashSet<PHPTokenId>(Arrays.asList(PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_DO));

    public PHPFormatter() {
        LOG.fine("PHP Formatter: " + this);
    }

    public boolean needsParserResult() {
        return true;
    }

    public void reindent(Context context) {
        String mimeType = PHPFormatter.getMimeTypeAtOffset(context.document(), context.startOffset());
        if (!"text/x-php5".equals(mimeType)) {
            return;
        }
        PHPNewLineIndenter indenter = new PHPNewLineIndenter(context);
        indenter.process();
    }

    public void reformat(Context context, ParserResult info) {
        long start = System.currentTimeMillis();
        new TokenFormatter().reformat(context, info);
        if (LOG.isLoggable(Level.FINE)) {
            long end = System.currentTimeMillis();
            LOG.log(Level.FINE, "Reformat took: {0} ms", end - start);
        }
    }

    public int indentSize() {
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lineUnformattable(BaseDocument doc, int offset) throws BadLocationException {
        TokenId id;
        Token<? extends PHPTokenId> firstTokenInLine = LexUtilities.getToken(doc, offset);
        if (firstTokenInLine.id() == PHPTokenId.PHP_LINE_COMMENT) {
            return true;
        }
        int pos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (pos != -1) {
            int currentLine;
            int startLine;
            Token token = LexUtilities.getToken(doc, pos);
            TokenSequence<? extends PHPTokenId> ts = LexUtilities.getPositionedSequence(doc, pos);
            if (ts != null) {
                token = ts.token();
            }
            if (token == null) return true;
            TokenId id2 = token.id();
            if (id2 == PHPTokenId.PHP_COMMENT || id2 == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE || id2 == PHPTokenId.T_INLINE_HTML || id2 == PHPTokenId.PHP_HEREDOC_TAG || id2 == PHPTokenId.PHP_NOWDOC_TAG) {
                return true;
            }
            if (id2 != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING) return false;
            if (ts.movePrevious()) {
                if (ts.token().id() == PHPTokenId.PHP_HEREDOC_TAG || ts.token().id() == PHPTokenId.PHP_NOWDOC_TAG) {
                    return true;
                }
                ts.moveNext();
            }
            if ((startLine = Utilities.getLineOffset((BaseDocument)doc, (int)ts.offset())) >= (currentLine = Utilities.getLineOffset((BaseDocument)doc, (int)pos))) return false;
            return true;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(doc, offset);
        if (token == null || (id = token.id()) != PHPTokenId.PHP_COMMENT && id != PHPTokenId.PHP_COMMENT_START && id != PHPTokenId.PHP_COMMENT_END && id != PHPTokenId.PHPDOC_COMMENT && id != PHPTokenId.PHPDOC_COMMENT_START && id != PHPTokenId.PHPDOC_COMMENT_END && id != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && id != PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && id != PHPTokenId.PHP_HEREDOC_TAG && id != PHPTokenId.PHP_NOWDOC_TAG) return false;
        return true;
    }

    private static boolean isSectionBorderLine(BaseDocument doc, int lineStart) throws BadLocationException {
        int firstNonWS = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)lineStart);
        TokenSequence<? extends PHPTokenId> ts = LexUtilities.getPositionedSequence(doc, firstNonWS);
        PHPTokenId id = (PHPTokenId)ts.token().id();
        return id == PHPTokenId.PHP_CLOSETAG || id == PHPTokenId.PHP_OPENTAG;
    }

    private void prettyPrint(final Context context, final ParserResult info) {
        final BaseDocument doc = (BaseDocument)context.document();
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                int offset;
                WSTransformer wsTransformer = new WSTransformer(context);
                PHPParseResult result = (PHPParseResult)info;
                result.getProgram().accept(wsTransformer);
                wsTransformer.tokenScan();
                List<WSTransformer.Replacement> replacements = wsTransformer.getReplacements();
                Collections.sort(replacements);
                Collections.reverse(replacements);
                WSTransformer.Replacement replacementToApply = null;
                for (WSTransformer.Replacement replacement : replacements) {
                    if (replacementToApply != null) {
                        if (replacementToApply.offset() != replacement.offset()) {
                            int offset2 = replacementToApply.offset();
                            if (offset2 >= context.startOffset() && offset2 <= context.endOffset()) {
                                try {
                                    doc.insertString(offset2, replacementToApply.newString(), null);
                                    if (replacementToApply.length() > 0) {
                                        doc.remove(offset2 - replacementToApply.length(), replacementToApply.length());
                                    }
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            replacementToApply = replacement;
                            continue;
                        }
                        if (replacementToApply.newString().length() >= replacement.newString().length() && (replacementToApply.newString().length() != replacement.newString().length() || replacementToApply.getPriority() <= replacement.getPriority())) continue;
                        replacementToApply = replacement;
                        continue;
                    }
                    replacementToApply = replacement;
                }
                if (replacementToApply != null && (offset = replacementToApply.offset()) >= context.startOffset() && offset <= context.endOffset()) {
                    try {
                        doc.insertString(offset, replacementToApply.newString(), null);
                        if (replacementToApply.length() > 0) {
                            doc.remove(offset - replacementToApply.length(), replacementToApply.length());
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    private static String getMimeTypeAtOffset(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        List tsl = th.embeddedTokenSequences(offset, false);
        if (tsl != null && tsl.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)tsl.get(tsl.size() - 1);
            return tokenSequence.language().mimeType();
        }
        return null;
    }

    private void astReformat(final Context context, final Map<Position, Integer> indentLevels) {
        Document document = context.document();
        document.putProperty("HTML_FORMATTER_ACTS_ON_TOP_LEVEL", Boolean.TRUE);
        try {
            final BaseDocument doc = (BaseDocument)document;
            final Map suggestedLineIndents = (Map)doc.getProperty((Object)"AbstractIndenter.lineIndents");
            final int startOffset = Utilities.getRowStart((BaseDocument)doc, (int)context.startOffset());
            final int firstLine = Utilities.getLineOffset((BaseDocument)doc, (int)startOffset);
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    int indentBias = 0;
                    boolean indentBiasCalculated = startOffset == 0;
                    try {
                        int initIndentSize = CodeStyle.get((Document)doc).getInitialIndent();
                        int numberOfLines = Utilities.getLineOffset((BaseDocument)doc, (int)(doc.getLength() - 1)) + 1;
                        LinkedHashMap<Integer, Integer> indentDeltaByLine = new LinkedHashMap<Integer, Integer>();
                        for (Position pos : indentLevels.keySet()) {
                            int indentDelta = (Integer)indentLevels.get(pos);
                            int point = pos.getOffset();
                            int lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)point);
                            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)point);
                            int firstNonWSBefore = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)point);
                            if (firstNonWSBefore >= rowStart) {
                                ++lineNumber;
                            }
                            Integer lineDelta = (Integer)indentDeltaByLine.get(lineNumber);
                            indentDeltaByLine.put(lineNumber, lineDelta == null ? indentDelta : lineDelta + indentDelta);
                        }
                        boolean templateEdit = doc.getProperty((Object)"code-template-insert-handler") != null;
                        int currentIndent = 0;
                        for (int i = 0; i < numberOfLines; ++i) {
                            int initialIndent;
                            Integer rawSuggestion;
                            int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)i);
                            Integer lineDelta = (Integer)indentDeltaByLine.get(i);
                            if (lineDelta != null && (currentIndent += lineDelta.intValue()) < 0) {
                                LOG.warning("currentIndent was < 0 in PHPFormatter.astReformat(). It shouldn't happen.");
                                currentIndent = 0;
                            }
                            if (PHPFormatter.this.lineUnformattable(doc, lineStart)) continue;
                            int htmlSuggestion = 0;
                            if (suggestedLineIndents != null && (rawSuggestion = (Integer)suggestedLineIndents.get(i)) != null) {
                                htmlSuggestion = rawSuggestion;
                            }
                            if (!indentBiasCalculated && (templateEdit && i >= firstLine || !templateEdit && i >= firstLine - 1)) {
                                indentBias = currentIndent - GsfUtilities.getLineIndent((BaseDocument)doc, (int)lineStart) - htmlSuggestion + initIndentSize;
                                indentBiasCalculated = true;
                            }
                            if (lineStart < context.startOffset() || lineStart > context.endOffset()) continue;
                            int actualIndent = 0;
                            int n = initialIndent = PHPFormatter.isSectionBorderLine(doc, lineStart) ? 0 : initIndentSize;
                            if (currentIndent + htmlSuggestion + initialIndent > indentBias) {
                                actualIndent = currentIndent + htmlSuggestion + initialIndent - indentBias;
                            }
                            GsfUtilities.setLineIndentation((BaseDocument)doc, (int)lineStart, (int)actualIndent);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
    }
}

