/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.ParameterInfoSupport;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;

public final class Model {
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());
    private ModelVisitor modelVisitor;
    private final PHPParseResult info;
    private OccurencesSupport occurencesSupport;

    Model(PHPParseResult info) {
        this.info = info;
    }

    public List<PhpBaseElement> getExtendedElements() {
        return this.getModelVisitor().extendedElements();
    }

    public FileScope getFileScope() {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.getFileScope();
    }

    public IndexScope getIndexScope() {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.getIndexScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OccurencesSupport getOccurencesSupport(OffsetRange range) {
        ModelVisitor visitor = this.getModelVisitor();
        Model model = this;
        synchronized (model) {
            if (this.occurencesSupport == null || !range.containsInclusive(this.occurencesSupport.offset)) {
                this.occurencesSupport = new OccurencesSupport(visitor, range.getStart() + 1);
            }
        }
        return this.occurencesSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OccurencesSupport getOccurencesSupport(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        Model model = this;
        synchronized (model) {
            if (this.occurencesSupport == null || this.occurencesSupport.offset != offset) {
                this.occurencesSupport = new OccurencesSupport(visitor, offset);
            }
        }
        return this.occurencesSupport;
    }

    public ParameterInfoSupport getParameterInfoSupport(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        return new ParameterInfoSupport(visitor, offset);
    }

    public VariableScope getVariableScope(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.getVariableScope(offset);
    }

    public ModelElement findDeclaration(PhpElement element) {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.findDeclaration(element);
    }

    synchronized ModelVisitor getModelVisitor() {
        if (this.modelVisitor == null) {
            long start = System.currentTimeMillis();
            this.modelVisitor = new ModelVisitor(this.info);
            this.modelVisitor.scan(Utils.getRoot(this.info));
            long end = System.currentTimeMillis();
            LOGGER.fine("Building model took: " + (end - start));
        }
        return this.modelVisitor;
    }
}

