/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.LambdaFunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

class FunctionScopeImpl
extends ScopeImpl
implements FunctionScope,
VariableNameFactory {
    private List<? extends ParameterElement> paremeters;
    volatile String returnType;
    private static Set<String> recursionDetection = new HashSet<String>();

    FunctionScopeImpl(Scope inScope, FunctionDeclarationInfo info, String returnType) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((FunctionDeclaration)info.getOriginalNode()).getBody());
        this.paremeters = info.getParameters();
        this.returnType = returnType;
    }

    FunctionScopeImpl(Scope inScope, LambdaFunctionDeclarationInfo info) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((LambdaFunctionDeclaration)info.getOriginalNode()).getBody());
        this.paremeters = info.getParameters();
    }

    protected FunctionScopeImpl(Scope inScope, MethodDeclarationInfo info, String returnType) {
        super(inScope, info, info.getAccessModifiers(), ((MethodDeclaration)info.getOriginalNode()).getFunction().getBody());
        this.paremeters = info.getParameters();
        this.returnType = returnType;
    }

    protected FunctionScopeImpl(Scope inScope, MagicMethodDeclarationInfo info) {
        super(inScope, info, info.getAccessModifiers(), null);
        this.paremeters = info.getParameters();
        this.returnType = info.getReturnType();
    }

    FunctionScopeImpl(Scope inScope, BaseFunctionElement indexedFunction) {
        this(inScope, indexedFunction, PhpElementKind.FUNCTION);
    }

    protected FunctionScopeImpl(Scope inScope, BaseFunctionElement element, PhpElementKind kind) {
        super(inScope, element, kind);
        this.paremeters = element.getParameters();
        this.returnType = element.asString(BaseFunctionElement.PrintAs.ReturnSemiTypes);
    }

    public static FunctionScopeImpl createElement(Scope scope, LambdaFunctionDeclaration node) {
        return new FunctionScopeImpl(scope, LambdaFunctionDeclarationInfo.create(node)){

            @Override
            public boolean isAnonymous() {
                return true;
            }
        };
    }

    @Override
    public final Collection<? extends TypeScope> getReturnTypes() {
        return this.getReturnTypes(false);
    }

    @Override
    public Collection<? extends String> getReturnTypeNames() {
        List retval = Collections.emptyList();
        if (this.returnType != null && this.returnType.length() > 0) {
            retval = new ArrayList();
            for (String typeName : this.returnType.split("\\|")) {
                if (typeName.contains("@")) continue;
                retval.add(typeName);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<? extends TypeScope> getReturnTypes(boolean resolve) {
        Collection<Object> retval = Collections.emptyList();
        String types = null;
        FunctionScopeImpl functionScopeImpl = this;
        synchronized (functionScopeImpl) {
            types = this.returnType;
        }
        if (types != null && types.length() > 0) {
            void var7_11;
            boolean evaluate = types.indexOf("@") != -1;
            retval = new HashSet();
            String[] arr$ = types.split("\\|");
            int len$ = arr$.length;
            boolean bl = false;
            while (var7_11 < len$) {
                String typeName = arr$[var7_11];
                if (typeName.trim().length() > 0) {
                    boolean added = false;
                    try {
                        added = recursionDetection.add(typeName);
                        if (added && recursionDetection.size() < 15) {
                            if (resolve && typeName.contains("@")) {
                                retval.addAll(VariousUtils.getType(this, typeName, this.getOffset(), false));
                            } else {
                                retval.addAll(IndexScopeImpl.getTypes(QualifiedName.create(typeName), this));
                            }
                        }
                    }
                    finally {
                        if (added) {
                            recursionDetection.remove(typeName);
                        }
                    }
                }
                ++var7_11;
            }
            if (evaluate) {
                StringBuilder sb = new StringBuilder();
                for (TypeScope typeScope : retval) {
                    if (sb.length() != 0) {
                        sb.append("|");
                    }
                    sb.append(typeScope.getNamespaceName().append(typeScope.getName()).toString());
                }
                FunctionScopeImpl functionScopeImpl2 = this;
                synchronized (functionScopeImpl2) {
                    if (types.equals(this.returnType)) {
                        this.returnType = sb.toString();
                    }
                }
            }
        }
        return retval;
    }

    @Override
    @NonNull
    public List<? extends String> getParameterNames() {
        assert (this.paremeters != null);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterElement parameterElement : this.paremeters) {
            parameterNames.add(parameterElement.getName());
        }
        return parameterNames;
    }

    @Override
    @NonNull
    public List<? extends ParameterElement> getParameters() {
        return this.paremeters;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var4_6;
        StringBuilder sb = new StringBuilder();
        Collection<? extends TypeScope> returnTypes = this.getReturnTypes();
        sb.append('[');
        for (TypeScope typeScope : returnTypes) {
            if (sb.length() == 1) {
                sb.append("|");
            }
            sb.append(typeScope.getName());
        }
        sb.append("] ");
        sb.append(super.toString()).append("(");
        List<? extends String> parameters = this.getParameterNames();
        boolean bl = false;
        while (var4_6 < parameters.size()) {
            String param = parameters.get((int)var4_6);
            if (var4_6 > 0) {
                sb.append(",");
            }
            sb.append(param);
            ++var4_6;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return FunctionScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(";");
        sb.append(this.getName()).append(";");
        sb.append(this.getOffset()).append(";");
        List<? extends ParameterElement> parameters = this.getParameters();
        for (int idx = 0; idx < parameters.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameters.get(idx);
            if (idx > 0) {
                sb.append(',');
            }
            sb.append(parameter.getSignature());
        }
        sb.append(";");
        if (this.returnType != null && !"mixed".equalsIgnoreCase(this.returnType)) {
            sb.append(this.returnType);
        }
        sb.append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(";");
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof FunctionElement) {
            FunctionElement indexedFunction = (FunctionElement)this.indexedElement;
            return indexedFunction.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }
}

