/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

final class MethodScopeImpl
extends FunctionScopeImpl
implements MethodScope,
VariableNameFactory,
LazyBuild {
    private String classNormName;
    private boolean scanned;
    private MethodDeclaration originalNode;
    private ModelVisitor visitor;

    MethodScopeImpl(Scope inScope, String returnType, MethodDeclarationInfo nodeInfo, ModelVisitor visitor) {
        super(inScope, nodeInfo, returnType);
        assert (inScope instanceof TypeScope);
        this.classNormName = inScope.getNormalizedName();
        this.scanned = false;
        this.originalNode = (MethodDeclaration)nodeInfo.getOriginalNode();
        this.visitor = visitor;
    }

    MethodScopeImpl(Scope inScope, MagicMethodDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo);
        assert (inScope instanceof TypeScope);
        this.classNormName = inScope.getNormalizedName();
        this.scanned = true;
    }

    MethodScopeImpl(Scope inScope, BaseFunctionElement element) {
        super(inScope, element, PhpElementKind.METHOD);
        assert (inScope instanceof TypeScope) : inScope.getClass().toString();
        this.classNormName = inScope.getNormalizedName();
        this.scanned = true;
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        this.scan();
        Scope inScope = this.getInScope();
        if (inScope instanceof ClassScope) {
            ClassScope classScope = (ClassScope)inScope;
            return ModelUtils.merge(classScope.getDeclaredVariables(), super.getDeclaredVariables());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends TypeScope> getReturnTypes(boolean resolve) {
        this.scan();
        return super.getReturnTypes(resolve);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpModifiers().toString()).append(" ");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public boolean isMagic() {
        return PredefinedSymbols.MAGIC_METHODS.contains(this.getName().toLowerCase());
    }

    @Override
    public boolean isConstructor() {
        return this.isMagic() ? this.getName().contains("__construct") : false;
    }

    @Override
    public TypeScope getTypeScope() {
        return (TypeScope)this.getInScope();
    }

    @Override
    public String getNormalizedName() {
        return this.classNormName + super.getNormalizedName();
    }

    @Override
    public String getClassSkeleton() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpModifiers().toString()).append(" ");
        sb.append("function").append(" ").append(this.getName());
        sb.append("(");
        List<? extends ParameterElement> parameterList = this.getParameters();
        if (parameterList.size() > 0) {
            int n = parameterList.size();
            for (int i = 0; i < n; ++i) {
                String defaultValue;
                Set<TypeResolver> types;
                ParameterElement param;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((param = parameterList.get(i)).hasDeclaredType() && (types = param.getTypes()).size() == 1) {
                    for (TypeResolver typeResolver : types) {
                        if (!typeResolver.isResolved()) continue;
                        sb.append(typeResolver.getTypeName(false)).append(' ');
                    }
                }
                sb.append(param.getName());
                if (param.isMandatory() || (defaultValue = param.getDefaultValue()) == null) continue;
                sb.append(" = ").append(defaultValue);
            }
        }
        sb.append(")");
        sb.append("{\n}");
        return sb.toString();
    }

    @Override
    public String getInterfaceSkeleton() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpModifiers().toString()).append(" ");
        sb.append("function").append(" ").append(this.getName());
        sb.append("(");
        List<? extends String> parameterNames = this.getParameterNames();
        for (int i = 0; i < parameterNames.size(); ++i) {
            String param = parameterNames.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(param);
        }
        sb.append(")");
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(";");
        sb.append(this.getName()).append(";");
        sb.append(this.getSignatureLastPart());
        return sb.toString();
    }

    @Override
    public String getConstructorIndexSignature() {
        StringBuilder sb = new StringBuilder();
        String typeName = this.getInScope().getName();
        sb.append(typeName.toLowerCase()).append(";");
        sb.append(typeName).append(";");
        sb.append(this.getSignatureLastPart());
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(";");
        return sb.toString();
    }

    private String getSignatureLastPart() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOffset()).append(";");
        List<? extends ParameterElement> parameters = this.getParameters();
        for (int idx = 0; idx < parameters.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameters.get(idx);
            if (idx > 0) {
                sb.append(',');
            }
            sb.append(parameter.getSignature());
        }
        sb.append(";");
        if (this.returnType != null && !"mixed".equalsIgnoreCase(this.returnType)) {
            sb.append(this.returnType);
        }
        sb.append(";");
        sb.append(this.getPhpModifiers().toFlags()).append(";");
        return sb.toString();
    }

    @Override
    public boolean isScanned() {
        return this.scanned;
    }

    @Override
    public void scan() {
        if (!this.scanned && this.visitor != null) {
            this.scanned = true;
            this.visitor.scanNoLazy(this.originalNode, this);
        }
    }
}

