/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OverridingMethods;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.nav.DeclarationFinderImpl;
import org.openide.filesystems.FileObject;

public class OverridingMethodsImpl
implements OverridingMethods {
    private String classSignatureForInheritedMethods = "";
    private String classSignatureForInheritedByMethods = "";
    private String classSignatureForInheritedByTypes = "";
    private Set<MethodElement> inheritedMethods = Collections.emptySet();
    private Set<MethodElement> inheritedByMethods = Collections.emptySet();
    private LinkedHashSet<TypeElement> inheritedByTypes = new LinkedHashSet();

    public Collection<? extends DeclarationFinder.AlternativeLocation> overrides(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenMethods = methodNameFilter.filter(this.getInheritedMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenMethods) {
                retval.add(new MethodLocation(methodElement));
            }
            return retval;
        }
        return null;
    }

    public Collection<? extends DeclarationFinder.AlternativeLocation> overriddenBy(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenByMethods = methodNameFilter.filter(this.getInheritedByMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenByMethods) {
                retval.add(new MethodLocation(methodElement));
            }
            return retval;
        }
        if (handle instanceof TypeScope) {
            ArrayList<TypeLocation> retval = new ArrayList<TypeLocation>();
            for (TypeElement typeElement : this.getInheritedByTypes(info, (TypeScope)handle)) {
                retval.add(new TypeLocation(typeElement));
            }
            return retval;
        }
        return null;
    }

    public boolean isOverriddenBySupported(ParserResult info, ElementHandle handle) {
        return true;
    }

    private Set<MethodElement> getInheritedMethods(ParserResult info, MethodScope method) {
        String signature = method.getInScope().getIndexSignature();
        if (!signature.equals(this.classSignatureForInheritedMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedMethods = index.getInheritedMethods((TypeScope)method.getInScope());
        }
        this.classSignatureForInheritedMethods = signature;
        return this.inheritedMethods;
    }

    private LinkedHashSet<TypeElement> getInheritedByTypes(ParserResult info, TypeScope type) {
        String signature = type.getIndexSignature();
        if (!signature.equals(this.classSignatureForInheritedByTypes)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByTypes = index.getInheritedByTypes(type);
        }
        this.classSignatureForInheritedByTypes = signature;
        return this.inheritedByTypes;
    }

    private Set<MethodElement> getInheritedByMethods(ParserResult info, MethodScope method) {
        String signature = method.getInScope().getIndexSignature();
        if (!signature.equals(this.classSignatureForInheritedByMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            TypeScope type = (TypeScope)method.getInScope();
            this.inheritedByMethods = new HashSet<MethodElement>();
            for (TypeElement nextType : this.getInheritedByTypes(info, type)) {
                this.inheritedByMethods.addAll(index.getDeclaredMethods(nextType));
            }
        }
        this.classSignatureForInheritedByMethods = signature;
        return this.inheritedByMethods;
    }

    private static class TypeLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public TypeLocation(PhpElement modelElement) {
            super(modelElement, new DeclarationFinder.DeclarationLocation(modelElement.getFileObject(), modelElement.getOffset(), (ElementHandle)modelElement));
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            TypeElement type = (TypeElement)this.getElement();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            sb.append(" (");
            sb.append(type.getFileObject().getNameExt());
            sb.append(")");
            return sb.toString();
        }
    }

    private static class MethodLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public MethodLocation(PhpElement modelElement) {
            super(modelElement, new DeclarationFinder.DeclarationLocation(modelElement.getFileObject(), modelElement.getOffset(), (ElementHandle)modelElement));
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            MethodElement method = (MethodElement)this.getElement();
            TypeElement type = method.getType();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

