/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PHPTypeSearcher
implements IndexSearcher {
    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String textForQuery, QuerySupport.Kind originalkind, IndexSearcher.Helper helper) {
        EnumSet<QuerySupport.Kind> regexpKinds = EnumSet.of(QuerySupport.Kind.CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP);
        EnumSet<QuerySupport.Kind> insensitiveKinds = EnumSet.of(QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        QuerySupport.Kind kind = originalkind;
        if ((kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.PREFIX) && PHPTypeSearcher.isCamelCasePattern(textForQuery)) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        Collection findRoots = QuerySupport.findRoots((Project)project, Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet());
        ElementQuery.Index index = ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(findRoots));
        HashSet<PHPTypeDescriptor> result = new HashSet<PHPTypeDescriptor>();
        if (index != null && textForQuery.trim().length() > 0) {
            QuerySupport.Kind useKind;
            boolean isVariable = textForQuery.startsWith("$");
            String query = this.prepareIdxQuery(textForQuery, regexpKinds, kind);
            QuerySupport.Kind kind2 = useKind = kind.equals((Object)QuerySupport.Kind.EXACT) ? QuerySupport.Kind.EXACT : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
            if (!kind.equals((Object)QuerySupport.Kind.EXACT)) {
                query = query.toLowerCase();
            }
            NameKind prefix = NameKind.create(query, useKind);
            if (!isVariable) {
                for (PhpElement phpElement : index.getTopLevelElements(prefix)) {
                    result.add(new PHPTypeDescriptor(phpElement, helper));
                }
                for (MethodElement methodElement : index.getMethods(prefix)) {
                    result.add(new PHPTypeDescriptor(methodElement, helper));
                }
            }
            for (VariableElement variableElement : index.getTopLevelVariables(prefix)) {
                result.add(new PHPTypeDescriptor(variableElement, helper));
            }
            for (FieldElement fieldElement : index.getFields(prefix)) {
                result.add(new PHPTypeDescriptor(fieldElement, helper));
            }
            for (TypeConstantElement typeConstantElement : index.getTypeConstants(prefix)) {
                result.add(new PHPTypeDescriptor(typeConstantElement, helper));
            }
        }
        if (regexpKinds.contains(kind)) {
            HashSet<PHPTypeDescriptor> originalResult = result;
            result = new HashSet();
            Pattern pattern = PHPTypeSearcher.queryToPattern(textForQuery, insensitiveKinds.contains(originalkind));
            for (PHPTypeDescriptor typeDescriptor : originalResult) {
                String typeName = typeDescriptor.getElement().getName();
                if (!pattern.matcher(typeName).matches()) continue;
                result.add(typeDescriptor);
            }
        }
        return result;
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String textForQuery, QuerySupport.Kind originalkind, IndexSearcher.Helper helper) {
        EnumSet<QuerySupport.Kind> regexpKinds = EnumSet.of(QuerySupport.Kind.CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP);
        EnumSet<QuerySupport.Kind> insensitiveKinds = EnumSet.of(QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        QuerySupport.Kind kind = originalkind;
        if ((kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.PREFIX) && PHPTypeSearcher.isCamelCasePattern(textForQuery)) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        Collection findRoots = QuerySupport.findRoots((Project)project, Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet());
        ElementQuery.Index index = ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(findRoots));
        HashSet<PHPTypeDescriptor> result = new HashSet<PHPTypeDescriptor>();
        QualifiedName queryName = QualifiedName.create(textForQuery);
        QualifiedNameKind qnk = queryName.getKind();
        if (index != null) {
            String query = qnk.isUnqualified() ? this.prepareIdxQuery(textForQuery, regexpKinds, kind).toLowerCase() : textForQuery;
            NameKind.Prefix prefix = NameKind.prefix(QualifiedName.create(query));
            for (ClassElement classElement : index.getClasses(prefix)) {
                result.add(new PHPTypeDescriptor(classElement, helper));
            }
            for (InterfaceElement interfaceElement : index.getInterfaces(prefix)) {
                result.add(new PHPTypeDescriptor(interfaceElement, helper));
            }
        }
        if (qnk.isUnqualified() && regexpKinds.contains(kind)) {
            HashSet<PHPTypeDescriptor> originalResult = result;
            result = new HashSet();
            Pattern pattern = PHPTypeSearcher.queryToPattern(textForQuery, insensitiveKinds.contains(originalkind));
            for (PHPTypeDescriptor pHPTypeDescriptor : originalResult) {
                String typeName = pHPTypeDescriptor.getElement().getName();
                if (!pattern.matcher(typeName).matches()) continue;
                result.add(pHPTypeDescriptor);
            }
        }
        return result;
    }

    private static Pattern queryToPattern(String query, boolean caseInsensitive) {
        StringBuilder sb = new StringBuilder();
        char[] chars = query.toCharArray();
        boolean incamel = false;
        if (!query.startsWith("$")) {
            sb.append("[$]*");
        }
        for (int i = 0; i < chars.length; ++i) {
            if (i + 1 < chars.length && chars[i] == '.' && chars[i + 1] == '*') {
                sb.append(".*");
                ++i;
                continue;
            }
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            if (chars[i] == '*') {
                sb.append(".*");
                continue;
            }
            if (chars[i] == '.') {
                sb.append(".");
                continue;
            }
            if (Character.isUpperCase(chars[i])) {
                if (incamel) {
                    sb.append("[a-z0-9_]*");
                }
                sb.append(chars[i]);
                incamel = true;
                continue;
            }
            if (i == 0 && chars[i] == '$') {
                sb.append('\\').append(chars[i]);
                continue;
            }
            sb.append(Pattern.quote(String.valueOf(chars[i])));
        }
        sb.append(".*");
        String patternString = sb.toString();
        patternString = patternString.replaceAll(Pattern.quote(".."), ".");
        return caseInsensitive ? Pattern.compile(patternString, 2) : Pattern.compile(patternString);
    }

    private String prepareIdxQuery(String textForQuery, EnumSet<QuerySupport.Kind> regexpKinds, QuerySupport.Kind kind) {
        String query = textForQuery.toLowerCase();
        if (regexpKinds.contains(kind)) {
            char charAt = textForQuery.charAt(0);
            int length = textForQuery.length();
            query = Character.isLetter(charAt) && length > 0 ? query.substring(0, 1) : (charAt == '$' && length > 1 ? query.substring(0, 1) : "");
        }
        return query;
    }

    private static boolean isCamelCasePattern(String query) {
        char[] chars;
        for (char c : chars = query.toCharArray()) {
            if (c != '*' && c != '?' && !Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    private static class PHPTypeDescriptor
    extends IndexSearcher.Descriptor {
        private final PhpElement element;
        private final PhpElement enclosingClass;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;

        public PHPTypeDescriptor(PhpElement element, IndexSearcher.Helper helper) {
            this(element, null, helper);
        }

        public PHPTypeDescriptor(PhpElement element, PhpElement enclosingClass, IndexSearcher.Helper helper) {
            this.element = element;
            this.enclosingClass = enclosingClass;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.element instanceof InterfaceElement) {
                return PHPCompletionItem.getInterfaceIcon();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            Project p;
            FileObject fo = this.element.getFileObject();
            if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                this.projectName = pi.getDisplayName();
                this.projectIcon = pi.getIcon();
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                GsfUtilities.open((FileObject)fileObject, (int)this.element.getOffset(), (String)this.element.getName());
            } else {
                Logger logger = Logger.getLogger(PHPTypeSearcher.class.getName());
                logger.log(Level.INFO, String.format("%s: cannot find %s", PHPTypeSearcher.class.getName(), this.element.getFilenameUrl()));
            }
        }

        public String getContextName() {
            StringBuilder sb = new StringBuilder();
            boolean s = false;
            if (this.element instanceof FullyQualifiedElement) {
                FullyQualifiedElement fqnElement = (FullyQualifiedElement)this.element;
                if (!fqnElement.getNamespaceName().isDefaultNamespace()) {
                    if (this.element instanceof TypeElement) {
                        sb.append(fqnElement.getFullyQualifiedName());
                    } else {
                        sb.append(fqnElement.getNamespaceName());
                    }
                    s = true;
                }
            } else if (this.enclosingClass != null) {
                if (this.enclosingClass instanceof FullyQualifiedElement && !((FullyQualifiedElement)this.enclosingClass).getNamespaceName().isDefaultNamespace()) {
                    sb.append(((FullyQualifiedElement)this.enclosingClass).getFullyQualifiedName().toString());
                } else {
                    sb.append(this.enclosingClass.getName());
                }
                s = true;
            }
            FileObject file = this.getFileObject();
            if (file != null) {
                if (s) {
                    sb.append(" in ");
                }
                sb.append(FileUtil.getFileDisplayName((FileObject)file));
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            PHPTypeDescriptor other = (PHPTypeDescriptor)((Object)obj);
            return this.element == other.element || this.element != null && this.element.equals(other.element);
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + (this.element != null ? this.element.hashCode() : 0);
            return hash;
        }
    }
}

