/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddUseImportRule
extends AbstractRule {
    public String getId() {
        return "AddUse.Import.Rule";
    }

    public String getDescription() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportRuleDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportRuleDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        PhpLanguageOptions.Properties props = PhpLanguageOptions.getDefault().getProperties(phpParseResult.getSnapshot().getSource().getFileObject());
        if (props.getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_5) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = context.caretOffset;
        int lineBegin = -1;
        int lineEnd = -1;
        lineBegin = caretOffset > 0 ? Utilities.getRowStart((BaseDocument)doc, (int)caretOffset) : -1;
        int n = lineEnd = lineBegin != -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset) : -1;
        if (lineBegin != -1 && lineEnd != -1 && caretOffset > lineBegin) {
            CheckVisitor checkVisitor = new CheckVisitor(context, doc, lineBegin, lineEnd);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    private static boolean isInside(int carret, int left, int right) {
        return carret >= left && carret <= right;
    }

    private static boolean isBefore(int carret, int margin) {
        return carret <= margin;
    }

    private static boolean isClassName(ASTNode parentNode) {
        return parentNode instanceof ClassName || parentNode instanceof FormalParameter || parentNode instanceof StaticConstantAccess || parentNode instanceof StaticMethodInvocation || parentNode instanceof StaticFieldAccess || parentNode instanceof ClassDeclaration;
    }

    private static boolean isFunctionName(ASTNode parentNode) {
        return parentNode instanceof FunctionName;
    }

    class ChangeNameFix
    implements HintFix {
        private BaseDocument doc;
        private ASTNode node;
        private NamespaceScope scope;
        private QualifiedName newName;
        private QualifiedName oldName;

        public ChangeNameFix(BaseDocument doc, ASTNode node, NamespaceScope scope, QualifiedName newName, QualifiedName oldName) {
            this.doc = doc;
            this.newName = newName;
            this.oldName = oldName;
            this.scope = scope;
            this.node = node;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return NbBundle.getMessage(AddUseImportRule.class, (String)"ChangeNameFix_Description", (Object)this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, this.oldName.toString().length(), this.getGeneratedCode(), true, 0);
            edits.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)templateOffset));
        }

        private String getGeneratedCode() {
            return this.newName.toString();
        }

        private int getOffset() {
            return this.node.getStartOffset();
        }
    }

    class AddImportFix
    implements HintFix {
        private BaseDocument doc;
        private NamespaceScope scope;
        private QualifiedName importName;

        public AddImportFix(BaseDocument doc, NamespaceScope scope, QualifiedName importName) {
            this.doc = doc;
            this.importName = importName;
            this.scope = scope;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.getOffset(), this.getOffset() + this.getGeneratedCode().length());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }

        public String getDescription() {
            return NbBundle.getMessage(AddUseImportRule.class, (String)"AddUseImportFix_Description", (Object)this.getGeneratedCode());
        }

        public void implement() throws Exception {
            int templateOffset = this.getOffset();
            EditList edits = new EditList(this.doc);
            edits.replace(templateOffset, 0, "\n" + this.getGeneratedCode(), true, 0);
            edits.apply();
            UiUtils.open((FileObject)this.scope.getFileObject(), (int)Utilities.getRowStart((BaseDocument)this.doc, (int)this.getOffsetRange().getEnd()));
        }

        private String getGeneratedCode() {
            return "use " + this.importName.toString() + ";";
        }

        private int getOffset() {
            try {
                return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.getReferenceElement().getOffset());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return 0;
            }
        }

        private ModelElement getReferenceElement() {
            ModelElement offsetElement = null;
            Collection<? extends UseElement> declaredUses = this.scope.getDeclaredUses();
            for (UseElement useElement : declaredUses) {
                if (offsetElement != null && offsetElement.getOffset() >= useElement.getOffset()) continue;
                offsetElement = useElement;
            }
            return offsetElement != null ? offsetElement : this.scope;
        }
    }

    private class CheckVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private BaseDocument doc;
        private PHPRuleContext context;
        private Collection<Hint> hints = new ArrayList<Hint>();

        CheckVisitor(PHPRuleContext context, BaseDocument doc, int lineBegin, int lineEnd) {
            this.doc = doc;
            this.lineBegin = lineBegin;
            this.lineEnd = lineEnd;
            this.context = context;
        }

        public Collection<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && AddUseImportRule.isBefore(node.getStartOffset(), this.lineEnd)) {
                super.scan(node);
            }
        }

        @Override
        public void visit(NamespaceName node) {
            if (AddUseImportRule.isInside(node.getStartOffset(), this.lineBegin, this.lineEnd)) {
                QualifiedName nodeName;
                List<ASTNode> path = this.getPath();
                ASTNode parentNode = path.get(0);
                NamespaceDeclaration currenNamespace = null;
                for (ASTNode oneNode : path) {
                    if (!(oneNode instanceof NamespaceDeclaration)) continue;
                    currenNamespace = (NamespaceDeclaration)oneNode;
                }
                if (AddUseImportRule.isFunctionName(parentNode)) {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<FunctionElement> functions = this.context.getIndex().getFunctions(NameKind.exact(nodeName));
                        for (FunctionElement indexedFunction : functions) {
                            this.addImportHints(indexedFunction, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                } else if (AddUseImportRule.isClassName(parentNode)) {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<ClassElement> classes = this.context.getIndex().getClasses(NameKind.exact(nodeName));
                        for (ClassElement indexedClass : classes) {
                            this.addImportHints(indexedClass, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                } else {
                    nodeName = QualifiedName.create(node);
                    if (!nodeName.getKind().isFullyQualified()) {
                        Set<ConstantElement> constants = this.context.getIndex().getConstants(NameKind.exact(nodeName));
                        for (ConstantElement cnst : constants) {
                            this.addImportHints(cnst, nodeName, currenNamespace, node);
                        }
                    }
                    super.visit(node);
                }
            }
        }

        @Override
        public void visit(Scalar node) {
            if (AddUseImportRule.isInside(node.getStartOffset(), this.lineBegin, this.lineEnd)) {
                QualifiedName nodeName;
                List<ASTNode> path = this.getPath();
                NamespaceDeclaration currenNamespace = null;
                for (ASTNode oneNode : path) {
                    if (!(oneNode instanceof NamespaceDeclaration)) continue;
                    currenNamespace = (NamespaceDeclaration)oneNode;
                }
                String stringValue = node.getStringValue();
                if (stringValue != null && stringValue.trim().length() > 0 && node.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(stringValue) && !(nodeName = QualifiedName.create(stringValue)).getKind().isFullyQualified()) {
                    Set<ConstantElement> constants = this.context.getIndex().getConstants(NameKind.exact(nodeName));
                    for (ConstantElement cnst : constants) {
                        this.addImportHints(cnst, nodeName, currenNamespace, node);
                    }
                }
            }
            super.visit(node);
        }

        private void addImportHints(FullyQualifiedElement idxElement, QualifiedName nodeName, NamespaceDeclaration currenNamespace, ASTNode node) {
            QualifiedName indexedName = idxElement.getFullyQualifiedName();
            QualifiedName importName = QualifiedName.getPrefix(indexedName, nodeName, true);
            if (importName != null) {
                Collection<? extends UseElement> declaredUses;
                List<UseElement> suitableUses;
                final String retvalStr = importName.toString();
                NamespaceScope currentScope = ModelUtils.getNamespaceScope(currenNamespace, this.context.fileScope);
                if (!NameKind.exact(currentScope.getQualifiedName().append(nodeName)).matchesName(idxElement) && (suitableUses = ModelUtils.filter(declaredUses = currentScope.getDeclaredUses(), new ModelUtils.ElementFilter<UseElement>(){

                    @Override
                    public boolean isAccepted(UseElement element) {
                        return element.getName().equalsIgnoreCase(retvalStr);
                    }
                })).isEmpty()) {
                    QualifiedName name;
                    if (idxElement instanceof ClassElement || !nodeName.getKind().isUnqualified()) {
                        AddImportFix importFix = new AddImportFix(this.doc, currentScope, importName);
                        this.hints.add(new Hint((Rule)AddUseImportRule.this, importFix.getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(node.getStartOffset(), node.getEndOffset()), Collections.singletonList(importFix), 500));
                    }
                    if ((name = VariousUtils.getPreferredName(indexedName, currentScope)) != null) {
                        ChangeNameFix changeNameFix = new ChangeNameFix(this.doc, node, currentScope, name, nodeName);
                        this.hints.add(new Hint((Rule)AddUseImportRule.this, changeNameFix.getDescription(), this.context.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(node.getStartOffset(), node.getEndOffset()), Collections.singletonList(changeNameFix), 500));
                    }
                }
            }
        }
    }
}

