/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

public final class OffsetRegion {
    private static final OffsetRegion EMPTY = new OffsetRegion(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final int startOffset;
    private final int endOffset;

    public static OffsetRegion empty() {
        return EMPTY;
    }

    public static OffsetRegion create(int startOffset, int endOffset) {
        return new OffsetRegion(startOffset, endOffset);
    }

    private static void checkBounds(int startOffset, int endOffset) {
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("startOffset=" + startOffset + " > endOffset=" + endOffset);
        }
    }

    private OffsetRegion(int startOffset, int endOffset) {
        OffsetRegion.checkBounds(startOffset, endOffset);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public int length() {
        return this.endOffset - this.startOffset;
    }

    public boolean isEmpty() {
        return this.startOffset == this.endOffset;
    }

    public OffsetRegion union(int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return this;
        }
        if (this.isEmpty()) {
            return new OffsetRegion(startOffset, endOffset);
        }
        OffsetRegion.checkBounds(startOffset, endOffset);
        return this.unionImpl(startOffset, endOffset);
    }

    public OffsetRegion union(OffsetRegion region) {
        if (region.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return region;
        }
        return this.unionImpl(region.startOffset(), region.endOffset());
    }

    private OffsetRegion unionImpl(int startOffset, int endOffset) {
        if (startOffset >= this.startOffset) {
            if (endOffset <= this.endOffset) {
                return this;
            }
            return new OffsetRegion(this.startOffset, endOffset);
        }
        return new OffsetRegion(startOffset, Math.max(endOffset, this.endOffset));
    }

    public OffsetRegion intersection(int startOffset, int endOffset) {
        OffsetRegion.checkBounds(startOffset, endOffset);
        return this.intersectionImpl(startOffset, endOffset);
    }

    private OffsetRegion intersectionImpl(int startOffset, int endOffset) {
        if ((startOffset = Math.max(startOffset, this.startOffset)) >= (endOffset = Math.min(endOffset, this.endOffset))) {
            return OffsetRegion.empty();
        }
        if (startOffset == this.startOffset && endOffset == this.endOffset) {
            return this;
        }
        return new OffsetRegion(startOffset, endOffset);
    }

    public String toString() {
        return this.isEmpty() ? "<E:" + this.startOffset + ">" : "<" + this.startOffset + "," + this.endOffset + ">";
    }
}

