/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.view.ParagraphView;

public final class TextLayoutCache {
    private static final Logger LOG = Logger.getLogger(TextLayoutCache.class.getName());
    private static final int MAX_SIZE = 200;
    private final Map<ParagraphView, Entry> paragraph2entry = new HashMap<ParagraphView, Entry>();
    private Entry head;
    private Entry tail;

    synchronized void clear() {
        this.paragraph2entry.clear();
        this.tail = null;
        this.head = null;
    }

    synchronized int size() {
        return this.paragraph2entry.size();
    }

    synchronized boolean contains(ParagraphView paragraphView) {
        assert (paragraphView != null);
        Entry entry = this.paragraph2entry.get(paragraphView);
        return entry != null;
    }

    synchronized void activate(ParagraphView paragraphView) {
        assert (paragraphView != null);
        Entry entry = this.paragraph2entry.get(paragraphView);
        if (entry == null) {
            entry = new Entry(paragraphView);
            this.paragraph2entry.put(paragraphView, entry);
            if (this.paragraph2entry.size() >= 200) {
                Entry lru = this.paragraph2entry.remove(this.tail.paragraphView);
                assert (lru == this.tail);
                this.removeChainEntry(lru);
            }
            this.addChainEntryFirst(entry);
        }
        if (this.head != entry) {
            this.removeChainEntry(entry);
            this.addChainEntryFirst(entry);
        }
    }

    synchronized void remove(ParagraphView paragraphView) {
        Entry entry = this.paragraph2entry.remove(paragraphView);
        if (entry != null) {
            this.removeChainEntry(entry);
        }
    }

    synchronized String findIntegrityError() {
        int cnt = 0;
        HashSet<Entry> entries = new HashSet<Entry>(this.paragraph2entry.values());
        Entry entry = this.head;
        while (entry != null) {
            if (!entries.contains(entry)) {
                return "TextLayoutCache: Chain entry[" + cnt + "] not contained in map: " + entry.paragraphView + ", parent=" + entry.paragraphView.getParent();
            }
            if (entry.paragraphView.getParent() == null) {
                return "TextLayoutCache: Null parent for " + entry.paragraphView;
            }
            entry = entry.next;
            ++cnt;
        }
        if (cnt != entries.size()) {
            return "TextLayoutCache: cnt=" + cnt + " != entryCount=" + entries.size();
        }
        return null;
    }

    private void addChainEntryFirst(Entry entry) {
        assert (entry.previous == null && entry.next == null);
        if (this.head == null) {
            assert (this.tail == null);
            this.head = this.tail = entry;
        } else {
            entry.next = this.head;
            this.head.previous = entry;
            this.head = entry;
        }
    }

    private void removeChainEntry(Entry entry) {
        if (entry.previous != null) {
            entry.previous.next = entry.next;
        } else {
            assert (this.head == entry);
            this.head = entry.next;
        }
        if (entry.next != null) {
            entry.next.previous = entry.previous;
        } else {
            assert (this.tail == entry);
            this.tail = entry.previous;
        }
        entry.next = null;
        entry.previous = null;
        entry.release();
    }

    private static final class Entry {
        final ParagraphView paragraphView;
        Entry previous;
        Entry next;

        Entry(ParagraphView paragraphView) {
            this.paragraphView = paragraphView;
            int viewCount = paragraphView.getViewCount();
            assert (viewCount > 0);
        }

        void release() {
            this.paragraphView.releaseTextLayouts();
        }
    }
}

