/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.TextLayoutPart;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class TextLayoutUtils {
    private TextLayoutUtils() {
    }

    public static float getHeight(Object layout) {
        TextLayout textLayout = layout instanceof TextLayoutPart ? ((TextLayoutPart)layout).textLayout() : (TextLayout)layout;
        return TextLayoutUtils.getHeight(textLayout);
    }

    public static float getHeight(TextLayout textLayout) {
        float height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return (float)Math.ceil(height);
    }

    public static float getWidth(Object layout, int textLength) {
        if (layout instanceof TextLayoutPart) {
            TextLayoutPart part = (TextLayoutPart)layout;
            TextLayout textLayout = part.textLayout();
            float endX = part.isLast() ? TextLayoutUtils.getWidth(textLayout) : TextLayoutUtils.index2X(textLayout, part.offsetShift() + textLength);
            return endX - part.xShift();
        }
        return TextLayoutUtils.getWidth((TextLayout)layout);
    }

    public static float getWidth(TextLayout textLayout) {
        float width = (float)Math.ceil(TextLayoutUtils.index2X(textLayout, textLayout.getCharacterCount()));
        return width;
    }

    public static float index2X(TextLayout textLayout, int index) {
        TextHitInfo hit = TextHitInfo.leading(index);
        float[] info = textLayout.getCaretInfo(hit);
        return info[0];
    }

    public static Rectangle2D.Double textLayoutBounds(TextLayoutPart part, Shape alloc) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        allocBounds.x -= (double)part.xShift();
        allocBounds.width = part.textLayoutWidth();
        return allocBounds;
    }

    public static Shape getRealAlloc(TextLayout textLayout, Rectangle2D textLayoutBounds, TextHitInfo startHit, TextHitInfo endHit) {
        Shape ret;
        if (textLayoutBounds.getX() != 0.0 || textLayoutBounds.getY() != 0.0) {
            Rectangle2D.Double zeroBasedBounds = ViewUtils.shape2Bounds(textLayoutBounds);
            zeroBasedBounds.x = 0.0;
            zeroBasedBounds.y = 0.0;
            ret = textLayout.getVisualHighlightShape(startHit, endHit, zeroBasedBounds);
            AffineTransform transform = AffineTransform.getTranslateInstance(textLayoutBounds.getX(), textLayoutBounds.getY());
            ret = transform.createTransformedShape(ret);
        } else {
            ret = textLayout.getVisualHighlightShape(startHit, endHit, textLayoutBounds);
        }
        return ret;
    }

    public static TextLayoutPart textLayoutPart(EditorBoxView boxView, int index) {
        return (TextLayoutPart)((HighlightsView)boxView.getEditorView(index)).layout();
    }

    public static TextHitInfo endHit(EditorBoxView boxView, TextLayoutPart anyPart, int layoutStartViewIndex, int endPartRelIndex) {
        assert (endPartRelIndex <= anyPart.viewCount());
        int endCharIndex = endPartRelIndex == anyPart.viewCount() ? anyPart.textLayout().getCharacterCount() : TextLayoutUtils.textLayoutPart(boxView, layoutStartViewIndex + endPartRelIndex).offsetShift();
        return TextHitInfo.leading(endCharIndex);
    }

    public static String toStringShort(TextLayout textLayout) {
        return "c[]:" + textLayout.getCharacterCount() + ";W=" + TextLayoutUtils.getWidth(textLayout);
    }

    public static String toString(TextLayout textLayout) {
        return TextLayoutUtils.toStringShort(textLayout) + "; " + textLayout.toString();
    }
}

