/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.openide.util.WeakListeners;

public final class ViewUpdates
implements DocumentListener {
    private static final Logger LOG = Logger.getLogger(ViewUpdates.class.getName());
    private static final int MAX_LOCAL_VIEWS_REBUILD_LENGTH = 200;
    private static final int LAZY_CHILDREN_MIN_BATCH_LINES = 5;
    private final DocumentView documentView;
    private EditorViewFactory[] viewFactories;
    private FactoriesListener factoriesListener;
    private DocumentListener incomingModificationListener;
    OffsetRegion rebuildRegion = OffsetRegion.empty();
    private boolean buildingViews;

    public ViewUpdates(DocumentView documentView) {
        this.documentView = documentView;
        this.factoriesListener = new FactoriesListener();
        this.incomingModificationListener = new IncomingModificationListener();
        Document doc = documentView.getDocument();
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this.incomingModificationListener, null)), (DocumentListenerPriority)DocumentListenerPriority.FIRST);
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc)), (DocumentListenerPriority)DocumentListenerPriority.VIEW);
    }

    private void initFactories() {
        assert (this.viewFactories == null);
        JTextComponent component = this.documentView.getTextComponent();
        assert (component != null) : "Null component; doc=" + this.documentView.getDocument();
        List<EditorViewFactory.Factory> factoryFactories = EditorViewFactory.factories();
        this.viewFactories = new EditorViewFactory[factoryFactories.size()];
        for (int i = 0; i < factoryFactories.size(); ++i) {
            this.viewFactories[i] = factoryFactories.get(i).createEditorViewFactory(component);
            this.viewFactories[i].addEditorViewFactoryListener((EditorViewFactoryListener)WeakListeners.create(EditorViewFactoryListener.class, (EventListener)this.factoriesListener, (Object)this.viewFactories[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildViews(ParagraphView paragraphView, int paragraphViewIndex, int startOffset, int endOffset, int modOffset, int offsetDelta, boolean createLocalViews) {
        assert (!this.buildingViews) : "Already building views";
        ViewBuilder viewBuilder = new ViewBuilder(paragraphView, this.documentView, paragraphViewIndex, this.viewFactories, startOffset, endOffset, modOffset, offsetDelta, createLocalViews);
        this.buildingViews = true;
        try {
            viewBuilder.createViews();
            viewBuilder.replaceAndRepaintViews();
        }
        finally {
            this.buildingViews = false;
            viewBuilder.finish();
        }
        this.documentView.viewHierarchy.fireViewHierarchyEvent(new ViewHierarchyEvent(this.documentView.viewHierarchy(), startOffset));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finer("ViewUpdates.buildViews(): UPDATED-DOC-VIEW:\n" + this.documentView);
        }
    }

    void reinitViews() {
        this.checkFactoriesComponentInited();
        int startOffset = this.documentView.getStartOffset();
        int endOffset = this.documentView.getEndOffset();
        this.buildViews(null, 0, startOffset, endOffset, endOffset, 0, this.documentView.isAccurateSpan());
    }

    void initChildren(int startIndex, int endIndex) {
        if (endIndex - startIndex < 5) {
            startIndex -= 2;
            endIndex += 2;
        }
        startIndex = Math.max(startIndex, 0);
        endIndex = Math.min(endIndex, this.documentView.getViewCount());
        assert (startIndex >= 0) : "startIndex=" + startIndex;
        assert (endIndex >= startIndex) : "endIndex=" + endIndex + " < startIndex=" + startIndex;
        ParagraphView startChild = (ParagraphView)this.documentView.getEditorView(startIndex);
        while (startChild.children != null && startIndex < endIndex - 1) {
            startChild = (ParagraphView)this.documentView.getEditorView(++startIndex);
        }
        ParagraphView lastChild = null;
        while (endIndex > startIndex) {
            lastChild = (ParagraphView)this.documentView.getEditorView(endIndex - 1);
            if (lastChild.children == null) break;
            --endIndex;
        }
        if (endIndex > startIndex) {
            int docTextLength = this.documentView.getDocument().getLength() + 1;
            int startOffset = startChild.getStartOffset();
            int endOffset = lastChild.getEndOffset();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lazy-children init: [" + startIndex + "," + endIndex + "]\n");
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.INFO, "Lazy creation cause", new Exception());
                }
            }
            assert (startOffset <= endOffset) : "startOffset=" + startOffset + " > endOffset=" + endOffset + "\n" + this.documentView.toStringDetail();
            assert (endOffset <= docTextLength) : "endOffset=" + endOffset + " > docTextLength=" + docTextLength + "\n" + this.documentView.toStringDetail();
            this.buildViews(null, startIndex, startOffset, endOffset, endOffset, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                boolean createLocalViews;
                int paragraphViewLength;
                ParagraphView paragraphView;
                int paragraphViewIndex;
                int docViewEndOffset;
                int docViewStartOffset;
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.insertUpdate(evt);
                }
                OffsetRegion rRegion = this.rebuildRegion;
                this.resetRebuildInfo();
                if (this.documentView.getViewCount() == 0) {
                    return;
                }
                int insertOffset = evt.getOffset();
                int insertLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-INSERT-evt: offset=" + insertOffset + ", length=" + insertLength + ", docLen=" + evt.getDocument().getLength() + '\n');
                }
                rRegion = rRegion.union(insertOffset, insertOffset + insertLength);
                Document doc = evt.getDocument();
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                if (lineElementChange != null) {
                    Element[] addedLines;
                    Element[] removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        assert (insertOffset >= firstRemovedLineStartOffset && insertOffset <= lastRemovedLineEndOffset);
                        rRegion = rRegion.union(firstRemovedLineStartOffset, lastRemovedLineEndOffset);
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(firstAddedLineStartOffset, lastAddedLineEndOffset);
                    }
                }
                if ((rRegion = rRegion.intersection(docViewStartOffset = this.documentView.getStartOffset(), docViewEndOffset = this.documentView.getEndOffset())).isEmpty()) {
                    return;
                }
                if (insertOffset == 0) {
                    paragraphViewIndex = 0;
                    paragraphView = null;
                    paragraphViewLength = 0;
                } else {
                    paragraphViewIndex = this.documentView.getViewIndex(rRegion.startOffset());
                    assert (paragraphViewIndex >= 0) : "paragraphViewIndex=" + paragraphViewIndex + ", docLen=" + evt.getDocument().getLength();
                    paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                    paragraphViewLength = paragraphView.getLength();
                }
                boolean bl = createLocalViews = rRegion.length() <= 200 + paragraphViewLength;
                if (paragraphView != null && paragraphView.children == null) {
                    int paragraphStartOffset = paragraphView.getStartOffset();
                    assert (paragraphStartOffset <= rRegion.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rRegion.startOffset();
                    rRegion = rRegion.union(paragraphStartOffset, paragraphStartOffset + paragraphView.getLength());
                    paragraphView = null;
                    createLocalViews = false;
                }
                createLocalViews |= this.documentView.isAccurateSpan();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ViewUpdates.insertUpdate-buildViews(): " + rRegion + " createLocalViews=" + createLocalViews + "\n");
                }
                this.buildViews(paragraphView, paragraphViewIndex, rRegion.startOffset(), rRegion.endOffset(), insertOffset, insertLength, createLocalViews);
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                boolean createLocalViews;
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.removeUpdate(evt);
                }
                OffsetRegion rRegion = this.rebuildRegion;
                this.resetRebuildInfo();
                if (this.documentView.getViewCount() == 0) {
                    return;
                }
                int removeOffset = evt.getOffset();
                int removeLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-REMOVE-evt: offset=" + removeOffset + ", length=" + removeLength + ", docLen=" + evt.getDocument().getLength() + '\n');
                }
                rRegion = rRegion.union(removeOffset, removeOffset + removeLength);
                int docViewStartOffset = this.documentView.getStartOffset();
                int docViewOrigEndOffset = this.documentView.getEndOffset();
                if (docViewOrigEndOffset >= removeOffset) {
                    docViewOrigEndOffset += removeLength;
                }
                if ((rRegion = rRegion.intersection(docViewStartOffset, docViewOrigEndOffset)).isEmpty()) {
                    return;
                }
                Document doc = evt.getDocument();
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                Element[] removedLines = null;
                if (lineElementChange != null) {
                    Element[] addedLines;
                    removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(firstRemovedLineStartOffset, lastRemovedLineEndOffset);
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(firstAddedLineStartOffset, lastAddedLineEndOffset);
                    }
                }
                int paragraphViewIndex = this.documentView.getViewIndexFirst(rRegion.startOffset());
                assert (paragraphViewIndex >= 0) : "Line view index is " + paragraphViewIndex;
                ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                boolean bl = createLocalViews = rRegion.length() <= 200 + paragraphView.getLength();
                if (paragraphView.children == null) {
                    int paragraphStartOffset = paragraphView.getStartOffset();
                    assert (paragraphStartOffset <= rRegion.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rRegion.startOffset();
                    rRegion = rRegion.union(paragraphStartOffset, paragraphStartOffset + paragraphView.getLength());
                    paragraphView = null;
                    createLocalViews = false;
                }
                createLocalViews |= this.documentView.isAccurateSpan();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ViewUpdates.removeUpdate-buildViews(): " + rRegion + " createLocalViews=" + createLocalViews + "\n");
                }
                this.buildViews(paragraphView, paragraphViewIndex, rRegion.startOffset(), rRegion.endOffset(), removeOffset, -removeLength, createLocalViews);
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent evt) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLocked();
            try {
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.changedUpdate(evt);
                }
                this.resetRebuildInfo();
                this.documentView.checkIntegrity();
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    boolean isRebuildNecessary() {
        return !this.rebuildRegion.isEmpty();
    }

    void resetRebuildInfo() {
        this.rebuildRegion = OffsetRegion.empty();
    }

    void extendRebuildInfo(int startOffset, int endOffset) {
        OffsetRegion oldRegion = this.rebuildRegion;
        this.rebuildRegion = this.rebuildRegion.union(startOffset, endOffset);
        if (this.rebuildRegion != oldRegion) {
            LOG.fine("ViewUpdates.Change extended to " + this.rebuildRegion + "\n");
        }
    }

    private void checkFactoriesComponentInited() {
        if (this.viewFactories == null) {
            this.initFactories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRebuild(OffsetRegion region) {
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.documentView.checkDocumentLocked();
                this.rebuildRegion = this.rebuildRegion.union(region);
                if (!this.buildingViews && this.documentView.isActive() && this.isRebuildNecessary()) {
                    boolean createLocalViews;
                    OffsetRegion rRegion = this.rebuildRegion;
                    this.resetRebuildInfo();
                    int docViewStartOffset = this.documentView.getStartOffset();
                    int docViewEndOffset = this.documentView.getEndOffset();
                    rRegion = rRegion.intersection(docViewStartOffset, docViewEndOffset);
                    if (rRegion.isEmpty()) {
                        return;
                    }
                    this.documentView.checkIntegrity();
                    int paragraphViewIndex = this.documentView.getViewIndexFirst(rRegion.startOffset());
                    assert (paragraphViewIndex >= 0) : "Paragraph view index is " + paragraphViewIndex + " for " + rRegion;
                    ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                    boolean bl = createLocalViews = rRegion.length() <= 200 + paragraphView.getLength();
                    if (paragraphView.children == null) {
                        int paragraphStartOffset = paragraphView.getStartOffset();
                        assert (paragraphStartOffset <= rRegion.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rRegion.startOffset=" + rRegion.startOffset();
                        rRegion = rRegion.union(paragraphStartOffset, paragraphStartOffset + paragraphView.getLength());
                        paragraphView = null;
                        createLocalViews = false;
                    }
                    createLocalViews |= this.documentView.isAccurateSpan();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("ViewUpdates.checkRebuild-buildViews(): " + rRegion + " createLocalViews=" + createLocalViews + "\n");
                    }
                    this.buildViews(paragraphView, paragraphViewIndex, rRegion.startOffset(), rRegion.endOffset(), rRegion.endOffset(), 0, createLocalViews);
                }
            }
            finally {
                mutex.unlock();
            }
        }
    }

    private final class IncomingModificationListener
    implements DocumentListener {
        private IncomingModificationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ViewUpdates.this.documentView.setIncomingModification(true);
        }
    }

    private final class FactoriesListener
    implements EditorViewFactoryListener {
        private FactoriesListener() {
        }

        @Override
        public void viewFactoryChanged(EditorViewFactoryEvent evt) {
            OffsetRegion region = OffsetRegion.empty();
            List<EditorViewFactory.Change> changes = evt.getChanges();
            for (EditorViewFactory.Change change : changes) {
                region = region.union(change.getStartOffset(), change.getEndOffset());
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("ViewUpdates.viewFactoryChanged: <" + change.getStartOffset() + "," + change.getEndOffset() + ">\n");
            }
            if (!region.isEmpty()) {
                ViewUpdates.this.checkRebuild(region);
            }
        }
    }
}

