/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.util.WeakListeners;

public class CssPreferences {
    public static final String FIND_IN_UNRELATED_FILES = "cssFindInUnrelatedFiles";
    public static final boolean FIND_IN_UNRELATED_FILES_DEFAULT = true;
    private static boolean findInUnrelatedFiles;
    private static String disabledErrorChecks;
    private static final String disabledErrorChecks_key = "disabledErrorChecks";
    private static String disabledErrorChecks_default;
    private static String DELIMITER;
    private static AtomicBoolean initialized;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;

    private static void lazyIntialize() {
        if (initialized.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-css").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private CssPreferences() {
    }

    public static boolean findInUnrelatedFiles() {
        CssPreferences.lazyIntialize();
        return findInUnrelatedFiles;
    }

    public static void setFindInUnrelatedFiles(boolean value) {
        CssPreferences.lazyIntialize();
        preferences.putBoolean(FIND_IN_UNRELATED_FILES, value);
    }

    public static Collection<String> getDisabledErrorChecks() {
        CssPreferences.lazyIntialize();
        return CssPreferences.getDisabledErrorChecksAsCollection();
    }

    public static boolean isErrorCheckingDisabledForCssErrorKey(String errorKey) {
        return CssPreferences.getDisabledErrorChecks().contains(errorKey);
    }

    public static void setCssErrorChecking(String errorKey, boolean enabled) {
        CssPreferences.lazyIntialize();
        Collection<String> mimescol = CssPreferences.getDisabledErrorChecksAsCollection();
        if (mimescol.contains(errorKey)) {
            if (!enabled) {
                return;
            }
            mimescol.remove(errorKey);
        } else if (!enabled) {
            mimescol.add(errorKey);
        } else {
            return;
        }
        preferences.put(disabledErrorChecks_key, CssPreferences.encodeKeys(mimescol));
    }

    private static String encodeKeys(Collection<String> mimes) {
        StringBuilder b = new StringBuilder();
        for (String m : mimes) {
            b.append(m);
            b.append(DELIMITER);
        }
        return b.toString();
    }

    private static Collection<String> getDisabledErrorChecksAsCollection() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(disabledErrorChecks.split(DELIMITER)));
        return list;
    }

    static {
        disabledErrorChecks_default = "";
        DELIMITER = ";";
        initialized = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || CssPreferences.FIND_IN_UNRELATED_FILES.equals(settingName)) {
                    findInUnrelatedFiles = preferences.getBoolean(CssPreferences.FIND_IN_UNRELATED_FILES, true);
                }
                if (settingName == null || CssPreferences.disabledErrorChecks_key.equals(settingName)) {
                    disabledErrorChecks = preferences.get(CssPreferences.disabledErrorChecks_key, disabledErrorChecks_default);
                }
            }
        };
    }
}

