/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.versioning.history.SummaryCellRenderer;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class AbstractSummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.util.AbstractSummaryView");
    private RootNode rootNode;
    private RequestProcessor rp = new RequestProcessor("SummaryView", 10);
    private boolean populated = false;
    private JPanel panel = new JPanel();
    private final JPanel linesPanel;
    private final Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap;
    private final SummaryViewMaster master;
    private JTree resultsTree;
    private JScrollPane scrollPane;
    private List<LogEntry> dispResults;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();

    String getMessage() {
        return this.master.getMessage();
    }

    File getRoot() {
        return this.master.getRoots()[0];
    }

    Map<String, String> getActionColors() {
        return this.master.getActionColors();
    }

    void fireNodeChanged(String revision) {
        ResultModel tm = (ResultModel)this.resultsTree.getModel();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            LogEntryNode len;
            LogEntry le;
            TreeNode n = this.rootNode.getChildAt(i);
            if (!(n instanceof LogEntryNode) || !revision.equals((le = (LogEntry)(len = (LogEntryNode)n).getUserObject()).getRevision())) continue;
            tm.fireTreeNodesChanged(len, len.getPath(), new int[0], new TreeNode[0]);
            return;
        }
    }

    public AbstractSummaryView(SummaryViewMaster master, List<LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap) {
        this.master = master;
        this.kenaiUsersMap = kenaiUsersMap;
        this.dispResults = results;
        this.rootNode = new RootNode(this.dispResults);
        this.resultsTree = new JTree(new DefaultTreeModel(new WaitNode(this.rootNode)));
        this.resultsTree.setLargeModel(true);
        this.resultsTree.setRowHeight(0);
        this.resultsTree.setShowsRootHandles(true);
        this.resultsTree.setRootVisible(false);
        this.resultsTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object o = path.getLastPathComponent();
                if (o instanceof LogEntryNode) {
                    LogEntryNode n = (LogEntryNode)o;
                    n.populateEvents(path);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.resultsTree.addMouseListener(this);
        this.resultsTree.addMouseMotionListener(this);
        this.resultsTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AbstractSummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AbstractSummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsTree, 22, 31);
        this.resultsTree.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractSummaryView.this.populateTree();
            }
        });
        master.getComponent().addComponentListener(this);
        this.resultsTree.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsTree.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSummaryView.this.onPopup(Utils.getPositionForPopup(AbstractSummaryView.this.resultsTree), AbstractSummaryView.this.getSelection(null));
            }
        });
        this.resultsTree.setSelectionModel(new SelectionModel());
        this.linesPanel = new JPanel();
        HyperlinkLabel label10 = new HyperlinkLabel();
        HyperlinkLabel label50 = new HyperlinkLabel();
        HyperlinkLabel label100 = new HyperlinkLabel();
        HyperlinkLabel labelAll = new HyperlinkLabel();
        label10.set("10", Color.BLUE, label10.getBackground());
        label50.set("50", Color.BLUE, label10.getBackground());
        label100.set("100", Color.BLUE, label10.getBackground());
        labelAll.set("All Revisions", Color.BLUE, label10.getBackground());
        this.linesPanel.setLayout(new FlowLayout(0));
        this.linesPanel.add(new JLabel("Show more..."));
        this.linesPanel.add(label10);
        this.linesPanel.add(new JLabel(","));
        this.linesPanel.add(label50);
        this.linesPanel.add(new JLabel(","));
        this.linesPanel.add(label100);
        this.linesPanel.add(new JLabel(","));
        this.linesPanel.add(labelAll);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.scrollPane, "First");
        this.panel.add((Component)this.linesPanel, "Last");
        this.panel.validate();
    }

    void populateTree() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        this.resultsTree.setModel(new ResultModel(this.rootNode));
        this.resultsTree.setCellRenderer(new SummaryCellRenderer(this, this.linkerSupport, this.dispResults, this.kenaiUsersMap));
    }

    public JTree getList() {
        return this.resultsTree;
    }

    public JComponent getTreeComponent() {
        return this.panel;
    }

    public List getResults() {
        return this.dispResults;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        ResultModel tm = (ResultModel)this.resultsTree.getModel();
        int c = this.rootNode.getChildCount();
        Object[] nodes = new TreeNode[c];
        int[] indices = new int[c];
        for (int i = 0; i < c; ++i) {
            nodes[i] = this.rootNode.getChildAt(i);
            indices[i] = i;
        }
        tm.fireTreeNodesChanged(this.rootNode, this.rootNode.getPath(), indices, nodes);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.resultsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path == null) {
            return;
        }
        Rectangle rect = this.resultsTree.getPathBounds(path);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        String revision = this.getRevision(path);
        if (revision != null) {
            this.linkerSupport.mouseClicked(p, revision);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.resultsTree.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsTree.setToolTipText("");
        TreePath path = this.resultsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path == null) {
            return;
        }
        Rectangle rect = this.resultsTree.getPathBounds(path);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        String revision = this.getRevision(path);
        if (revision != null) {
            this.linkerSupport.mouseMoved(p, (JComponent)this.resultsTree, revision);
        }
    }

    private String getRevision(TreePath path) {
        String revision = null;
        Object o = path.getLastPathComponent();
        if (o instanceof LogEntryNode) {
            LogEntryNode len = (LogEntryNode)o;
            o = len.getUserObject();
            LogEntry le = (LogEntry)len.getUserObject();
            revision = le.getRevision();
        } else if (o instanceof ActionNode) {
            ActionNode an = (ActionNode)o;
            LogEntry le = (LogEntry)((LogEntryNode)an.getParent()).getUserObject();
            revision = le.getRevision();
        }
        return revision;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private void onPopup(MouseEvent e) {
        this.onPopup(e.getPoint(), this.getSelection(e.getPoint()));
    }

    protected abstract void onPopup(Point var1, Object[] var2);

    private Object[] getSelection(Point p) {
        TreePath[] paths = this.resultsTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            assert (p != null);
            paths = new TreePath[]{this.resultsTree.getPathForLocation(p.x, p.y)};
        }
        Object[] selection = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            selection[i] = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return selection;
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class EventComparator
    implements Comparator<LogEntry.Event> {
        private EventComparator() {
        }

        @Override
        public int compare(LogEntry.Event o1, LogEntry.Event o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int c = o1.getAction().compareTo(o2.getAction());
            if (c != 0) {
                return c;
            }
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private class SelectionModel
    extends DefaultTreeSelectionModel {
        @Override
        public void addSelectionPath(TreePath path) {
            if (!this.checkPath(path)) {
                return;
            }
            super.addSelectionPath(path);
        }

        @Override
        protected boolean canPathsBeAdded(TreePath[] paths) {
            return super.canPathsBeAdded(paths);
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            super.addSelectionPaths(paths);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if (paths.length == 0) {
                return;
            }
            if (paths.length > 1) {
                for (TreePath treePath : paths) {
                    if (this.checkPath(treePath)) continue;
                    return;
                }
            } else if (!this.checkPath(paths[0])) {
                int rNext;
                if (this.isSelectionEmpty()) return;
                TreePath[] lastPath = this.getSelectionPaths();
                if (lastPath.length != 1) return;
                int rPrev = AbstractSummaryView.this.resultsTree.getRowForPath(lastPath[0]);
                if (rPrev > (rNext = AbstractSummaryView.this.resultsTree.getRowForPath(paths[0])) && rNext - 1 > -1) {
                    --rNext;
                } else {
                    if (rPrev >= rNext || rNext + 1 >= AbstractSummaryView.this.resultsTree.getRowCount()) return;
                    ++rNext;
                }
                paths[0] = AbstractSummaryView.this.resultsTree.getPathForRow(rNext);
            }
            super.setSelectionPaths(paths);
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (!this.checkPath(path)) {
                return;
            }
            super.setSelectionPath(path);
        }

        private boolean checkPath(TreePath path) {
            return !(path.getLastPathComponent() instanceof ActionNode);
        }
    }

    private class ResultModel
    extends DefaultTreeModel {
        public ResultModel(TreeNode root) {
            super(root, true);
        }

        @Override
        protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            super.fireTreeNodesChanged(source, path, childIndices, children);
        }
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    class ActionNode
    extends DefaultMutableTreeNode {
        public ActionNode(LogEntryNode parent) {
            super(parent, false);
        }
    }

    class EventNode
    extends DefaultMutableTreeNode {
        public EventNode(LogEntry.Event event, LogEntryNode parent) {
            super(event, false);
        }
    }

    class WaitNode
    extends DefaultMutableTreeNode {
        public WaitNode(MutableTreeNode parent) {
            super("Please wait...", false);
        }
    }

    class LogEntryNode
    extends DefaultMutableTreeNode {
        public WaitNode waitNode;
        private boolean wait;

        public LogEntryNode(LogEntry entry, MutableTreeNode parent) {
            super(entry, true);
            this.wait = true;
            this.waitNode = new WaitNode(this);
            this.add(this.waitNode);
        }

        private void populateEvents(final TreePath path) {
            if (!this.wait) {
                return;
            }
            this.wait = false;
            AbstractSummaryView.this.rp.create(new Runnable(){

                @Override
                public void run() {
                    final LinkedList<LogEntry.Event> events = new LinkedList<LogEntry.Event>(((LogEntry)LogEntryNode.this.getUserObject()).getEvents());
                    if (events == null) {
                        return;
                    }
                    Collections.sort(events, new EventComparator());
                    final DefaultTreeModel model = (DefaultTreeModel)AbstractSummaryView.this.resultsTree.getModel();
                    final boolean expanded = AbstractSummaryView.this.resultsTree.isExpanded(path);
                    if (LogEntryNode.this.waitNode != null) {
                        model.removeNodeFromParent(LogEntryNode.this.waitNode);
                    }
                    LogEntryNode.this.waitNode = null;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            model.insertNodeInto(new ActionNode(LogEntryNode.this), LogEntryNode.this, 0);
                            int i = 1;
                            for (LogEntry.Event event : events) {
                                model.insertNodeInto(new EventNode(event, LogEntryNode.this), LogEntryNode.this, i++);
                            }
                            if (expanded) {
                                AbstractSummaryView.this.resultsTree.expandPath(path);
                            }
                        }
                    });
                }
            }).schedule(0);
        }
    }

    class RootNode
    extends DefaultMutableTreeNode {
        public RootNode(List<LogEntry> children) {
            int i = 0;
            for (LogEntry logEntry : children) {
                this.insert(new LogEntryNode(logEntry, this), i++);
            }
        }
    }

    public static abstract class LogEntry {
        boolean messageExpanded = false;
        private boolean eventsExpanded = false;

        public abstract Collection<Event> getEvents();

        public abstract Collection<Event> getContextEvents();

        public abstract String getAuthor();

        public abstract String getDate();

        public abstract String getRevision();

        public abstract String getRevision2();

        public abstract String getMessage();

        public abstract Action[] getActions();

        public static abstract class Event {
            public abstract String getPath();

            public abstract String getAction();
        }
    }

    public static interface SummaryViewMaster {
        public JComponent getComponent();

        public File[] getRoots();

        public String getMessage();

        public Map<String, String> getActionColors();

        public List<LogEntry> getMoreResults(List<LogEntry> var1, int var2);
    }
}

