/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FileCompletionPopup
extends JPopupMenu
implements KeyListener {
    private JList list;
    private JTextField textField;
    private JFileChooser chooser;

    public FileCompletionPopup(JFileChooser chooser, JTextField textField, Vector<File> files) {
        this.list = new JList<File>(files);
        this.textField = textField;
        this.chooser = chooser;
        this.list.setVisibleRowCount(4);
        this.list.setSelectionMode(0);
        JScrollPane jsp = new JScrollPane(this.list);
        this.add(jsp);
        this.list.setFocusable(false);
        jsp.setFocusable(false);
        this.setFocusable(false);
        this.list.addFocusListener(new FocusHandler());
        this.list.addMouseListener(new MouseHandler());
        this.list.addMouseMotionListener(new MouseHandler());
        textField.addKeyListener(this);
    }

    public void setDataList(Vector files) {
        this.list.setListData(files);
        this.ensureSelection();
    }

    void detach() {
        this.textField.removeKeyListener(this);
    }

    private void setSelectNext() {
        if (this.list.getModel().getSize() > 0) {
            int cur = (this.list.getSelectedIndex() + 1) % this.list.getModel().getSize();
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    private void setSelectPrevious() {
        if (this.list.getModel().getSize() > 0) {
            int cur = this.list.getSelectedIndex() == -1 ? 0 : this.list.getSelectedIndex();
            cur = cur == 0 ? this.list.getModel().getSize() - 1 : cur - 1;
            this.list.setSelectedIndex(cur);
            this.list.ensureIndexIsVisible(cur);
        }
    }

    public void showPopup(JTextComponent source, int x, int y) {
        if (this.list.getModel().getSize() == 0) {
            return;
        }
        this.setPreferredSize(new Dimension(source.getWidth(), source.getHeight() * 4));
        this.show(source, x, y);
        this.ensureSelection();
    }

    private void ensureSelection() {
        if (this.list.getSelectedIndex() == -1 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isVisible()) {
            return;
        }
        int code = e.getKeyCode();
        switch (code) {
            case 40: {
                this.setSelectNext();
                e.consume();
                break;
            }
            case 38: {
                this.setSelectPrevious();
                e.consume();
                break;
            }
            case 27: {
                this.setVisible(false);
                this.textField.requestFocus();
                e.consume();
            }
        }
        if (this.isCompletionKey(code, this.textField)) {
            File file = (File)this.list.getSelectedValue();
            if (file != null) {
                if (file.equals(this.chooser.getCurrentDirectory())) {
                    this.chooser.firePropertyChange("directoryChanged", false, true);
                } else {
                    this.chooser.setSelectedFiles(new File[]{file});
                    this.chooser.setCurrentDirectory(file);
                }
                if (file.isDirectory()) {
                    try {
                        Document doc = this.textField.getDocument();
                        doc.insertString(doc.getLength(), File.separator, null);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Cannot append directory separator.", ex);
                    }
                }
            }
            this.setVisible(false);
            this.textField.requestFocus();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private boolean isCompletionKey(int keyCode, JTextField textField) {
        if (keyCode == 10 || keyCode == 9) {
            return true;
        }
        return keyCode == 39 && textField.getCaretPosition() >= textField.getDocument().getLength() - 1;
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getSource() == FileCompletionPopup.this.list) {
                Point location = e.getPoint();
                int index = FileCompletionPopup.this.list.locationToIndex(location);
                Rectangle r = new Rectangle();
                FileCompletionPopup.this.list.computeVisibleRect(r);
                if (r.contains(location)) {
                    FileCompletionPopup.this.list.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getSource() == FileCompletionPopup.this.list) {
                return;
            }
            if (FileCompletionPopup.this.isVisible()) {
                MouseEvent newEvent = this.convertMouseEvent(e);
                Rectangle r = new Rectangle();
                FileCompletionPopup.this.list.computeVisibleRect(r);
                Point location = newEvent.getPoint();
                int index = FileCompletionPopup.this.list.locationToIndex(location);
                if (r.contains(location)) {
                    FileCompletionPopup.this.list.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int index = FileCompletionPopup.this.list.locationToIndex(p);
            FileCompletionPopup.this.list.setSelectedIndex(index);
            FileCompletionPopup.this.setVisible(false);
            File file = (File)FileCompletionPopup.this.list.getSelectedValue();
            if (file == null) {
                return;
            }
            if (file.equals(FileCompletionPopup.this.chooser.getCurrentDirectory())) {
                FileCompletionPopup.this.chooser.firePropertyChange("directoryChanged", false, true);
            } else {
                FileCompletionPopup.this.chooser.setCurrentDirectory(file);
            }
            FileCompletionPopup.this.textField.requestFocus();
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point convertedPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), FileCompletionPopup.this.list);
            MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), convertedPoint.x, convertedPoint.y, e.getClickCount(), e.isPopupTrigger());
            return newEvent;
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                FileCompletionPopup.this.setVisible(false);
                FileCompletionPopup.this.textField.requestFocus();
            }
        }
    }
}

