/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Timer;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ComponentInspector
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager;
    private TestAction testAction = (TestAction)SystemAction.findObject(TestAction.class, (boolean)true);
    private PasteAction pasteAction = (PasteAction)SystemAction.findObject(PasteAction.class, (boolean)true);
    private CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private ClipboardListener clipboardListener;
    private FormEditor focusedForm;
    private EmptyInspectorNode emptyInspectorNode;
    private BeanTreeView treeView;
    private static final String EMPTY_INSPECTOR_ICON_BASE = "org/netbeans/modules/form/resources/emptyInspector.gif";
    private static final String iconURL = "org/netbeans/modules/form/resources/inspector.png";
    private static ComponentInspector instance;

    public static synchronized ComponentInspector getDefault() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    public static synchronized ComponentInspector getInstance() {
        if (instance == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("ComponentInspector");
            if (instance == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can not find ComponentInspector component for its ID. Returned " + tc));
                instance = new ComponentInspector();
            }
        }
        return instance;
    }

    static boolean exists() {
        return instance != null;
    }

    public int getPersistenceType() {
        return 0;
    }

    private ComponentInspector() {
        this.explorerManager = new ExplorerManager();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.setupActionMap(this.getActionMap())));
        this.emptyInspectorNode = new EmptyInspectorNode();
        this.explorerManager.setRootContext((Node)this.emptyInspectorNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectionListener());
        this.setLayout(new BorderLayout());
        this.createComponents();
        this.setIcon(ImageUtilities.loadImage((String)iconURL));
        this.setName(FormUtils.getBundleString("CTL_InspectorTitle"));
        this.setToolTipText(FormUtils.getBundleString("HINT_ComponentInspector"));
    }

    ActionMap setupActionMap(ActionMap map) {
        map.put("copy-to-clipboard", this.copyActionPerformer);
        map.put("cut-to-clipboard", this.cutActionPerformer);
        map.put("delete", this.deleteActionPerformer);
        return map;
    }

    private void createComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setDragSource(true);
        this.treeView.setDropTarget(true);
        this.treeView.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACS_ComponentTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ComponentTree"));
        this.add("Center", (Component)this.treeView);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager ur = this.focusedForm != null ? this.focusedForm.getFormUndoRedoManager() : null;
        return ur != null ? ur : super.getUndoRedo();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.component-inspector");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected void componentActivated() {
        this.attachActions();
    }

    protected void componentDeactivated() {
        this.detachActions();
    }

    synchronized void attachActions() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.updatePasteAction();
        Clipboard c = this.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            if (this.clipboardListener == null) {
                this.clipboardListener = new ClipboardChangesListener();
            }
            clip.addClipboardListener(this.clipboardListener);
        }
    }

    synchronized void detachActions() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        Clipboard c = this.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener(this.clipboardListener);
        }
    }

    public void focusForm(FormEditor form) {
        if (this.focusedForm != form) {
            this.focusFormInAwtThread(form, 0);
        }
    }

    public void focusForm(FormEditor form, boolean visible) {
        if (this.focusedForm != form) {
            this.focusFormInAwtThread(form, visible ? 1 : -1);
        }
    }

    private void focusFormInAwtThread(final FormEditor form, final int visibility) {
        if (EventQueue.isDispatchThread()) {
            this.focusFormImpl(form, visibility);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentInspector.this.focusFormImpl(form, visibility);
                }
            });
        }
    }

    private void focusFormImpl(FormEditor form, int visibility) {
        this.focusedForm = form;
        if (form == null || form.getFormDesigner() == null) {
            this.testAction.setFormDesigner(null);
            PaletteUtils.setContext(null);
            this.removeAll();
            this.createComponents();
            this.revalidate();
            this.getExplorerManager().setRootContext((Node)this.emptyInspectorNode);
        } else {
            Node[] selectedNodes = form.getFormDesigner().getSelectedComponentNodes();
            this.testAction.setFormDesigner(form.getFormDesigner());
            PaletteUtils.setContext(form.getFormDataObject().getPrimaryFile());
            FormNode formNode = form.getFormRootNode();
            if (formNode == null) {
                System.err.println("Warning: FormEditorSupport.getFormRootNode() returns null");
                this.getExplorerManager().setRootContext((Node)this.emptyInspectorNode);
            } else {
                this.getExplorerManager().setRootContext((Node)formNode);
            }
            try {
                this.getExplorerManager().setSelectedNodes(selectedNodes);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
        if (visibility > 0) {
            this.open();
        } else if (visibility < 0) {
            this.close();
        }
    }

    public FormEditor getFocusedForm() {
        return this.focusedForm;
    }

    void setSelectedNodes(Node[] nodes, FormEditor form) throws PropertyVetoException {
        if (form == this.focusedForm) {
            this.getExplorerManager().setSelectedNodes(nodes);
        }
    }

    public Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    private Node[] getSelectedRootNodes() {
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length > 1) {
            ArrayList<Node> list = new ArrayList<Node>(selected.length);
            for (int i = 0; i < selected.length; ++i) {
                Node node = selected[i];
                boolean subcontained = false;
                for (int j = 0; j < selected.length; ++j) {
                    if (j == i || !ComponentInspector.isSubcontainedNode(node, selected[j])) continue;
                    subcontained = true;
                    break;
                }
                if (subcontained) continue;
                list.add(node);
            }
            if (list.size() < selected.length) {
                selected = list.toArray(new Node[list.size()]);
            }
        }
        return selected;
    }

    private static boolean isSubcontainedNode(Node node, Node maybeParent) {
        RADComponent comp;
        RADComponentCookie cookie = (RADComponentCookie)node.getCookie(RADComponentCookie.class);
        RADComponent rADComponent = comp = cookie != null ? cookie.getRADComponent() : null;
        if (comp != null) {
            RADComponent parentComp;
            cookie = (RADComponentCookie)maybeParent.getCookie(RADComponentCookie.class);
            RADComponent rADComponent2 = parentComp = cookie != null ? cookie.getRADComponent() : null;
            if (parentComp != null && parentComp.isParentComponent(comp)) {
                return true;
            }
        }
        return false;
    }

    private void updatePasteAction() {
        if (EventQueue.isDispatchThread()) {
            this.updatePasteActionInAwtThread();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentInspector.this.updatePasteActionInAwtThread();
                }
            });
        }
    }

    private void updatePasteActionInAwtThread() {
        Clipboard clipboard;
        Transferable trans;
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length >= 1 && (trans = (clipboard = this.getClipboard()).getContents((Object)this)) != null) {
            Node node = selected[0];
            PasteType[] pasteTypes = node.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                this.pasteAction.setPasteTypes(pasteTypes);
                return;
            }
            boolean multiFlavor = false;
            try {
                multiFlavor = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (multiFlavor) {
                try {
                    int i;
                    MultiTransferObject mto = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int n = mto.getCount();
                    Transferable[] t = new Transferable[n];
                    PasteType[] p = new PasteType[n];
                    for (i = 0; i < n; ++i) {
                        t[i] = mto.getTransferableAt(i);
                        pasteTypes = node.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) break;
                        p[i] = pasteTypes[0];
                    }
                    if (i == n) {
                        this.pasteAction.setPasteTypes(new PasteType[]{new MultiPasteType(t, p)});
                        return;
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
        this.pasteAction.setPasteTypes(null);
    }

    private Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return ComponentInspector.getDefault();
        }
    }

    private static class EmptyInspectorNode
    extends AbstractNode {
        public EmptyInspectorNode() {
            super(Children.LEAF);
            this.setIconBaseWithExtension(ComponentInspector.EMPTY_INSPECTOR_ICON_BASE);
        }

        public boolean canRename() {
            return false;
        }
    }

    private static class MultiPasteType
    extends PasteType
    implements Mutex.ExceptionAction<Transferable> {
        private Transferable[] transIn;
        private PasteType[] pasteTypes;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.transIn = t;
            this.pasteTypes = p;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Transferable run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            Transferable[] transOut = new Transferable[this.transIn.length];
            for (int i = 0; i < this.pasteTypes.length; ++i) {
                Transferable newTrans = this.pasteTypes[i].paste();
                transOut[i] = newTrans != null ? newTrans : this.transIn[i];
            }
            return new ExTransferable.Multi(transOut);
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copy;

        public CopyCutActionPerformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
            Transferable trans;
            Node[] selected = ComponentInspector.this.getSelectedRootNodes();
            if (selected == null || selected.length == 0) {
                trans = null;
            } else if (selected.length == 1) {
                trans = this.getTransferableOwner(selected[0]);
            } else {
                Transferable[] transArray = new Transferable[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    transArray[i] = this.getTransferableOwner(selected[i]);
                    if (transArray[i] != null) continue;
                    return;
                }
                trans = new ExTransferable.Multi(transArray);
            }
            if (trans != null) {
                Clipboard clipboard = ComponentInspector.this.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copy ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer,
    Mutex.Action<Object> {
        private Node[] nodesToDestroy;

        private DeleteActionPerformer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
            Node[] selected = ComponentInspector.this.getSelectedRootNodes();
            if (selected == null || selected.length == 0) {
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                if (selected[i].canDestroy()) continue;
                return;
            }
            try {
                ComponentInspector.this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.nodesToDestroy = selected;
            if (EventQueue.isDispatchThread()) {
                this.doDelete();
            } else {
                Mutex.EVENT.readAccess((Mutex.Action)this);
            }
        }

        public Object run() {
            this.doDelete();
            return null;
        }

        private void doDelete() {
            if (this.nodesToDestroy != null) {
                for (int i = 0; i < this.nodesToDestroy.length; ++i) {
                    try {
                        this.nodesToDestroy[i].destroy();
                        continue;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.nodesToDestroy = null;
            }
        }
    }

    private class ClipboardChangesListener
    implements ClipboardListener {
        private ClipboardChangesListener() {
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ComponentInspector.this.updatePasteAction();
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener,
    ActionListener,
    Runnable {
        private Timer timer = new Timer(150, this);

        NodeSelectionListener() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FormDesigner designer;
            if (!"selectedNodes".equals(evt.getPropertyName())) {
                return;
            }
            if (ComponentInspector.this.focusedForm == null || (designer = ComponentInspector.this.focusedForm.getFormDesigner()) == null) {
                return;
            }
            Node[] selectedNodes = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            if (designer.getDesignerMode() == 1) {
                if (selectedNodes.length > 0) {
                    RADComponentCookie cookie = (RADComponentCookie)selectedNodes[0].getCookie(RADComponentCookie.class);
                    if (cookie != null && cookie.getRADComponent() == designer.getConnectionSource() && selectedNodes.length > 1) {
                        cookie = (RADComponentCookie)selectedNodes[selectedNodes.length - 1].getCookie(RADComponentCookie.class);
                    }
                    if (cookie != null) {
                        designer.connectBean(cookie.getRADComponent(), true);
                    }
                }
            } else if (evt.getSource() == ComponentInspector.this.getExplorerManager()) {
                designer.clearSelectionImpl();
                for (int i = 0; i < selectedNodes.length; ++i) {
                    Node node;
                    FormCookie formCookie = (FormCookie)selectedNodes[i].getCookie(FormCookie.class);
                    if (formCookie == null || !((node = formCookie.getOriginalNode()) instanceof RADComponentNode)) continue;
                    designer.addComponentToSelectionImpl(((RADComponentNode)node).getRADComponent());
                }
                designer.repaintSelection();
            }
            for (int i = 0; i < selectedNodes.length; ++i) {
                ((FormNode)selectedNodes[i]).updateCookies();
            }
            this.timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            FormDesigner designer;
            Node[] selectedNodes = ComponentInspector.this.getExplorerManager().getSelectedNodes();
            ComponentInspector.this.setActivatedNodes(selectedNodes);
            FormDesigner formDesigner = designer = ComponentInspector.this.focusedForm != null ? ComponentInspector.this.focusedForm.getFormDesigner() : null;
            if (designer != null) {
                designer.setActivatedNodes(selectedNodes);
            }
            ComponentInspector.this.updatePasteAction();
            this.timer.stop();
        }
    }
}

