/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.TextField;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.Separator;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.editors2.TableModelEditor;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutBuilder;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.LayoutSupportRegistry;
import org.netbeans.modules.form.palette.BoxFillerInitializer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

public class MetaComponentCreator {
    private FormModel formModel;
    private RADVisualComponent preMetaComp;
    private LayoutComponent preLayoutComp;

    MetaComponentCreator(FormModel model) {
        this.formModel = model;
    }

    public RADComponent createComponent(PaletteItem paletteItem, RADComponent targetComp, Object constraints) {
        RADComponent metaComp = this.createComponent(paletteItem.getComponentClassSource(), targetComp, constraints);
        String initializerId = paletteItem.getInitializerId();
        this.initializeNewComponent(metaComp, initializerId);
        return metaComp;
    }

    public RADComponent createComponent(ClassSource classSource, RADComponent targetComp, Object constraints) {
        return this.createComponent(classSource, targetComp, constraints, true);
    }

    RADComponent createComponent(ClassSource classSource, RADComponent targetComp, Object constraints, boolean exactTargetMatch) {
        Class compClass = this.prepareClass(classSource);
        if (compClass == null) {
            return null;
        }
        RADComponent metacomp = this.createAndAddComponent(compClass, targetComp, constraints, exactTargetMatch);
        String typeParams = classSource.getTypeParameters();
        if (typeParams != null) {
            metacomp.setAuxValue("JavaCodeGenerator_TypeParameters", typeParams);
            JavaCodeGenerator.setupComponentFromAuxValues(metacomp);
        }
        return metacomp;
    }

    public RADComponent copyComponent(final RADComponent sourceComp, RADComponent targetComp) {
        final TargetInfo target = MetaComponentCreator.getTargetInfo(sourceComp.getBeanClass(), targetComp, false, false);
        if (target == null) {
            return null;
        }
        try {
            return (RADComponent)FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    return MetaComponentCreator.this.copyComponent2(sourceComp, null, target);
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public boolean moveComponent(RADComponent metacomp, RADComponent targetComp) {
        TargetInfo target = MetaComponentCreator.getTargetInfo(metacomp.getBeanClass(), targetComp, false, false);
        if (target == null) {
            return false;
        }
        this.formModel.removeComponent(metacomp, false);
        return this.copyComponent2(metacomp, metacomp, target) != null;
    }

    public boolean addComponents(Collection<RADComponent> components, RADComponent targetComp) {
        for (RADComponent metacomp : components) {
            TargetInfo target = MetaComponentCreator.getTargetInfo(metacomp.getBeanClass(), targetComp, false, false);
            if (target == null) {
                return false;
            }
            this.copyComponent2(metacomp, metacomp, target);
        }
        return true;
    }

    public static boolean canAddComponent(Class beanClass, RADComponent targetComp) {
        TargetInfo target = MetaComponentCreator.getTargetInfo(beanClass, targetComp, false, false);
        return target != null && (target.targetType == TargetType.OTHER || target.targetType == TargetType.MENU || target.targetType == TargetType.VISUAL);
    }

    public static boolean canApplyComponent(Class beanClass, RADComponent targetComp) {
        TargetInfo target = MetaComponentCreator.getTargetInfo(beanClass, targetComp, false, false);
        return target != null && (target.targetType == TargetType.BORDER || target.targetType == TargetType.LAYOUT);
    }

    public RADVisualComponent precreateVisualComponent(final ClassSource classSource) {
        final Class compClass = this.prepareClass(classSource);
        if (compClass == null || Window.class.isAssignableFrom(compClass) || Applet.class.isAssignableFrom(compClass) || JPopupMenu.class.isAssignableFrom(compClass) || !FormUtils.isVisualizableClass(compClass)) {
            return null;
        }
        if (this.preMetaComp != null) {
            this.releasePrecreatedComponent();
        }
        try {
            FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    MetaComponentCreator.this.preMetaComp = MetaComponentCreator.this.createVisualComponent(compClass);
                    String typeParams = classSource.getTypeParameters();
                    if (typeParams != null) {
                        MetaComponentCreator.this.preMetaComp.setAuxValue("JavaCodeGenerator_TypeParameters", typeParams);
                        JavaCodeGenerator.setupComponentFromAuxValues(MetaComponentCreator.this.preMetaComp);
                    }
                    return MetaComponentCreator.this.preMetaComp;
                }
            });
            return this.preMetaComp;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public RADVisualComponent precreateVisualComponent(PaletteItem paletteItem) {
        RADVisualComponent metaComp = this.precreateVisualComponent(paletteItem.getComponentClassSource());
        String initializerId = paletteItem.getInitializerId();
        this.initializeNewComponent(metaComp, initializerId);
        return metaComp;
    }

    private void initializeNewComponent(RADComponent metaComp, String initializerId) {
        if (initializerId == null) {
            return;
        }
        if (initializerId.startsWith("Box.Filler")) {
            new BoxFillerInitializer(metaComp, initializerId).initialize();
        }
    }

    public RADVisualComponent getPrecreatedMetaComponent() {
        return this.preMetaComp;
    }

    public LayoutComponent getPrecreatedLayoutComponent() {
        if (this.preMetaComp != null) {
            if (this.preLayoutComp == null) {
                this.preLayoutComp = this.createLayoutComponent(this.preMetaComp);
            }
            return this.preLayoutComp;
        }
        return null;
    }

    LayoutComponent createLayoutComponent(RADVisualComponent metacomp) {
        LayoutDesigner ld;
        Dimension initialSize = this.prepareDefaultLayoutSize((Component)metacomp.getBeanInstance(), metacomp instanceof RADVisualContainer);
        boolean isLayoutContainer = MetaComponentCreator.shouldBeLayoutContainer(metacomp);
        if (isLayoutContainer) {
            RADVisualContainer metacont = (RADVisualContainer)metacomp;
            Container cont = metacont.getContainerDelegate(metacont.getBeanInstance());
            if (initialSize == null) {
                initialSize = cont.getPreferredSize();
            }
            Insets insets = cont.getInsets();
            initialSize.width -= insets.left + insets.right;
            initialSize.height -= insets.top + insets.bottom;
            initialSize.width = Math.max(initialSize.width, 0);
            initialSize.height = Math.max(initialSize.height, 0);
        }
        if (metacomp == this.preMetaComp && (ld = FormEditor.getFormDesigner(this.formModel).getLayoutDesigner()) != null && ld.logTestCode()) {
            if (initialSize == null) {
                ld.testCode.add("lc = new LayoutComponent(\"" + metacomp.getId() + "\", " + isLayoutContainer + ");");
            } else {
                ld.testCode.add("lc = new LayoutComponent(\"" + metacomp.getId() + "\", " + isLayoutContainer + ", " + initialSize.width + ", " + initialSize.height + ");");
            }
        }
        return initialSize == null ? new LayoutComponent(metacomp.getId(), isLayoutContainer) : new LayoutComponent(metacomp.getId(), isLayoutContainer, initialSize.width, initialSize.height);
    }

    static boolean shouldBeLayoutContainer(RADComponent metacomp) {
        return metacomp instanceof RADVisualContainer && ((RADVisualContainer)metacomp).getLayoutSupport() == null;
    }

    public boolean addPrecreatedComponent(RADComponent targetComp, Object constraints) {
        if (this.preMetaComp == null) {
            return false;
        }
        if (this.checkFormClass(this.preMetaComp.getBeanClass())) {
            TargetInfo target = MetaComponentCreator.getTargetInfo(this.preMetaComp.getBeanClass(), targetComp, true, true);
            if (target != null && (target.targetType == TargetType.VISUAL || target.targetType == TargetType.OTHER)) {
                this.addVisualComponent2(this.preMetaComp, target.targetComponent, constraints, true);
                ResourceSupport.switchComponentToResources(this.preMetaComp);
            }
            this.releasePrecreatedComponent();
            return true;
        }
        this.releasePrecreatedComponent();
        return false;
    }

    void releasePrecreatedComponent() {
        if (this.preMetaComp != null) {
            this.preMetaComp = null;
            this.preLayoutComp = null;
        }
    }

    private RADComponent createAndAddComponent(final Class compClass, RADComponent targetComp, final Object constraints, boolean exactTargetMatch) {
        if (!this.checkFormClass(compClass)) {
            return null;
        }
        final TargetInfo target = MetaComponentCreator.getTargetInfo(compClass, targetComp, !exactTargetMatch, !exactTargetMatch);
        if (target == null) {
            return null;
        }
        try {
            return (RADComponent)FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    return MetaComponentCreator.this.createAndAddComponent2(compClass, target, constraints);
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    private RADComponent createAndAddComponent2(Class compClass, TargetInfo target, Object constraints) {
        RADComponent targetComp = target.targetComponent;
        if (target.targetType == TargetType.LAYOUT) {
            return this.setContainerLayout(compClass, targetComp);
        }
        if (target.targetType == TargetType.BORDER) {
            return this.setComponentBorder(compClass, targetComp);
        }
        RADComponent newMetaComp = null;
        newMetaComp = target.componentType == ComponentType.MENU ? this.addMenuComponent(compClass, targetComp) : (target.componentType == ComponentType.VISUAL ? this.addVisualComponent(compClass, targetComp, constraints) : this.addOtherComponent(compClass, targetComp));
        if (newMetaComp instanceof RADVisualComponent && !((RADVisualComponent)newMetaComp).isMenuComponent() && (MetaComponentCreator.shouldBeLayoutContainer(targetComp) || MetaComponentCreator.shouldBeLayoutContainer(newMetaComp))) {
            this.createAndAddLayoutComponent((RADVisualComponent)newMetaComp, (RADVisualContainer)targetComp);
        }
        if (newMetaComp != null) {
            ResourceSupport.switchComponentToResources(newMetaComp);
        }
        return newMetaComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndAddLayoutComponent(RADVisualComponent radComp, RADVisualContainer targetCont) {
        LayoutComponent layoutComp = this.createLayoutComponent(radComp);
        String targetContId = MetaComponentCreator.shouldBeLayoutContainer(targetCont) ? targetCont.getId() : null;
        UndoableEdit ue = this.formModel.getLayoutModel().getUndoableEdit();
        boolean autoUndo = true;
        try {
            FormEditor.getFormDesigner(this.formModel).getLayoutDesigner().addUnspecifiedComponent(layoutComp, targetContId);
            autoUndo = false;
        }
        finally {
            this.formModel.addUndoableEdit(ue);
            if (autoUndo) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
    }

    private RADComponent copyComponent2(RADComponent sourceComp, RADComponent copiedComp, TargetInfo target) {
        boolean newlyAdded;
        RADComponent targetComp = target.targetComponent;
        if (target.targetType == TargetType.LAYOUT) {
            return this.copyAndApplyLayout(sourceComp, targetComp);
        }
        if (target.targetType == TargetType.BORDER) {
            return this.copyAndApplyBorder(sourceComp, targetComp);
        }
        if (sourceComp instanceof RADVisualComponent) {
            LayoutSupportManager.storeConstraints((RADVisualComponent)sourceComp);
        }
        if (copiedComp == null) {
            copiedComp = this.makeCopy(sourceComp);
            if (copiedComp == null) {
                return null;
            }
            ResourceSupport.switchComponentToResources(copiedComp);
            newlyAdded = true;
        } else {
            newlyAdded = false;
        }
        if (target.targetType == TargetType.MENU) {
            this.addMenuComponent(copiedComp, targetComp, newlyAdded);
        } else if (target.targetType == TargetType.VISUAL) {
            RADVisualContainer targetCont;
            LayoutSupportManager layoutSupport;
            RADVisualComponent newVisual = (RADVisualComponent)copiedComp;
            LayoutConstraints constraints = targetComp != null ? ((layoutSupport = (targetCont = (RADVisualContainer)targetComp).getLayoutSupport()) == null ? null : layoutSupport.getStoredConstraints(newVisual)) : null;
            copiedComp = this.addVisualComponent2(newVisual, targetComp, constraints, newlyAdded);
        } else if (target.targetType == TargetType.OTHER) {
            this.addOtherComponent(copiedComp, targetComp, newlyAdded);
        }
        return copiedComp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TargetInfo getTargetInfo(Class beanClass, RADComponent targetComp, boolean canUseParent, boolean defaultToOthers) {
        TargetInfo target = new TargetInfo();
        if (targetComp != null) {
            if (LayoutSupportDelegate.class.isAssignableFrom(beanClass) || LayoutManager.class.isAssignableFrom(beanClass)) {
                RADVisualContainer targetCont = MetaComponentCreator.getVisualContainer(targetComp, canUseParent);
                if (targetCont == null || targetCont.hasDedicatedLayoutSupport()) return null;
                target.targetType = TargetType.LAYOUT;
            } else if (Border.class.isAssignableFrom(beanClass)) {
                if (!(targetComp instanceof RADVisualComponent) || !JComponent.class.isAssignableFrom(targetComp.getBeanClass())) return null;
                target.targetType = TargetType.BORDER;
            } else if (MenuComponent.class.isAssignableFrom(beanClass) || Separator.class.isAssignableFrom(beanClass)) {
                if (targetComp instanceof RADMenuComponent) {
                    if (!((RADMenuComponent)targetComp).canAddItem(beanClass)) return null;
                    target.targetType = TargetType.MENU;
                } else {
                    RADVisualContainer targetCont = MetaComponentCreator.getVisualContainer(targetComp, canUseParent);
                    while (targetCont != null) {
                        if (targetCont.getContainerMenu() != null) {
                            if (!defaultToOthers) return null;
                            targetCont = null;
                            continue;
                        }
                        if (targetCont.canHaveMenu(beanClass)) {
                            target.targetType = TargetType.MENU;
                            targetComp = targetCont;
                            break;
                        }
                        if (canUseParent) {
                            targetCont = targetCont.getParentContainer();
                            continue;
                        }
                        targetCont = null;
                    }
                    if (targetCont == null) {
                        if (!defaultToOthers || Separator.class.isAssignableFrom(beanClass)) return null;
                        targetComp = null;
                    }
                }
            } else if (FormUtils.isVisualizableClass(beanClass)) {
                if (targetComp != null && (Window.class.isAssignableFrom(beanClass) || Applet.class.isAssignableFrom(beanClass) || !Component.class.isAssignableFrom(beanClass))) {
                    if (!defaultToOthers) return null;
                    targetComp = null;
                }
                RADVisualContainer targetCont = MetaComponentCreator.getVisualContainer(targetComp, canUseParent);
                while (targetCont != null) {
                    if (targetCont.canAddComponent(beanClass)) {
                        target.targetType = TargetType.VISUAL;
                        targetComp = targetCont;
                        break;
                    }
                    if (canUseParent) {
                        targetCont = targetCont.getParentContainer();
                        continue;
                    }
                    targetCont = null;
                }
                if (targetCont == null) {
                    if (!defaultToOthers) return null;
                    targetComp = null;
                }
            }
        }
        if (targetComp == null) {
            target.targetType = TargetType.OTHER;
        }
        target.targetComponent = targetComp;
        if (MenuComponent.class.isAssignableFrom(beanClass) || Separator.class.isAssignableFrom(beanClass)) {
            target.componentType = ComponentType.MENU;
            return target;
        } else if (FormUtils.isVisualizableClass(beanClass)) {
            target.componentType = ComponentType.VISUAL;
            return target;
        } else {
            target.componentType = ComponentType.NON_VISUAL;
        }
        return target;
    }

    private static RADVisualContainer getVisualContainer(RADComponent targetComp, boolean canUseParent) {
        if (targetComp instanceof RADVisualContainer) {
            return (RADVisualContainer)targetComp;
        }
        if (canUseParent && targetComp instanceof RADVisualComponent) {
            return (RADVisualContainer)targetComp.getParentComponent();
        }
        return null;
    }

    static boolean isTransparentLayoutComponent(RADComponent metacomp) {
        return metacomp != null && metacomp.getBeanClass() == JScrollPane.class && metacomp.getAuxValue("autoScrollPane") != null;
    }

    private RADComponent makeCopy(RADComponent sourceComp) {
        Map<String, Object> auxValues;
        RADComponent newComp = sourceComp instanceof RADVisualContainer ? new RADVisualContainer() : (sourceComp instanceof RADVisualComponent ? new RADVisualComponent() : (sourceComp instanceof RADMenuComponent ? new RADMenuComponent() : (sourceComp instanceof RADMenuItemComponent ? new RADMenuItemComponent() : new RADComponent())));
        newComp.initialize(this.formModel);
        if (sourceComp != sourceComp.getFormModel().getTopRADComponent()) {
            newComp.setStoredName(sourceComp.getName());
        }
        try {
            newComp.initInstance(sourceComp.getBeanClass());
            newComp.setInModel(true);
        }
        catch (Exception ex) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)ex, FormUtils.getBundleString("MSG_ERR_CannotCopyInstance"));
            em.notify((Throwable)ex);
            return null;
        }
        if (sourceComp instanceof ComponentContainer) {
            RADComponent[] sourceSubs = ((ComponentContainer)((Object)sourceComp)).getSubBeans();
            RADComponent[] newSubs = new RADComponent[sourceSubs.length];
            for (int i = 0; i < sourceSubs.length; ++i) {
                RADComponent newSubComp = this.makeCopy(sourceSubs[i]);
                if (newSubComp == null) {
                    return null;
                }
                newSubs[i] = newSubComp;
            }
            ((ComponentContainer)((Object)newComp)).initSubComponents(newSubs);
            if (sourceComp instanceof RADVisualContainer) {
                RADVisualComponent[] newComps = new RADVisualComponent[newSubs.length];
                System.arraycopy(newSubs, 0, newComps, 0, newSubs.length);
                LayoutSupportManager sourceLayout = ((RADVisualContainer)sourceComp).getLayoutSupport();
                if (sourceLayout != null) {
                    RADVisualContainer newCont = (RADVisualContainer)newComp;
                    newCont.setOldLayoutSupport(true);
                    newCont.getLayoutSupport().copyLayoutDelegateFrom(sourceLayout, newComps);
                } else {
                    HashMap<String, String> sourceToTargetIds = new HashMap<String, String>(sourceSubs.length);
                    for (int i = 0; i < sourceSubs.length; ++i) {
                        sourceToTargetIds.put(sourceSubs[i].getId(), newSubs[i].getId());
                    }
                    LayoutModel sourceLayoutModel = sourceComp.getFormModel().getLayoutModel();
                    String sourceContainerId = sourceComp.getId();
                    String targetContainerId = newComp.getId();
                    this.formModel.getLayoutModel().copyContainerLayout(sourceLayoutModel, sourceContainerId, sourceToTargetIds, targetContainerId);
                }
            }
        }
        ArrayList<RADProperty> sourceList = new ArrayList<RADProperty>();
        ArrayList<String> namesList = new ArrayList<String>();
        Iterator<RADProperty> it = sourceComp.getBeanPropertiesIterator(ResourceSupport.COPIED_PROPERTY_FILTER, false);
        while (it.hasNext()) {
            RADProperty prop = it.next();
            sourceList.add(prop);
            namesList.add(prop.getName());
        }
        Node.Property[] sourceProps = new RADProperty[sourceList.size()];
        sourceList.toArray(sourceProps);
        String[] propNames = new String[namesList.size()];
        namesList.toArray(propNames);
        Node.Property[] newProps = newComp.getBeanProperties(propNames);
        int copyMode = 2;
        if (this.formModel == sourceComp.getFormModel()) {
            copyMode |= 4;
        }
        FormUtils.copyProperties(sourceProps, newProps, copyMode);
        if (newComp instanceof RADMenuItemComponent) {
            this.formModel.fireComponentPropertyChanged(newComp, null, null, null);
        }
        if ((auxValues = sourceComp.getAuxValues()) != null) {
            for (Map.Entry<String, Object> entry : auxValues.entrySet()) {
                String auxName = entry.getKey();
                Object auxValue = entry.getValue();
                try {
                    newComp.setAuxValue(auxName, FormUtils.cloneObject(auxValue, this.formModel));
                }
                catch (Exception e) {}
            }
            JavaCodeGenerator.setupComponentFromAuxValues(newComp);
        }
        if (sourceComp instanceof RADVisualComponent && newComp instanceof RADVisualComponent) {
            Map<String, LayoutConstraints> constraints = ((RADVisualComponent)sourceComp).getConstraintsMap();
            HashMap<String, LayoutConstraints> newConstraints = new HashMap<String, LayoutConstraints>();
            for (Map.Entry<String, LayoutConstraints> entry : constraints.entrySet()) {
                String layoutClassName = entry.getKey();
                LayoutConstraints clonedConstr = entry.getValue().cloneConstraints();
                newConstraints.put(layoutClassName, clonedConstr);
            }
            ((RADVisualComponent)newComp).setConstraintsMap(newConstraints);
        }
        Event[] sourceEvents = sourceComp.getKnownEvents();
        String[] eventNames = new String[sourceEvents.length];
        String[][] eventHandlers = new String[sourceEvents.length][];
        for (int eventsIdx = 0; eventsIdx < sourceEvents.length; ++eventsIdx) {
            eventNames[eventsIdx] = sourceEvents[eventsIdx].getName();
            eventHandlers[eventsIdx] = sourceEvents[eventsIdx].getEventHandlers();
        }
        FormEvents formEvents = this.formModel.getFormEvents();
        Event[] targetEvents = newComp.getEvents(eventNames);
        for (int targetEventsIdx = 0; targetEventsIdx < targetEvents.length; ++targetEventsIdx) {
            Event targetEvent = targetEvents[targetEventsIdx];
            if (targetEvent == null) continue;
            String[] handlers = eventHandlers[targetEventsIdx];
            for (int handlersIdx = 0; handlersIdx < handlers.length; ++handlersIdx) {
                String oldHandlerName = handlers[handlersIdx];
                String sourceVariableName = sourceComp.getName();
                String targetVariableName = newComp.getName();
                int idx = oldHandlerName.indexOf(sourceVariableName);
                String newHandlerName = idx >= 0 ? oldHandlerName.substring(0, idx) + targetVariableName + oldHandlerName.substring(idx + sourceVariableName.length()) : targetVariableName + oldHandlerName;
                newHandlerName = formEvents.findFreeHandlerName(newHandlerName);
                String bodyText = null;
                if (sourceComp.getFormModel() != this.formModel) {
                    JavaCodeGenerator javaCodeGenerator = (JavaCodeGenerator)FormEditor.getCodeGenerator(sourceComp.getFormModel());
                    bodyText = javaCodeGenerator.getEventHandlerText(oldHandlerName);
                }
                try {
                    formEvents.attachEvent(targetEvent, newHandlerName, bodyText);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return newComp;
    }

    private RADComponent addVisualComponent(Class compClass, RADComponent targetComp, Object constraints) {
        RADVisualComponent newMetaComp = this.createVisualComponent(compClass);
        if (Window.class.isAssignableFrom(compClass) || Applet.class.isAssignableFrom(compClass)) {
            targetComp = null;
        }
        return this.addVisualComponent2(newMetaComp, targetComp, constraints, true);
    }

    private RADVisualComponent createVisualComponent(Class compClass) {
        RADVisualContainer newMetaCont;
        RADVisualComponent newMetaComp = null;
        RADVisualContainer rADVisualContainer = newMetaCont = FormUtils.isContainer(compClass) ? new RADVisualContainer() : null;
        while (newMetaComp == null) {
            newMetaComp = newMetaCont == null ? new RADVisualComponent() : newMetaCont;
            newMetaComp.initialize(this.formModel);
            if (!this.initComponentInstance(newMetaComp, compClass)) {
                return null;
            }
            if (newMetaCont == null) break;
            boolean knownLayout = false;
            Throwable layoutEx = null;
            try {
                newMetaCont.setOldLayoutSupport(true);
                LayoutSupportManager laysup = newMetaCont.getLayoutSupport();
                knownLayout = laysup.prepareLayoutDelegate(false, false);
                if (knownLayout && !laysup.isDedicated() && !laysup.isSpecialLayout() && this.formModel.isFreeDesignDefaultLayout() || !knownLayout && SwingLayoutBuilder.isRelevantContainer(laysup.getPrimaryContainerDelegate())) {
                    newMetaCont.setOldLayoutSupport(false);
                    FormEditor.updateProjectForNaturalLayout(this.formModel);
                    knownLayout = true;
                }
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                newMetaComp = null;
                newMetaCont = null;
                continue;
            }
            catch (Exception ex) {
                layoutEx = ex;
            }
            catch (LinkageError ex) {
                layoutEx = ex;
            }
            if (knownLayout) continue;
            if (layoutEx == null) {
                System.err.println("[WARNING] No layout support found for " + compClass.getName());
                System.err.println("          Just a limited basic support will be used.");
            } else {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate(layoutEx, FormUtils.getBundleString("MSG_ERR_LayoutInitFailed2"));
                em.notify(layoutEx);
            }
            newMetaCont.getLayoutSupport().setUnknownLayoutDelegate(false);
        }
        newMetaComp.setStoredName(this.formModel.getCodeStructure().getExternalVariableName(compClass, null, false));
        return (RADVisualComponent)this.defaultVisualComponentInit(newMetaComp);
    }

    private RADVisualComponent addVisualComponent2(RADVisualComponent newMetaComp, RADComponent targetComp, Object constraints, boolean newlyAdded) {
        Object bean;
        if (targetComp != null && JScrollPane.class.isAssignableFrom(targetComp.getBeanClass()) && (bean = newMetaComp.getBeanInstance()) instanceof JScrollPane && newMetaComp.getAuxValue("autoScrollPane") != null) {
            RADVisualContainer metaCont = (RADVisualContainer)newMetaComp;
            newMetaComp = metaCont.getSubComponent(0);
        }
        RADVisualContainer parentCont = targetComp != null ? (targetComp instanceof RADVisualContainer ? (RADVisualContainer)targetComp : (RADVisualContainer)targetComp.getParentComponent()) : null;
        MetaComponentCreator.defaultTargetInit(newMetaComp, parentCont);
        if (parentCont != null) {
            try {
                this.formModel.addVisualComponent(newMetaComp, parentCont, constraints, newlyAdded);
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        } else {
            this.formModel.addComponent(newMetaComp, null, newlyAdded);
        }
        return newMetaComp;
    }

    private RADComponent addOtherComponent(Class compClass, RADComponent targetComp) {
        RADComponent newMetaComp = new RADComponent();
        newMetaComp.initialize(this.formModel);
        if (!this.initComponentInstance(newMetaComp, compClass)) {
            return null;
        }
        this.addOtherComponent(newMetaComp, targetComp, true);
        return newMetaComp;
    }

    private void addOtherComponent(RADComponent newMetaComp, RADComponent targetComp, boolean newlyAdded) {
        ComponentContainer targetCont;
        ComponentContainer componentContainer = targetCont = targetComp instanceof ComponentContainer && !(targetComp instanceof RADVisualContainer) && !(targetComp instanceof RADMenuComponent) ? (ComponentContainer)((Object)targetComp) : null;
        if (!newlyAdded && newMetaComp instanceof RADVisualComponent) {
            ((RADVisualComponent)newMetaComp).resetConstraintsProperties();
        }
        this.formModel.addComponent(newMetaComp, targetCont, newlyAdded);
    }

    private RADComponent setContainerLayout(Class layoutClass, RADComponent targetComp) {
        String msg;
        RADVisualContainer metacont;
        if (targetComp instanceof RADVisualContainer) {
            metacont = (RADVisualContainer)targetComp;
        } else {
            metacont = (RADVisualContainer)targetComp.getParentComponent();
            if (metacont == null) {
                return null;
            }
        }
        LayoutSupportDelegate layoutDelegate = null;
        Throwable t = null;
        try {
            if (LayoutManager.class.isAssignableFrom(layoutClass)) {
                layoutDelegate = LayoutSupportRegistry.getRegistry(this.formModel).createSupportForLayout(layoutClass);
            } else if (LayoutSupportDelegate.class.isAssignableFrom(layoutClass)) {
                layoutDelegate = LayoutSupportRegistry.createSupportInstance(layoutClass);
            }
        }
        catch (Exception ex) {
            t = ex;
        }
        catch (LinkageError ex) {
            t = ex;
        }
        if (t != null) {
            msg = FormUtils.getFormattedBundleString("FMT_ERR_LayoutInit", new Object[]{layoutClass.getName()});
            ErrorManager em = ErrorManager.getDefault();
            em.annotate(t, msg);
            em.notify(t);
            return null;
        }
        if (layoutDelegate == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getFormattedBundleString("FMT_ERR_LayoutNotFound", new Object[]{layoutClass.getName()}), 2));
            return null;
        }
        try {
            this.formModel.setContainerLayout(metacont, layoutDelegate);
        }
        catch (Exception ex) {
            t = ex;
        }
        catch (LinkageError ex) {
            t = ex;
        }
        if (t != null) {
            msg = FormUtils.getFormattedBundleString("FMT_ERR_LayoutInit", new Object[]{layoutClass.getName()});
            ErrorManager em = ErrorManager.getDefault();
            em.annotate(t, msg);
            em.notify(t);
            return null;
        }
        return metacont;
    }

    private RADComponent copyAndApplyLayout(RADComponent sourceComp, RADComponent targetComp) {
        try {
            RADVisualContainer targetCont = (RADVisualContainer)this.setContainerLayout(sourceComp.getBeanClass(), targetComp);
            Node.Property[] sourceProps = sourceComp.getKnownBeanProperties();
            Node.Property[] targetProps = targetCont.getLayoutSupport().getAllProperties();
            int copyMode = 3;
            if (this.formModel == sourceComp.getFormModel()) {
                copyMode |= 4;
            }
            FormUtils.copyProperties(sourceProps, targetProps, copyMode);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return targetComp;
    }

    private RADComponent setComponentBorder(Class borderClass, RADComponent targetComp) {
        FormProperty prop = this.getBorderProperty(targetComp);
        if (prop == null) {
            return null;
        }
        try {
            Object border = CreationFactory.createInstance(borderClass);
            prop.setValue(border);
        }
        catch (Exception ex) {
            MetaComponentCreator.showInstErrorMessage(ex);
            return null;
        }
        catch (LinkageError ex) {
            MetaComponentCreator.showInstErrorMessage(ex);
            return null;
        }
        FormDesigner designer = FormEditor.getFormDesigner(this.formModel);
        if (designer != null) {
            designer.setSelectedComponent(targetComp);
        }
        return targetComp;
    }

    private void setComponentBorderProperty(Object borderInstance, RADComponent targetComp) {
        FormProperty prop = this.getBorderProperty(targetComp);
        if (prop == null) {
            return;
        }
        try {
            prop.setValue(borderInstance);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        FormDesigner designer = FormEditor.getFormDesigner(this.formModel);
        if (designer != null) {
            designer.setSelectedComponent(targetComp);
        }
    }

    private RADComponent copyAndApplyBorder(RADComponent sourceComp, RADComponent targetComp) {
        try {
            Border borderInstance = (Border)sourceComp.createBeanInstance();
            BorderDesignSupport designBorder = new BorderDesignSupport(borderInstance);
            Node.Property[] sourceProps = sourceComp.getKnownBeanProperties();
            Node.Property[] targetProps = designBorder.getProperties();
            int copyMode = 3;
            if (this.formModel == sourceComp.getFormModel()) {
                copyMode |= 4;
            }
            FormUtils.copyProperties(sourceProps, targetProps, copyMode);
            this.setComponentBorderProperty(designBorder, targetComp);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return targetComp;
    }

    private FormProperty getBorderProperty(RADComponent targetComp) {
        RADProperty prop;
        if (JComponent.class.isAssignableFrom(targetComp.getBeanClass()) && (prop = targetComp.getBeanProperty("border")) != null) {
            return prop;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_BorderNotApplicable"), 1));
        return null;
    }

    private RADComponent addMenuComponent(Class compClass, RADComponent targetComp) {
        int type;
        MenuItem menu;
        RADMenuItemComponent newMenuItemComp;
        RADMenuComponent newMenuComp;
        if ((RADMenuItemComponent.recognizeType(compClass) & 0x100) != 0) {
            newMenuComp = new RADMenuComponent();
            newMenuItemComp = newMenuComp;
        } else {
            newMenuComp = null;
            newMenuItemComp = new RADMenuItemComponent();
        }
        newMenuItemComp.initialize(this.formModel);
        if (!this.initComponentInstance(newMenuItemComp, compClass)) {
            return null;
        }
        if (newMenuComp != null) {
            newMenuComp.initSubComponents(new RADComponent[0]);
        }
        if (newMenuItemComp.getBeanInstance() instanceof MenuItem && "".equals((menu = (MenuItem)newMenuItemComp.getBeanInstance()).getLabel())) {
            newMenuItemComp.createCodeExpression();
            RADProperty prop = newMenuItemComp.getBeanProperty("label");
            try {
                prop.setChangeFiring(false);
                prop.setValue(newMenuItemComp.getName());
                prop.setChangeFiring(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.addMenuComponent(newMenuItemComp, targetComp, true);
        if (newMenuComp != null && (type = newMenuComp.getMenuItemType()) == 4368) {
            NewType[] newTypes = newMenuComp.getNewTypes();
            if (newTypes.length > 0) {
                try {
                    newTypes[0].create();
                    newTypes[0].create();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            RADComponent[] subComponents = newMenuComp.getSubBeans();
            String[] labelBundleKeys = new String[]{"CTL_DefaultFileMenu", "CTL_DefaultEditMenu"};
            if (subComponents.length > 1) {
                for (int i = 0; i < labelBundleKeys.length; ++i) {
                    RADProperty prop = subComponents[i].getBeanProperty("label");
                    try {
                        prop.setChangeFiring(false);
                        prop.setValue(FormUtils.getBundleString(labelBundleKeys[i]));
                        prop.setChangeFiring(true);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return newMenuItemComp;
    }

    private void addMenuComponent(RADComponent newMenuComp, RADComponent targetComp, boolean newlyAdded) {
        Class<? extends Object> beanClass = newMenuComp.getBeanClass();
        ComponentContainer menuContainer = null;
        if (targetComp instanceof RADMenuComponent) {
            if (newMenuComp instanceof RADMenuItemComponent && ((RADMenuComponent)targetComp).canAddItem(beanClass)) {
                menuContainer = (ComponentContainer)((Object)targetComp);
            }
        } else if (targetComp instanceof RADVisualComponent) {
            RADVisualContainer targetCont;
            RADVisualContainer rADVisualContainer = targetCont = targetComp instanceof RADVisualContainer ? (RADVisualContainer)targetComp : (RADVisualContainer)targetComp.getParentComponent();
            if (targetCont != null && targetCont.getContainerMenu() == null && targetCont.canHaveMenu(beanClass)) {
                menuContainer = targetCont;
            }
        }
        this.formModel.addComponent(newMenuComp, menuContainer, newlyAdded);
    }

    Class prepareClass(final ClassSource classSource) {
        if (!classSource.hasEntries()) {
            return this.prepareClass0(classSource);
        }
        try {
            return (Class)FormLAF.executeWithLookAndFeel(this.formModel, new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    Class clazz = MetaComponentCreator.this.prepareClass0(classSource);
                    if (clazz != null) {
                        BeanSupport.getDefaultInstance(clazz);
                    }
                    return clazz;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Class prepareClass0(ClassSource classSource) {
        Throwable error = null;
        FileObject formFile = FormEditor.getFormDataObject(this.formModel).getFormFile();
        String className = classSource.getClassName();
        Class<?> loadedClass = null;
        try {
            if (!ClassPathUtils.checkUserClass(className, formFile)) {
                if (ClassPathUtils.updateProject(formFile, classSource) == null) {
                    return null;
                }
                if (FormLAF.inLAFBlock()) {
                    FormLAF.setUseDesignerDefaults(null);
                    FormLAF.setUseDesignerDefaults(this.formModel);
                }
            }
            loadedClass = ClassPathUtils.loadClass(className, formFile);
        }
        catch (Exception ex) {
            error = ex;
        }
        catch (LinkageError ex) {
            error = ex;
        }
        if (loadedClass == null) {
            MetaComponentCreator.showClassLoadingErrorMessage(error, classSource);
        }
        return loadedClass;
    }

    private boolean checkFormClass(Class<?> compClass) {
        String formClassBinaryName;
        if (this.formModel.getFormBaseClass().isAssignableFrom(compClass) && (formClassBinaryName = MetaComponentCreator.getClassBinaryName(FormEditor.getFormDataObject(this.formModel).getPrimaryFile())).equals(compClass.getName())) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ERR_CannotAddForm"), 2));
            return false;
        }
        return true;
    }

    private static String getClassBinaryName(final FileObject fo) {
        final String[] result = new String[1];
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !fo.getName().equals(((ClassTree)tree).getSimpleName().toString())) continue;
                        TreePath classTreePath = controller.getTrees().getPath(controller.getCompilationUnit(), tree);
                        Element classElm = controller.getTrees().getElement(classTreePath);
                        result[0] = classElm != null ? controller.getElements().getBinaryName((TypeElement)classElm).toString() : "";
                        break;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Logger.getLogger(MetaComponentCreator.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return result[0];
    }

    private static void showClassLoadingErrorMessage(Throwable ex, ClassSource classSource) {
        ErrorManager em = ErrorManager.getDefault();
        String msg = FormUtils.getFormattedBundleString("FMT_ERR_CannotLoadClass4", new Object[]{classSource.getClassName(), ClassPathUtils.getClassSourceDescription(classSource)});
        em.annotate(ex, msg);
        em.notify(256, ex);
        em.notify(1, ex);
    }

    private boolean initComponentInstance(RADComponent metacomp, Class<?> compClass) {
        try {
            metacomp.initInstance(compClass);
        }
        catch (Exception ex) {
            MetaComponentCreator.showInstErrorMessage(ex);
            return false;
        }
        catch (LinkageError ex) {
            MetaComponentCreator.showInstErrorMessage(ex);
            return false;
        }
        return true;
    }

    private static void showInstErrorMessage(Throwable ex) {
        ErrorManager em = ErrorManager.getDefault();
        em.annotate(ex, FormUtils.getBundleString("MSG_ERR_CannotInstantiate"));
        em.notify(ex);
    }

    private RADComponent defaultVisualComponentInit(RADVisualComponent newMetaComp) {
        ListModel model;
        Serializable propValue;
        String prefix;
        Object comp = newMetaComp.getBeanInstance();
        String varName = newMetaComp.getName();
        HashMap<String, Object> changes = new HashMap<String, Object>();
        if (comp instanceof JLabel) {
            if ("".equals(((JLabel)comp).getText())) {
                changes.put("text", varName);
            }
        } else if (comp instanceof JTextField) {
            if ("".equals(((JTextField)comp).getText())) {
                changes.put("text", varName);
            }
        } else if (comp instanceof JMenuItem) {
            if ("".equals(((JMenuItem)comp).getText())) {
                changes.put("text", varName);
            }
            if (comp instanceof JCheckBoxMenuItem) {
                changes.put("selected", Boolean.TRUE);
            }
            if (comp instanceof JRadioButtonMenuItem) {
                changes.put("selected", Boolean.TRUE);
            }
        } else if (comp instanceof AbstractButton) {
            String txt = ((AbstractButton)comp).getText();
            if (txt == null || "".equals(txt)) {
                changes.put("text", varName);
            }
        } else if (comp instanceof JTable) {
            TableModel tm = ((JTable)comp).getModel();
            if (tm == null || tm.getClass().equals(DefaultTableModel.class) && tm.getRowCount() == 0 && tm.getColumnCount() == 0) {
                prefix = NbBundle.getMessage(MetaComponentCreator.class, (String)"FMT_CreatorTableTitle");
                prefix = prefix + ' ';
                propValue = new TableModelEditor.NbTableModel(new DefaultTableModel(new String[]{prefix + 1, prefix + 2, prefix + 3, prefix + 4}, 4));
                changes.put("model", propValue);
            }
        } else if (comp instanceof JToolBar) {
            changes.put("rollover", true);
        } else if (comp instanceof JInternalFrame) {
            changes.put("visible", true);
        } else if (comp instanceof Button) {
            if ("".equals(((Button)comp).getLabel())) {
                changes.put("label", varName);
            }
        } else if (comp instanceof Checkbox) {
            if ("".equals(((Checkbox)comp).getLabel())) {
                changes.put("label", varName);
            }
        } else if (comp instanceof Label) {
            if ("".equals(((Label)comp).getText())) {
                changes.put("text", varName);
            }
        } else if (comp instanceof TextField) {
            if ("".equals(((TextField)comp).getText())) {
                changes.put("text", varName);
            }
        } else if ("javax.swing.JComboBox".equals(comp.getClass().getName())) {
            model = ((JComboBox)comp).getModel();
            if (model == null || model.getSize() == 0) {
                prefix = NbBundle.getMessage(MetaComponentCreator.class, (String)"FMT_CreatorComboBoxItem");
                prefix = prefix + ' ';
                propValue = new DefaultComboBoxModel<String>(new String[]{prefix + 1, prefix + 2, prefix + 3, prefix + 4});
                changes.put("model", propValue);
            }
        } else if (comp instanceof JList) {
            model = ((JList)comp).getModel();
            if (model == null || model.getSize() == 0) {
                prefix = NbBundle.getMessage(MetaComponentCreator.class, (String)"FMT_CreatorListItem");
                prefix = prefix + ' ';
                DefaultListModel<String> defaultModel = new DefaultListModel<String>();
                for (int i = 1; i < 6; ++i) {
                    defaultModel.addElement(prefix + i);
                }
                changes.put("model", defaultModel);
            }
        } else if (comp instanceof JTextArea) {
            JTextArea textArea = (JTextArea)comp;
            if (textArea.getRows() == 0) {
                changes.put("rows", new Integer(5));
            }
            if (textArea.getColumns() == 0) {
                changes.put("columns", new Integer(20));
            }
        }
        for (Map.Entry change : changes.entrySet()) {
            String propName = (String)change.getKey();
            Object propValue2 = change.getValue();
            RADProperty prop = newMetaComp.getBeanProperty(propName);
            if (prop == null) continue;
            try {
                prop.setChangeFiring(false);
                prop.setValue(propValue2);
                prop.setChangeFiring(true);
            }
            catch (Exception e) {}
        }
        if (MetaComponentCreator.shouldEncloseByScrollPane(newMetaComp.getBeanInstance())) {
            RADVisualContainer metaScroll = (RADVisualContainer)this.createVisualComponent(JScrollPane.class);
            metaScroll.setAuxValue("autoScrollPane", Boolean.TRUE);
            metaScroll.add(newMetaComp);
            Container scroll = (Container)metaScroll.getBeanInstance();
            Component inScroll = (Component)newMetaComp.getBeanInstance();
            metaScroll.getLayoutSupport().addComponentsToContainer(scroll, scroll, new Component[]{inScroll}, 0);
            newMetaComp = metaScroll;
        } else if (newMetaComp instanceof RADVisualContainer && newMetaComp.getBeanInstance() instanceof JMenuBar) {
            RADVisualContainer menuCont = (RADVisualContainer)newMetaComp;
            Container menuBar = (Container)menuCont.getBeanInstance();
            RADVisualComponent menuComp = this.createVisualComponent(JMenu.class);
            try {
                menuComp.getBeanProperty("text").setValue(FormUtils.getBundleString("CTL_DefaultFileMenu"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Component menu = (Component)menuComp.getBeanInstance();
            menuCont.add(menuComp);
            menuCont.getLayoutSupport().addComponentsToContainer(menuBar, menuBar, new Component[]{menu}, 0);
            menuComp = this.createVisualComponent(JMenu.class);
            try {
                menuComp.getBeanProperty("text").setValue(FormUtils.getBundleString("CTL_DefaultEditMenu"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            menu = (Component)menuComp.getBeanInstance();
            menuCont.add(menuComp);
            menuCont.getLayoutSupport().addComponentsToContainer(menuBar, menuBar, new Component[]{menu}, 1);
        }
        return newMetaComp;
    }

    private static boolean shouldEncloseByScrollPane(Object bean) {
        return bean instanceof JList || bean instanceof JTable || bean instanceof JTree || bean instanceof JTextArea || bean instanceof JTextPane || bean instanceof JEditorPane;
    }

    private static void defaultTargetInit(RADComponent metacomp, RADComponent target) {
        Object targetComp;
        Object object = targetComp = target != null ? target.getBeanInstance() : null;
        if (metacomp.getBeanClass().equals(JSeparator.class)) {
            if (targetComp instanceof JToolBar) {
                try {
                    metacomp.initInstance(JToolBar.Separator.class);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return;
            }
            if (targetComp instanceof JMenu || targetComp instanceof JPopupMenu) {
                try {
                    metacomp.initInstance(JPopupMenu.Separator.class);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return;
            }
        }
        Object comp = metacomp.getBeanInstance();
        HashMap<String, Boolean> changes = null;
        if (comp instanceof AbstractButton && targetComp instanceof JToolBar) {
            if (changes == null) {
                changes = new HashMap<String, Boolean>();
            }
            changes.put("focusable", false);
            changes.put("horizontalTextPosition", (Boolean)((Object)Integer.valueOf(0)));
            changes.put("verticalTextPosition", (Boolean)((Object)Integer.valueOf(3)));
        }
        if (changes != null) {
            for (Map.Entry e : changes.entrySet()) {
                RADProperty prop = metacomp.getBeanProperty((String)e.getKey());
                if (prop == null) continue;
                try {
                    prop.setChangeFiring(false);
                    prop.setValue(e.getValue());
                    prop.setChangeFiring(true);
                }
                catch (Exception ex) {}
            }
        }
    }

    private Dimension prepareDefaultLayoutSize(Component comp, boolean isContainer) {
        int width = -1;
        int height = -1;
        if (comp instanceof JToolBar) {
            width = 100;
            height = 25;
        } else if (isContainer) {
            Dimension pref = comp.getPreferredSize();
            if (pref.width < 16 && pref.height < 12) {
                if (comp instanceof Window || comp instanceof Applet) {
                    width = 400;
                    height = 300;
                } else {
                    width = 100;
                    height = 100;
                }
            } else {
                Dimension designerSize = FormEditor.getFormDesigner(this.formModel).getDesignerSize();
                if (pref.width > designerSize.width || pref.height > designerSize.height) {
                    width = Math.min(pref.width, designerSize.width - 25);
                    height = Math.min(pref.height, designerSize.height - 25);
                }
            }
        } else if (comp instanceof JSeparator) {
            width = 50;
            height = 10;
        }
        if (width < 0 || height < 0) {
            return null;
        }
        Dimension size = new Dimension(width, height);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(size);
        }
        return size;
    }

    private static class TargetInfo {
        private TargetType targetType;
        private ComponentType componentType;
        private RADComponent targetComponent;

        private TargetInfo() {
        }
    }

    private static enum ComponentType {
        NON_VISUAL,
        VISUAL,
        MENU;

    }

    private static enum TargetType {
        LAYOUT,
        BORDER,
        MENU,
        VISUAL,
        OTHER;

    }
}

