/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.modules.form.layoutsupport.griddesigner.AnimationLayer;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridDesigner;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteComponentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;

public class GlassPane
extends JPanel
implements GridActionPerformer {
    private static final Color GRID_COLOR = new Color(192, 192, 192, 128);
    private static final Color HIGHLIGHT_COLOR = new Color(64, 255, 64, 64);
    static final int HEADER_GAP = 10;
    private GridDesigner designer;
    private Container innerPane;
    private Container componentPane;
    private GridManager gridManager;
    private GridInfoProvider gridInfo;
    private GridCustomizer customizer;
    private Set<Component> selection = new HashSet<Component>();
    private Component focusedComponent;
    private int mouseModifiers;
    private BitSet selectedColumns = new BitSet();
    private BitSet selectedRows = new BitSet();
    private int focusedCellRow;
    private int focusedCellColumn;
    private int headerHeight;
    private int headerWidth;
    private boolean moving;
    private boolean resizing;
    private boolean selecting;
    private int resizingMode;
    private Point draggingStart;
    private Rectangle draggingRect;
    private int selMinX;
    private int selMaxX;
    private int selMinY;
    private int selMaxY;
    private int selMinWidth;
    private int selMinHeight;
    private int newGridX;
    private int newGridY;
    private int newGridWidth;
    private int newGridHeight;
    private AnimationLayer animLayer = new AnimationLayer();
    boolean animation;
    float animPhase;
    GridBoundsChange animChange;

    public GlassPane(GridDesigner designer) {
        this.designer = designer;
        this.setLayout(null);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.initHeaderWidth();
    }

    public void setPanes(Container innerPane, Container componentPane) {
        this.innerPane = innerPane;
        this.componentPane = componentPane;
    }

    public boolean isUserActionInProgress() {
        return this.animation;
    }

    public void updateLayout() {
        this.performAction(new AbstractGridAction(){

            @Override
            public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
                GridInfoProvider info = gridManager.getGridInfo();
                int oldColumns = info.getColumnCount();
                int oldRows = info.getRowCount();
                GridUtils.removePaddingComponents(gridManager);
                gridManager.updateLayout(false);
                GridUtils.revalidateGrid(gridManager);
                int newColumns = info.getColumnCount();
                int newRows = info.getRowCount();
                int columns = Math.max(oldColumns, newColumns);
                int rows = Math.max(oldRows, newRows);
                GridUtils.addPaddingComponents(gridManager, columns, rows);
                GridUtils.revalidateGrid(gridManager);
                return null;
            }
        });
    }

    private void initHeaderWidth() {
        JLabel label = new JLabel("99");
        label.setBorder(BorderFactory.createRaisedBevelBorder());
        this.headerWidth = label.getPreferredSize().width + 10;
    }

    public void setGridManager(GridManager gridManager) {
        this.gridManager = gridManager;
        this.gridInfo = gridManager.getGridInfo();
        this.customizer = gridManager.getCustomizer(this);
        GridUtils.revalidateGrid(gridManager);
        GridUtils.addPaddingComponents(gridManager, this.gridInfo.getColumnCount(), this.gridInfo.getRowCount());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.animation) {
            Point shift = this.fromComponentPane(new Point());
            g.translate(shift.x, shift.y);
            this.animLayer.paint(g);
            g.translate(-shift.x, -shift.y);
            this.animPhase = this.animLayer.getPhase();
        }
        this.paintGrid(g);
        if (this.resizing) {
            this.paintResizing(g);
        } else if (this.moving) {
            this.paintResizing(g);
        } else {
            if (this.selecting) {
                g.setColor(GridDesigner.SELECTION_COLOR);
                g.drawRect(this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
            }
            this.paintSelection(g);
        }
        if (this.animation && this.animPhase == 1.0f) {
            this.animation = false;
            this.animPhase = 0.0f;
            this.repaint();
        }
    }

    private void paintGrid(Graphics g) {
        int i;
        int bound;
        int i2;
        int[] rowBounds;
        int[] columnBounds;
        boolean animReady;
        if (this.gridInfo == null) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(GRID_COLOR);
        boolean bl = animReady = this.animation && this.animChange != null;
        if (animReady) {
            int[] animOldColumnBounds = this.animChange.getOldColumnBounds();
            int[] animNewColumnBounds = this.animChange.getNewColumnBounds();
            columnBounds = new int[animOldColumnBounds.length];
            for (int i3 = 0; i3 < animOldColumnBounds.length; ++i3) {
                columnBounds[i3] = Math.round((float)animOldColumnBounds[i3] * (1.0f - this.animPhase) + this.animPhase * (float)animNewColumnBounds[i3]);
            }
        } else {
            columnBounds = this.gridInfo.getColumnBounds();
        }
        int columns = columnBounds.length - 1;
        if (animReady) {
            int[] animOldRowBounds = this.animChange.getOldRowBounds();
            int[] animNewRowBounds = this.animChange.getNewRowBounds();
            rowBounds = new int[animOldRowBounds.length];
            for (int i4 = 0; i4 < animOldRowBounds.length; ++i4) {
                rowBounds[i4] = Math.round((float)animOldRowBounds[i4] * (1.0f - this.animPhase) + this.animPhase * (float)animNewRowBounds[i4]);
            }
        } else {
            rowBounds = this.gridInfo.getRowBounds();
        }
        int rows = rowBounds.length - 1;
        if (this.moving || this.resizing) {
            int deltaX = this.newGridX - this.gridInfo.getGridX(this.focusedComponent);
            int deltaWidth = this.newGridWidth - this.gridInfo.getGridWidth(this.focusedComponent);
            columns = Math.max(columns, this.selMaxX + deltaX + deltaWidth + 1);
            int deltaY = this.newGridY - this.gridInfo.getGridY(this.focusedComponent);
            int deltaHeight = this.newGridHeight - this.gridInfo.getGridHeight(this.focusedComponent);
            rows = Math.max(rows, this.selMaxY + deltaY + deltaHeight + 1);
        }
        Point shift = new Point();
        shift = this.fromComponentPane(shift);
        int x = columnBounds[0] + shift.x;
        int y = rowBounds[0] + shift.y;
        int width = this.extendedBound(columnBounds, columns) - columnBounds[0];
        int height = this.extendedBound(rowBounds, rows) - rowBounds[0];
        for (i2 = 0; i2 <= columns; ++i2) {
            bound = this.extendedBound(columnBounds, i2);
            g.drawLine(bound + shift.x, y, bound + shift.x, y + height);
        }
        for (i2 = 0; i2 <= rows; ++i2) {
            bound = this.extendedBound(rowBounds, i2);
            g.drawLine(x, bound + shift.y, x + width, bound + shift.y);
        }
        g.setColor(oldColor);
        Color c = new Color(GRID_COLOR.getRGB());
        JLabel header = new JLabel();
        header.setOpaque(true);
        header.setBackground(c);
        header.setHorizontalAlignment(0);
        for (i = 0; i < columns; ++i) {
            header.setText(Integer.toString(i + 1));
            header.setBorder(this.selectedColumns.get(i) ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
            this.headerHeight = header.getPreferredSize().height;
            int start = this.extendedBound(columnBounds, i);
            int end = this.extendedBound(columnBounds, i + 1);
            int w = end - start;
            Graphics gg = g.create(start + shift.x, rowBounds[0] - 10 - this.headerHeight + shift.y, w, this.headerHeight);
            header.setSize(w, this.headerHeight);
            header.paint(gg);
            gg.dispose();
        }
        for (i = 0; i < rows; ++i) {
            header.setText(Integer.toString(i + 1));
            Border border = this.selectedRows.get(i) ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder();
            header.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            int start = this.extendedBound(rowBounds, i);
            int end = this.extendedBound(rowBounds, i + 1);
            int h = end - start;
            Graphics gg = g.create(columnBounds[0] - 10 - this.headerWidth + shift.x, start + shift.y, this.headerWidth, h);
            header.setSize(this.headerWidth, h);
            header.paint(gg);
            gg.dispose();
        }
    }

    private void paintSelection(Graphics g) {
        if (this.animation) {
            return;
        }
        for (Component selComp : this.selection) {
            Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
            Rectangle inner = this.fromComponentPane(selComp.getBounds());
            g.setColor(HIGHLIGHT_COLOR);
            if (inner.width == 0 || inner.height == 0) {
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            } else {
                g.fillRect(rect.x, rect.y, rect.width, inner.y - rect.y);
                g.fillRect(rect.x, inner.y, inner.x - rect.x, inner.height);
                g.fillRect(inner.x + inner.width, inner.y, rect.width - (inner.x + inner.width - rect.x), inner.height);
                g.fillRect(rect.x, inner.y + inner.height, rect.width, rect.height - (inner.y + inner.height - rect.y));
            }
            g.setColor(GridDesigner.SELECTION_COLOR);
            int x = rect.x - 1;
            int y = rect.y - 1;
            int w = rect.width / 2 + 1;
            int h = rect.height / 2 + 1;
            g.drawRect(x, y, rect.width + 1, rect.height + 1);
            Image resizeHandle = GridDesigner.RESIZE_HANDLE;
            int rw = resizeHandle.getWidth(null);
            int rh = resizeHandle.getHeight(null);
            g.drawImage(resizeHandle, x - rw, y - rh, null);
            g.drawImage(resizeHandle, (x += w) - rw / 2, y - rh, null);
            g.drawImage(resizeHandle, x += rect.width + 2 - w, y - rh, null);
            g.drawImage(resizeHandle, x, (y += h) - rh / 2, null);
            g.drawImage(resizeHandle, x, y += rect.height + 2 - h, null);
            g.drawImage(resizeHandle, (x -= rect.width + 2 - w) - rw / 2, y, null);
            g.drawImage(resizeHandle, (x -= w) - rw, y, null);
            g.drawImage(resizeHandle, x - rw, (y -= rect.height + 2 - h) - rh / 2, null);
        }
    }

    private void paintResizing(Graphics g) {
        int xDelta = this.newGridX - this.gridInfo.getGridX(this.focusedComponent);
        int yDelta = this.newGridY - this.gridInfo.getGridY(this.focusedComponent);
        int heightDelta = this.newGridHeight - this.gridInfo.getGridHeight(this.focusedComponent);
        int widthDelta = this.newGridWidth - this.gridInfo.getGridWidth(this.focusedComponent);
        g.setColor(GridDesigner.SELECTION_COLOR);
        g.drawRect(this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
        g.setColor(HIGHLIGHT_COLOR);
        int[] columnBounds = this.gridInfo.getColumnBounds();
        int[] rowBounds = this.gridInfo.getRowBounds();
        Point shift = this.fromComponentPane(new Point());
        for (Component selComp : this.selection) {
            int newCompGridX = this.gridInfo.getGridX(selComp) + xDelta;
            int newCompGridWidth = this.gridInfo.getGridWidth(selComp) + widthDelta;
            int newCompGridY = this.gridInfo.getGridY(selComp) + yDelta;
            int newCompGridHeight = this.gridInfo.getGridHeight(selComp) + heightDelta;
            int x = this.extendedBound(columnBounds, newCompGridX);
            int width = this.extendedBound(columnBounds, newCompGridX + newCompGridWidth) - x;
            int y = this.extendedBound(rowBounds, newCompGridY);
            int height = this.extendedBound(rowBounds, newCompGridY + newCompGridHeight) - y;
            g.fillRect(x + shift.x, y + shift.y, width, height);
        }
    }

    private Rectangle selectionResizingBounds(Component selComp) {
        int[] columnBounds = this.gridInfo.getColumnBounds();
        int[] rowBounds = this.gridInfo.getRowBounds();
        int gridX = this.gridInfo.getGridX(selComp);
        int gridY = this.gridInfo.getGridY(selComp);
        int gridWidth = this.gridInfo.getGridWidth(selComp);
        int gridHeight = this.gridInfo.getGridHeight(selComp);
        int x = columnBounds[gridX];
        int width = columnBounds[gridX + gridWidth] - x;
        int y = rowBounds[gridY];
        int height = rowBounds[gridY + gridHeight] - y;
        return new Rectangle(x, y, width, height);
    }

    private int extendedBound(int[] bounds, int index) {
        int bound = index < bounds.length ? bounds[index] : bounds[bounds.length - 1] + (index - bounds.length + 1) * 20;
        return bound;
    }

    private boolean isResizingEastward() {
        return this.resizingMode == 3 || this.resizingMode == 4 || this.resizingMode == 2;
    }

    private boolean isResizingWestward() {
        return this.resizingMode == 7 || this.resizingMode == 6 || this.resizingMode == 8;
    }

    private boolean isResizingSouthward() {
        return this.resizingMode == 5 || this.resizingMode == 4 || this.resizingMode == 6;
    }

    private boolean isResizingNorthward() {
        return this.resizingMode == 1 || this.resizingMode == 2 || this.resizingMode == 8;
    }

    Rectangle calculateResizingRectangle(Point resizingEnd, Component selComp) {
        Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
        int dx = resizingEnd.x - this.draggingStart.x;
        int dy = resizingEnd.y - this.draggingStart.y;
        if (this.isResizingEastward()) {
            rect.width += dx;
            if (rect.width < 0) {
                rect.width = 0;
            }
        }
        if (this.isResizingSouthward()) {
            rect.height += dy;
            if (rect.height < 0) {
                rect.height = 0;
            }
        }
        if (this.isResizingWestward()) {
            rect.width -= dx;
            rect.x += dx;
            if (rect.width < 0) {
                rect.x += rect.width;
                rect.width = 0;
            }
        }
        if (this.isResizingNorthward()) {
            rect.height -= dy;
            rect.y += dy;
            if (rect.height < 0) {
                rect.y += rect.height;
                rect.height = 0;
            }
        }
        return rect;
    }

    void calculateResizingGridLocation() {
        int currentY;
        int currentX;
        Rectangle rect = this.toComponentPane(this.draggingRect);
        int x = this.gridInfo.getGridX(this.focusedComponent);
        int y = this.gridInfo.getGridY(this.focusedComponent);
        int width = this.gridInfo.getGridWidth(this.focusedComponent);
        int height = this.gridInfo.getGridHeight(this.focusedComponent);
        if (this.isResizingEastward()) {
            currentX = this.gridXLocation(rect.x + rect.width, false);
            this.newGridWidth = Math.max(width - this.selMinWidth + 1, currentX - x + 1);
        }
        if (this.isResizingWestward()) {
            currentX = this.gridXLocation(rect.x, false);
            this.newGridX = Math.max(x - this.selMinX, Math.min(x + width - (width - this.selMinWidth + 1), currentX));
            this.newGridWidth = x + width - this.newGridX;
        }
        if (this.isResizingSouthward()) {
            currentY = this.gridYLocation(rect.y + rect.height, false);
            this.newGridHeight = Math.max(height - this.selMinHeight + 1, currentY - y + 1);
        }
        if (this.isResizingNorthward()) {
            currentY = this.gridYLocation(rect.y, false);
            this.newGridY = Math.max(y - this.selMinY, Math.min(y + height - (height - this.selMinHeight + 1), currentY));
            this.newGridHeight = y + height - this.newGridY;
        }
    }

    Rectangle calculateMovingRectangle(Point movingEnd) {
        Rectangle rect = this.focusedComponent.getBounds();
        rect.x += movingEnd.x - this.draggingStart.x;
        rect.y += movingEnd.y - this.draggingStart.y;
        return this.fromComponentPane(rect);
    }

    void calculateMovingGridLocation(Point cursorLocation) {
        Point start = this.toComponentPane(this.draggingStart);
        Point end = this.toComponentPane(cursorLocation);
        int startX = this.gridXLocation(start.x, true);
        int startY = this.gridYLocation(start.y, true);
        int endX = this.gridXLocation(end.x, false);
        int endY = this.gridYLocation(end.y, false);
        int deltaX = endX - startX;
        int deltaY = endY - startY;
        deltaX = Math.max(deltaX, -this.selMinX);
        deltaY = Math.max(deltaY, -this.selMinY);
        this.newGridX = this.gridInfo.getGridX(this.focusedComponent) + deltaX;
        this.newGridY = this.gridInfo.getGridY(this.focusedComponent) + deltaY;
    }

    void updateCursor(Point cursorLocation) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (cursorLocation == null) {
            this.resizingMode = 0;
        } else {
            int x = cursorLocation.x;
            int y = cursorLocation.y;
            Image resizeHandle = GridDesigner.RESIZE_HANDLE;
            int rw = resizeHandle.getWidth(null);
            int rh = resizeHandle.getHeight(null);
            for (Component selComp : this.selection) {
                boolean right;
                Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
                boolean w = rect.x - rw <= x && x <= rect.x + rect.width + rw;
                boolean h = rect.y - rh <= y && y <= rect.y + rect.height + rh;
                boolean top = w && rect.y - rh <= y && y <= rect.y + rh;
                boolean bottom = w && rect.y + rect.height - rh <= y && y <= rect.y + rect.height + rh;
                boolean left = h && rect.x - rw <= x && x <= rect.x + rw;
                boolean bl = right = h && rect.x + rect.width - rw <= x && x <= rect.x + rect.width + rw;
                if (top) {
                    if (left) {
                        cursor = Cursor.getPredefinedCursor(6);
                        this.resizingMode = 8;
                    } else if (right) {
                        cursor = Cursor.getPredefinedCursor(7);
                        this.resizingMode = 2;
                    } else {
                        cursor = Cursor.getPredefinedCursor(8);
                        this.resizingMode = 1;
                    }
                } else if (bottom) {
                    if (left) {
                        cursor = Cursor.getPredefinedCursor(4);
                        this.resizingMode = 6;
                    } else if (right) {
                        cursor = Cursor.getPredefinedCursor(5);
                        this.resizingMode = 4;
                    } else {
                        cursor = Cursor.getPredefinedCursor(9);
                        this.resizingMode = 5;
                    }
                } else if (left) {
                    cursor = Cursor.getPredefinedCursor(10);
                    this.resizingMode = 7;
                } else if (right) {
                    cursor = Cursor.getPredefinedCursor(11);
                    this.resizingMode = 3;
                } else {
                    cursor = Cursor.getDefaultCursor();
                    this.resizingMode = 0;
                }
                if (this.resizingMode == 0) continue;
                this.focusedComponent = selComp;
                break;
            }
        }
        this.setCursor(cursor);
    }

    Point toComponentPane(Point point) {
        return SwingUtilities.convertPoint(this.innerPane, point, this.componentPane);
    }

    Rectangle toComponentPane(Rectangle rectangle) {
        return SwingUtilities.convertRectangle(this.innerPane, rectangle, this.componentPane);
    }

    Point fromComponentPane(Point point) {
        return SwingUtilities.convertPoint(this.componentPane, point, this.innerPane);
    }

    Rectangle fromComponentPane(Rectangle rectangle) {
        return SwingUtilities.convertRectangle(this.componentPane, rectangle, this.innerPane);
    }

    private int gridXLocation(int xComponentPaneCoordinate, boolean mustBeInside) {
        int[] bounds = this.gridInfo.getColumnBounds();
        int gridX = -1;
        while (gridX + 1 < bounds.length && bounds[gridX + 1] <= xComponentPaneCoordinate) {
            ++gridX;
        }
        if (mustBeInside) {
            gridX = Math.max(0, Math.min(gridX, bounds.length - 2));
        } else if (gridX == bounds.length - 1) {
            gridX = (xComponentPaneCoordinate - bounds[bounds.length - 1] + 1) / 20 + bounds.length - 1;
        }
        return gridX;
    }

    private int gridYLocation(int yComponentPaneCoordinate, boolean mustBeInside) {
        int[] bounds = this.gridInfo.getRowBounds();
        int gridY = -1;
        while (gridY + 1 < bounds.length && bounds[gridY + 1] <= yComponentPaneCoordinate) {
            ++gridY;
        }
        if (mustBeInside) {
            gridY = Math.max(0, Math.min(gridY, bounds.length - 2));
        } else if (gridY == bounds.length - 1) {
            gridY = (yComponentPaneCoordinate - bounds[bounds.length - 1] + 1) / 20 + bounds.length - 1;
        }
        return gridY;
    }

    Component findComponent(Point innerPanePoint) {
        for (Component comp : this.componentPane.getComponents()) {
            Rectangle rect;
            if (GridUtils.isPaddingComponent(comp) || !(rect = this.fromComponentPane(comp.getBounds())).contains(innerPanePoint)) continue;
            return comp;
        }
        return null;
    }

    int findColumnHeader(Point innerPanePoint) {
        Point shift = this.fromComponentPane(new Point());
        int y = this.gridInfo.getY() + shift.y - 10;
        if (y - this.headerHeight <= innerPanePoint.y && innerPanePoint.y <= y) {
            int[] bounds = this.gridInfo.getColumnBounds();
            for (int i = 0; i < bounds.length - 1; ++i) {
                int x = innerPanePoint.x - shift.x;
                if (bounds[i] > x || x >= bounds[i + 1]) continue;
                return i;
            }
        }
        return -1;
    }

    int findRowHeader(Point innerPanePoint) {
        Point shift = this.fromComponentPane(new Point());
        int x = this.gridInfo.getX() + shift.x - 10;
        if (x - this.headerWidth <= innerPanePoint.x && innerPanePoint.x <= x) {
            int[] bounds = this.gridInfo.getRowBounds();
            for (int i = 0; i < bounds.length - 1; ++i) {
                int y = innerPanePoint.y - shift.y;
                if (bounds[i] > y || y >= bounds[i + 1]) continue;
                return i;
            }
        }
        return -1;
    }

    DesignerContext currentContext() {
        DesignerContext context = new DesignerContext();
        context.setSelectedColumns((BitSet)this.selectedColumns.clone());
        context.setSelectedRows((BitSet)this.selectedRows.clone());
        context.setSelectedComponents(new HashSet<Component>(this.selection));
        context.setGridInfo(this.gridInfo);
        context.setFocusedRow(this.focusedCellRow);
        context.setFocusedColumn(this.focusedCellColumn);
        return context;
    }

    void updateCurrentContext(DesignerContext context) {
        this.setSelection(context.getSelectedComponents());
    }

    void changeLocation() {
        boolean widthChanged;
        int oldX = this.gridInfo.getGridX(this.focusedComponent);
        int oldY = this.gridInfo.getGridY(this.focusedComponent);
        int oldWidth = this.gridInfo.getGridWidth(this.focusedComponent);
        int oldHeight = this.gridInfo.getGridHeight(this.focusedComponent);
        boolean xChanged = oldX != this.newGridX;
        boolean yChanged = oldY != this.newGridY;
        boolean heightChanged = oldHeight != this.newGridHeight;
        boolean bl = widthChanged = oldWidth != this.newGridWidth;
        if (xChanged || yChanged || widthChanged || heightChanged) {
            this.performAction(new ChangeLocationAction());
        }
    }

    @Override
    public void performAction(GridAction action) {
        GridActionWrapper wrapper = new GridActionWrapper(action);
        wrapper.setDesignerContext(this.currentContext());
        wrapper.actionPerformed(null);
    }

    void setSelection(Component selComp) {
        this.setSelection(selComp == null ? Collections.EMPTY_SET : Collections.singleton(selComp));
    }

    void setSelection(Set<Component> selection) {
        assert (!selection.contains(null));
        if (selection == this.selection) {
            return;
        }
        if (selection.isEmpty()) {
            this.updateCursor(null);
        }
        this.selection = selection;
        this.designer.setSelection(selection);
        this.requestFocusInWindow();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 127) {
            if (!this.selection.isEmpty()) {
                this.performAction(new DeleteComponentAction());
            }
        } else if (keyCode == 27 && (this.moving || this.resizing)) {
            this.moving = false;
            this.resizing = false;
            this.repaint();
        } else {
            super.processKeyEvent(e);
        }
    }

    void initSelFields() {
        this.selMinX = Integer.MAX_VALUE;
        this.selMaxX = 0;
        this.selMinY = Integer.MAX_VALUE;
        this.selMaxY = 0;
        this.selMinWidth = Integer.MAX_VALUE;
        this.selMinHeight = Integer.MAX_VALUE;
        for (Component selComp : this.selection) {
            int gridX = this.gridInfo.getGridX(selComp);
            int gridY = this.gridInfo.getGridY(selComp);
            int gridWidth = this.gridInfo.getGridWidth(selComp);
            int gridHeight = this.gridInfo.getGridHeight(selComp);
            this.selMinX = Math.min(this.selMinX, gridX);
            this.selMaxX = Math.max(this.selMaxX, gridX + gridWidth - 1);
            this.selMinY = Math.min(this.selMinY, gridY);
            this.selMaxY = Math.max(this.selMaxY, gridY + gridHeight - 1);
            this.selMinWidth = Math.min(this.selMinWidth, gridWidth);
            this.selMinHeight = Math.min(this.selMinHeight, gridHeight);
        }
    }

    class ChangeLocationAction
    extends AbstractGridAction {
        ChangeLocationAction() {
        }

        @Override
        public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
            int i;
            GridInfoProvider info = gridManager.getGridInfo();
            int[] originalColumnBounds = info.getColumnBounds();
            int[] originalRowBounds = info.getRowBounds();
            int columns = info.getColumnCount();
            int rows = info.getRowCount();
            int xDelta = GlassPane.this.newGridX - info.getGridX(GlassPane.this.focusedComponent);
            int yDelta = GlassPane.this.newGridY - info.getGridY(GlassPane.this.focusedComponent);
            int heightDelta = GlassPane.this.newGridHeight - info.getGridHeight(GlassPane.this.focusedComponent);
            int widthDelta = GlassPane.this.newGridWidth - info.getGridWidth(GlassPane.this.focusedComponent);
            GridUtils.removePaddingComponents(gridManager);
            if (xDelta != 0 || yDelta != 0 || widthDelta != 0 || heightDelta != 0) {
                for (Component selComp : GlassPane.this.selection) {
                    int gridX = info.getGridX(selComp);
                    int gridY = info.getGridY(selComp);
                    int width = info.getGridWidth(selComp);
                    int height = info.getGridHeight(selComp);
                    gridManager.setGridX(selComp, gridX + xDelta);
                    gridManager.setGridY(selComp, gridY + yDelta);
                    gridManager.setGridWidth(selComp, width + widthDelta);
                    gridManager.setGridHeight(selComp, height + heightDelta);
                    columns = Math.max(columns, gridX + xDelta + width + widthDelta);
                    rows = Math.max(rows, gridY + yDelta + height + heightDelta);
                }
            }
            GridUtils.addPaddingComponents(gridManager, columns, rows);
            GridUtils.revalidateGrid(gridManager);
            int[] newColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
            int[] newRowBounds = GlassPane.this.gridInfo.getRowBounds();
            if (newColumnBounds.length > originalColumnBounds.length) {
                int[] oldBounds = new int[newColumnBounds.length];
                for (i = 0; i < oldBounds.length; ++i) {
                    oldBounds[i] = GlassPane.this.extendedBound(originalColumnBounds, i);
                }
                originalColumnBounds = oldBounds;
            }
            if (newRowBounds.length > originalRowBounds.length) {
                int[] oldBounds = new int[newRowBounds.length];
                for (i = 0; i < oldBounds.length; ++i) {
                    oldBounds[i] = GlassPane.this.extendedBound(originalRowBounds, i);
                }
                originalRowBounds = oldBounds;
            }
            return new GridBoundsChange(originalColumnBounds, originalRowBounds, newColumnBounds, newRowBounds);
        }
    }

    class GridActionWrapper
    extends AbstractAction {
        private GridAction delegate;
        private DesignerContext currentContext;

        GridActionWrapper(GridAction action) {
            this.delegate = action;
        }

        public void setDesignerContext(DesignerContext currentContext) {
            this.currentContext = currentContext;
            this.setEnabled(this.delegate.isEnabled(currentContext));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] animNewRowBounds;
            int[] animNewColumnBounds;
            GlassPane.this.animation = true;
            int[] animOldColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
            int[] animOldRowBounds = GlassPane.this.gridInfo.getRowBounds();
            GlassPane.this.animLayer.setContainer(GlassPane.this.componentPane);
            GlassPane.this.animLayer.setGlassPane(GlassPane.this);
            GlassPane.this.animLayer.setVIPComponents(new ArrayList<Component>(GlassPane.this.selection));
            GlassPane.this.animLayer.loadStart();
            GridBoundsChange change = this.delegate.performAction(GlassPane.this.gridManager, this.currentContext);
            GlassPane.this.updateCurrentContext(this.currentContext);
            GlassPane.this.animLayer.loadEnd();
            if (change == null) {
                animNewColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
                animNewRowBounds = GlassPane.this.gridInfo.getRowBounds();
            } else {
                animOldColumnBounds = change.getOldColumnBounds();
                animOldRowBounds = change.getOldRowBounds();
                animNewColumnBounds = change.getNewColumnBounds();
                animNewRowBounds = change.getNewRowBounds();
            }
            if (animNewColumnBounds.length != animOldColumnBounds.length) {
                if (animNewColumnBounds.length > animOldColumnBounds.length) {
                    animOldColumnBounds = this.extendArray(animOldColumnBounds, animNewColumnBounds.length);
                } else {
                    animNewColumnBounds = this.extendArray(animNewColumnBounds, animOldColumnBounds.length);
                }
            }
            if (animNewRowBounds.length != animOldRowBounds.length) {
                if (animNewRowBounds.length > animOldRowBounds.length) {
                    animOldRowBounds = this.extendArray(animOldRowBounds, animNewRowBounds.length);
                } else {
                    animNewRowBounds = this.extendArray(animNewRowBounds, animOldRowBounds.length);
                }
            }
            change = new GridBoundsChange(animOldColumnBounds, animOldRowBounds, animNewColumnBounds, animNewRowBounds);
            if (GlassPane.this.customizer != null) {
                DesignerContext context = GlassPane.this.currentContext();
                GlassPane.this.customizer.setContext(context);
            }
            GlassPane.this.animChange = change;
            GlassPane.this.animLayer.animate();
        }

        private int[] extendArray(int[] original, int newLength) {
            int[] result = new int[newLength];
            System.arraycopy(original, 0, result, 0, original.length);
            int last = original[original.length - 1];
            for (int i = original.length; i < newLength; ++i) {
                result[i] = last;
            }
            return result;
        }

        @Override
        public Object getValue(String key) {
            Object value = this.delegate.getValue(key);
            if (value == null) {
                value = super.getValue(key);
            }
            return value;
        }
    }

    class Listener
    extends MouseAdapter {
        Listener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            GlassPane.this.draggingStart = point;
            GlassPane.this.mouseModifiers = e.getModifiersEx();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (GlassPane.this.resizingMode == 0) {
                    int row;
                    int column;
                    GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                    if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent) && (GlassPane.this.mouseModifiers & 0x80) == 0) {
                        GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                    }
                    if ((column = GlassPane.this.findColumnHeader(point)) != -1) {
                        // empty if block
                    }
                    if ((row = GlassPane.this.findRowHeader(point)) == -1) {
                        // empty if block
                    }
                } else {
                    GlassPane.this.resizing = true;
                    GlassPane.this.requestFocusInWindow();
                    GlassPane.this.draggingRect = GlassPane.this.fromComponentPane(GlassPane.this.selectionResizingBounds(GlassPane.this.focusedComponent));
                    GlassPane.this.newGridX = GlassPane.this.gridInfo.getGridX(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridY = GlassPane.this.gridInfo.getGridY(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridHeight = GlassPane.this.gridInfo.getGridHeight(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridWidth = GlassPane.this.gridInfo.getGridWidth(GlassPane.this.focusedComponent);
                    GlassPane.this.initSelFields();
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                    GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                }
            }
            GlassPane.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point point = e.getPoint();
            if (GlassPane.this.moving) {
                GlassPane.this.moving = false;
                GlassPane.this.changeLocation();
            } else if (GlassPane.this.resizing) {
                GlassPane.this.resizing = false;
                GlassPane.this.changeLocation();
            } else if (GlassPane.this.selecting) {
                GlassPane.this.selecting = false;
                boolean inverse = (GlassPane.this.mouseModifiers & 0x80) != 0;
                HashSet<Component> newSelection = new HashSet<Component>();
                if (inverse) {
                    newSelection.addAll(GlassPane.this.selection);
                }
                for (Component comp : GlassPane.this.componentPane.getComponents()) {
                    if (GridUtils.isPaddingComponent(comp)) continue;
                    Rectangle rect = GlassPane.this.fromComponentPane(comp.getBounds());
                    if (!GlassPane.this.draggingRect.intersects(rect)) continue;
                    if (inverse && newSelection.contains(comp)) {
                        newSelection.remove(comp);
                        continue;
                    }
                    newSelection.add(comp);
                }
                GlassPane.this.setSelection(newSelection);
            } else {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (GlassPane.this.focusedComponent != null && (GlassPane.this.mouseModifiers & 0x80) != 0) {
                        HashSet<Component> newSelection = new HashSet<Component>();
                        newSelection.addAll(GlassPane.this.selection);
                        if (GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                            newSelection.remove(GlassPane.this.focusedComponent);
                        } else {
                            newSelection.add(GlassPane.this.focusedComponent);
                        }
                        GlassPane.this.setSelection(newSelection);
                    } else {
                        GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                    }
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                    if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent) && GlassPane.this.focusedComponent != null) {
                        GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                    }
                    List<GridAction> actions = null;
                    DesignerContext context = GlassPane.this.currentContext();
                    if (!GlassPane.this.selection.isEmpty()) {
                        context.setFocusedComponent(GlassPane.this.focusedComponent);
                        actions = GlassPane.this.gridManager.designerActions(GridAction.Context.COMPONENT);
                    }
                    int column = GlassPane.this.findColumnHeader(point);
                    context.setFocusedColumn(column);
                    if (column != -1) {
                        actions = GlassPane.this.gridManager.designerActions(GridAction.Context.COLUMN);
                    }
                    int row = GlassPane.this.findRowHeader(point);
                    context.setFocusedRow(row);
                    if (row != -1) {
                        actions = GlassPane.this.gridManager.designerActions(GridAction.Context.ROW);
                    }
                    if (GlassPane.this.selection.isEmpty() && column == -1 && row == -1) {
                        int height;
                        int width;
                        int y;
                        Point shift = GlassPane.this.fromComponentPane(new Point());
                        int x = GlassPane.this.gridInfo.getX();
                        Rectangle rect = new Rectangle(x + shift.x, (y = GlassPane.this.gridInfo.getY()) + shift.y, width = GlassPane.this.gridInfo.getWidth(), height = GlassPane.this.gridInfo.getHeight());
                        if (rect.contains(point)) {
                            GlassPane.this.focusedCellColumn = GlassPane.this.gridXLocation(point.x - shift.x, true);
                            GlassPane.this.focusedCellRow = GlassPane.this.gridYLocation(point.y - shift.y, true);
                            context.setFocusedColumn(GlassPane.this.focusedCellColumn);
                            context.setFocusedRow(GlassPane.this.focusedCellRow);
                            actions = GlassPane.this.gridManager.designerActions(GridAction.Context.CELL);
                        }
                    } else {
                        GlassPane.this.focusedCellColumn = -1;
                        GlassPane.this.focusedCellRow = -1;
                    }
                    if (actions != null) {
                        JPopupMenu menu = new JPopupMenu();
                        for (GridAction action : actions) {
                            JMenuItem menuItem = action.getPopupPresenter(GlassPane.this);
                            if (menuItem == null) {
                                GridActionWrapper wrapper = new GridActionWrapper(action);
                                wrapper.setDesignerContext(context);
                                menu.add(wrapper);
                                continue;
                            }
                            menu.add(menuItem);
                        }
                        GlassPane.this.designer.updateContextMenu(context, menu);
                        GlassPane.this.draggingStart = null;
                        menu.show(GlassPane.this, point.x, point.y);
                    }
                }
            }
            GlassPane.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!GlassPane.this.selection.isEmpty()) {
                GlassPane.this.updateCursor(e.getPoint());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GlassPane.this.draggingStart == null) {
                GlassPane.this.draggingStart = e.getPoint();
            }
            if (GlassPane.this.resizing) {
                GlassPane.this.draggingRect = GlassPane.this.calculateResizingRectangle(e.getPoint(), GlassPane.this.focusedComponent);
                GlassPane.this.calculateResizingGridLocation();
            } else if (GlassPane.this.focusedComponent == null) {
                GlassPane.this.selecting = true;
                GlassPane.this.draggingRect = new Rectangle(GlassPane.this.draggingStart);
                GlassPane.this.draggingRect.add(e.getPoint());
            } else if (!GlassPane.this.selection.isEmpty() && SwingUtilities.isLeftMouseButton(e)) {
                if (!GlassPane.this.moving) {
                    if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                        HashSet<Component> newSelection = new HashSet<Component>();
                        if ((GlassPane.this.mouseModifiers & 0x80) != 0) {
                            newSelection.addAll(GlassPane.this.selection);
                        }
                        newSelection.add(GlassPane.this.focusedComponent);
                        GlassPane.this.setSelection(newSelection);
                    }
                    GlassPane.this.newGridHeight = GlassPane.this.gridInfo.getGridHeight(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridWidth = GlassPane.this.gridInfo.getGridWidth(GlassPane.this.focusedComponent);
                    GlassPane.this.initSelFields();
                    GlassPane.this.requestFocusInWindow();
                }
                GlassPane.this.moving = true;
                GlassPane.this.draggingRect = GlassPane.this.calculateMovingRectangle(e.getPoint());
                GlassPane.this.calculateMovingGridLocation(e.getPoint());
            }
            GlassPane.this.repaint();
        }
    }
}

