/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;

public class GridUtils {
    private static final String PADDING_COMPONENT = "dummyComponent";
    public static final int PADDING_SIZE = 20;

    public static boolean isPaddingComponent(Component comp) {
        boolean padding = false;
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            padding = jcomp.getClientProperty(PADDING_COMPONENT) != null;
        }
        return padding;
    }

    public static void removePaddingComponents(GridManager manager) {
        Container cont = manager.getContainer();
        for (Component comp : cont.getComponents()) {
            if (!GridUtils.isPaddingComponent(comp)) continue;
            manager.removeComponent(comp);
        }
    }

    public static void addPaddingComponents(GridManager manager, int columnNo, int rowNo) {
        manager.updateLayout(false);
        boolean shouldPad = FormLoaderSettings.getInstance().getPadEmptyCells();
        if (!shouldPad) {
            return;
        }
        Container container = manager.getContainer();
        if (container.getComponentCount() == 0) {
            Component padding = GridUtils.createPaddingComponent(true, true);
            manager.addComponent(padding, 0, 0, 1, 1);
        }
        columnNo = Math.max(columnNo, 1);
        rowNo = Math.max(rowNo, 1);
        boolean[] paddedColumn = new boolean[columnNo];
        boolean[] paddedRow = new boolean[rowNo];
        if (container.getLayout() instanceof GridBagLayout) {
            GridUtils.revalidateGrid(manager);
            int pad = 2;
            for (Component comp : container.getComponents()) {
                Dimension prefSize;
                Dimension minSize;
                if (GridUtils.isPaddingComponent(comp) || !(comp instanceof Box.Filler)) continue;
                Dimension dim = comp.getSize();
                if (dim.width == 0) {
                    minSize = comp.getMinimumSize();
                    prefSize = comp.getPreferredSize();
                    if (prefSize.width == 0) {
                        comp.setMinimumSize(new Dimension(pad, minSize.height));
                        comp.setPreferredSize(new Dimension(pad, prefSize.height));
                    }
                }
                if (dim.height != 0) continue;
                minSize = comp.getMinimumSize();
                prefSize = comp.getPreferredSize();
                if (prefSize.height != 0) continue;
                comp.setMinimumSize(new Dimension(minSize.width, pad));
                comp.setPreferredSize(new Dimension(prefSize.width, pad));
            }
        }
        boolean modified = true;
        while (modified) {
            Component padding;
            int i;
            modified = false;
            GridUtils.revalidateGrid(manager);
            GridInfoProvider info = manager.getGridInfo();
            int[] columnBounds = info.getColumnBounds();
            int[] rowBounds = info.getRowBounds();
            for (i = 0; i < columnNo; ++i) {
                if (paddedColumn[i] || i < columnBounds.length - 1 && columnBounds[i] + 1 < columnBounds[i + 1]) continue;
                padding = GridUtils.createPaddingComponent(true, false);
                manager.addComponent(padding, i, 0, 1, 1);
                paddedColumn[i] = true;
                modified = true;
            }
            for (i = 0; i < rowNo; ++i) {
                if (paddedRow[i] || i < rowBounds.length - 1 && rowBounds[i] + 1 < rowBounds[i + 1]) continue;
                padding = GridUtils.createPaddingComponent(false, true);
                manager.addComponent(padding, 0, i, 1, 1);
                paddedRow[i] = true;
                modified = true;
            }
        }
    }

    private static Component createPaddingComponent(boolean horizontalPadding, boolean verticalPadding) {
        Dimension dim = new Dimension(horizontalPadding ? 20 : 0, verticalPadding ? 20 : 0);
        JComponent padding = (JComponent)Box.createRigidArea(dim);
        padding.putClientProperty(PADDING_COMPONENT, Boolean.TRUE);
        return padding;
    }

    public static void revalidateGrid(GridManager manager) {
        Container cont = manager.getContainer();
        Container parent = cont.getParent();
        parent.invalidate();
        parent.doLayout();
        cont.invalidate();
        cont.doLayout();
    }
}

