/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.ChooseBeansWizardPanel;
import org.netbeans.modules.form.palette.ChooseCategoryWizardPanel;
import org.netbeans.modules.form.palette.ChooseJARWizardPanel;
import org.netbeans.modules.form.palette.ChooseLibraryWizardPanel;
import org.netbeans.modules.form.palette.ChooseProjectWizardPanel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

class AddToPaletteWizard
extends WizardDescriptor {
    ATPWizardIterator wizardIterator;
    private List<? extends ClassSource.Entry> selectedFiles;
    private BeanInstaller.ItemInfo[] selectedBeans;
    private String selectedCategory;
    private Class<? extends ClassSource.Entry> sourceType;
    private Dialog dialog;

    public AddToPaletteWizard() {
        this(new ATPWizardIterator());
    }

    private AddToPaletteWizard(ATPWizardIterator iterator) {
        this.wizardIterator = iterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(PaletteUtils.getBundleString("CTL_AddToPaletteWizard_Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    public boolean show(Class<? extends ClassSource.Entry> sourceType) {
        String firstStep_key;
        this.sourceType = sourceType;
        if (sourceType == ClassSource.JarEntry.class) {
            firstStep_key = "CTL_SelectJAR_Step";
        } else if (sourceType == ClassSource.LibraryEntry.class) {
            firstStep_key = "CTL_SelectLibrary_Step";
        } else if (sourceType == ClassSource.ProjectEntry.class) {
            firstStep_key = "CTL_SelectProject_Step";
        } else {
            throw new IllegalArgumentException();
        }
        this.putProperty("WizardPanel_contentData", new String[]{PaletteUtils.getBundleString(firstStep_key), PaletteUtils.getBundleString("CTL_SelectBeans_Step"), PaletteUtils.getBundleString("CTL_SelectCategory_Step")});
        this.wizardIterator.setSourceType(sourceType);
        this.setPanelsAndSettings(this.wizardIterator, (Object)this);
        this.updateState();
        if (this.dialog == null) {
            this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        }
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.getValue() == FINISH_OPTION;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    void setJARFiles(List<? extends ClassSource.Entry> files) {
        this.selectedFiles = files;
    }

    List<? extends ClassSource.Entry> getJARFiles() {
        return this.selectedFiles;
    }

    void setSelectedBeans(BeanInstaller.ItemInfo[] beans) {
        this.selectedBeans = beans;
    }

    BeanInstaller.ItemInfo[] getSelectedBeans() {
        return this.selectedBeans;
    }

    void setSelectedCategory(String name) {
        this.selectedCategory = name;
    }

    String getSelectedCategory() {
        return this.selectedCategory;
    }

    Class<? extends ClassSource.Entry> getSourceType() {
        return this.sourceType;
    }

    static class ATPWizardIterator
    implements WizardDescriptor.Iterator<AddToPaletteWizard> {
        List<WizardDescriptor.Panel<AddToPaletteWizard>> panels = new ArrayList<WizardDescriptor.Panel<AddToPaletteWizard>>();
        int stage;

        ATPWizardIterator() {
        }

        void setSourceType(Class<? extends ClassSource.Entry> sourceType) {
            this.panels.clear();
            if (sourceType == ClassSource.JarEntry.class) {
                this.panels.add(new ChooseJARWizardPanel());
            } else if (sourceType == ClassSource.LibraryEntry.class) {
                this.panels.add(new ChooseLibraryWizardPanel());
            } else if (sourceType == ClassSource.ProjectEntry.class) {
                this.panels.add(new ChooseProjectWizardPanel());
            } else {
                throw new IllegalArgumentException();
            }
            this.panels.add(new ChooseBeansWizardPanel());
            this.panels.add((WizardDescriptor.Panel<AddToPaletteWizard>)new ChooseCategoryWizardPanel());
            this.stage = 1;
        }

        static int getPanelsCount() {
            return 3;
        }

        public WizardDescriptor.Panel<AddToPaletteWizard> current() {
            return this.panels.get(this.stage - 1);
        }

        public boolean hasNext() {
            return this.stage < ATPWizardIterator.getPanelsCount();
        }

        public boolean hasPrevious() {
            return this.stage > 1;
        }

        public String name() {
            return "";
        }

        public void nextPanel() {
            if (this.stage < ATPWizardIterator.getPanelsCount()) {
                ++this.stage;
            }
        }

        public void previousPanel() {
            if (this.stage > 1) {
                --this.stage;
            }
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }
}

