/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.IOException;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.MyRandomAccessFile;

public class FileMagic {
    private MyRandomAccessFile reader;
    private Magic magic;

    public FileMagic(String objFileName) throws WrongFileFormatException, IOException {
        this.reader = new MyRandomAccessFile(objFileName);
        try {
            this.readMagic();
        }
        catch (WrongFileFormatException ex) {
            throw new WrongFileFormatException(ex.getMessage() + ":" + objFileName);
        }
    }

    public MyRandomAccessFile getReader() {
        return this.reader;
    }

    public Magic getMagic() {
        return this.magic;
    }

    private void readMagic() throws WrongFileFormatException {
        byte[] bytes = new byte[8];
        try {
            this.reader.readFully(bytes);
        }
        catch (IOException ex) {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
        if (FileMagic.isElfMagic(bytes)) {
            this.magic = Magic.Elf;
        } else if (FileMagic.isCoffMagic(bytes)) {
            this.magic = Magic.Coff;
        } else if (FileMagic.isExeMagic(bytes)) {
            this.magic = Magic.Exe;
        } else if (FileMagic.isPeMagic(bytes)) {
            this.magic = Magic.Pe;
        } else if (FileMagic.isMachoMagic(bytes)) {
            this.magic = Magic.Macho;
        } else if (FileMagic.isArchiveMagic(bytes)) {
            this.magic = Magic.Arch;
        } else {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
    }

    public void dispose() {
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
    }

    public static boolean isExeMagic(byte[] bytes) {
        return bytes[0] == 77 && bytes[1] == 90;
    }

    public static boolean isPeMagic(byte[] bytes) {
        return bytes[0] == 80 && bytes[1] == 69 && bytes[2] == 0 && bytes[3] == 0;
    }

    public static boolean isCoffMagic(byte[] bytes) {
        return bytes[0] == 76 && bytes[1] == 1;
    }

    public static boolean isElfMagic(byte[] bytes) {
        return bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70;
    }

    public static boolean isMachoMagic(byte[] bytes) {
        return (bytes[0] == -50 || bytes[0] == -49) && bytes[1] == -6 && bytes[2] == -19 && bytes[3] == -2 || bytes[0] == -2 && bytes[1] == -19 && bytes[2] == -6 && bytes[3] == -50 || bytes[0] == -54 && bytes[1] == -2 && bytes[2] == -70 && bytes[3] == -66 || bytes[0] == 74 && bytes[1] == 111 && bytes[2] == 121 && bytes[3] == 33 && bytes[4] == 112 && bytes[5] == 101 && bytes[6] == 102 && bytes[7] == 102;
    }

    public static boolean isArchiveMagic(byte[] bytes) {
        return bytes[0] == 33 && bytes[1] == 60 && bytes[2] == 97 && bytes[3] == 114 && bytes[4] == 99 && bytes[5] == 104 && bytes[6] == 62 && bytes[7] == 10;
    }
}

