/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.api.ui.AutocompletionProvider;
import org.netbeans.modules.remote.spi.AutocompletionProviderFactory;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class AutocompletionSupport
implements ConnectionListener {
    private static final WeakHashMap<Key, AutocompletionProvider> cache = new WeakHashMap();

    private AutocompletionSupport() {
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)((Object)this), (Object)ConnectionManager.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutocompletionProvider getProvider(ExecutionEnvironment env) {
        AutocompletionProvider result;
        if (env == null || !ConnectionManager.getInstance().isConnectedTo(env)) {
            return null;
        }
        Key key = new Key(env);
        WeakHashMap<Key, AutocompletionProvider> weakHashMap = cache;
        synchronized (weakHashMap) {
            result = cache.get(key);
            if (result == null) {
                Collection factories = Lookup.getDefault().lookupAll(AutocompletionProviderFactory.class);
                ArrayList<AutocompletionProvider> providers = new ArrayList<AutocompletionProvider>();
                for (AutocompletionProviderFactory factory : factories) {
                    if (!factory.supports(env)) continue;
                    AutocompletionProvider provider = factory.newInstance(env);
                    providers.add(provider);
                }
                result = new ProxyProvider(providers);
                cache.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(ExecutionEnvironment env) {
        WeakHashMap<Key, AutocompletionProvider> weakHashMap = cache;
        synchronized (weakHashMap) {
            cache.remove(new Key(env));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(ExecutionEnvironment env) {
        WeakHashMap<Key, AutocompletionProvider> weakHashMap = cache;
        synchronized (weakHashMap) {
            cache.remove(new Key(env));
        }
    }

    private static final class Key {
        final ExecutionEnvironment env;
        final boolean connected;

        public Key(ExecutionEnvironment env) {
            this.env = env;
            this.connected = ConnectionManager.getInstance().isConnectedTo(env);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.connected == that.connected && this.env.equals(that.env);
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.env != null ? this.env.hashCode() : 0);
            hash = 97 * hash + (this.connected ? 1 : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProxyProvider
    implements AutocompletionProvider {
        private final ArrayList<AutocompletionProvider> providers;

        private ProxyProvider(ArrayList<AutocompletionProvider> providers) {
            this.providers = new ArrayList<AutocompletionProvider>(providers);
        }

        @Override
        public List<String> autocomplete(String str) {
            TreeSet<String> set = new TreeSet<String>();
            for (AutocompletionProvider provider : this.providers) {
                set.addAll(provider.autocomplete(str));
            }
            return new ArrayList<String>(set);
        }
    }
}

