/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;

final class CachedRemoteInputStream
extends InputStream {
    private static final int BUFFER_SIZE;
    private final RemotePlainFile remoteFile;
    private byte[] buffer;
    private int position;
    private final Writer writer = new PrintWriter(System.err);
    private Object delegate;

    CachedRemoteInputStream(RemotePlainFile remoteFile, ExecutionEnvironment srcExecEnv) {
        this.remoteFile = remoteFile;
        this.position = 0;
        this.buffer = CommonTasksSupport.readFile((String)remoteFile.remotePath, (ExecutionEnvironment)srcExecEnv, (long)0L, (int)BUFFER_SIZE, (Writer)this.writer);
    }

    private CachedRemoteInputStream(CachedRemoteInputStream master) {
        this.remoteFile = master.remoteFile;
        this.position = 0;
        this.buffer = master.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.delegate != null) {
            if (this.delegate instanceof FileInputStream) {
                return ((FileInputStream)this.delegate).read();
            }
            return -1;
        }
        if (this.position < this.buffer.length) {
            return 0xFF & this.buffer[this.position++];
        }
        try {
            int debug;
            if (this.buffer.length < BUFFER_SIZE) {
                RemoteFileSystemUtils.getCanonicalParent(this.remoteFile).ensureChildSync(this.remoteFile);
                int n = -1;
                return n;
            }
            RemoteFileSystemUtils.getCanonicalParent(this.remoteFile).ensureChildSync(this.remoteFile);
            this.delegate = new FileInputStream(this.remoteFile.cache);
            if (this.remoteFile.cache.length() > 0x100000L) {
                debug = 0;
                if (!$assertionsDisabled) {
                    debug = 1;
                    if (1 == 0) {
                        throw new AssertionError();
                    }
                }
                if (debug != 0) {
                    new Exception("Too long remote file " + this.remoteFile.remotePath).printStackTrace(System.err);
                }
            }
            while (this.position > 0) {
                ((FileInputStream)this.delegate).read();
                --this.position;
            }
            debug = ((FileInputStream)this.delegate).read();
            return debug;
        }
        catch (ConnectException ex) {
            int n = -1;
            return n;
        }
        catch (InterruptedException ex) {
            int n = -1;
            return n;
        }
        catch (CancellationException ex) {
            int n = -1;
            return n;
        }
        catch (ExecutionException ex) {
            int n = -1;
            return n;
        }
        finally {
            if (this.delegate == null) {
                this.delegate = -1;
            }
        }
    }

    CachedRemoteInputStream reuse() {
        if (this.delegate != null) {
            return null;
        }
        return new CachedRemoteInputStream(this);
    }

    static {
        int prefferedBufferSize = 8192;
        int defaultBufferSize = -1;
        try {
            Field field = BufferedInputStream.class.getDeclaredField("defaultBufferSize");
            if (field != null) {
                field.setAccessible(true);
                defaultBufferSize = field.getInt(BufferedInputStream.class);
            }
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchFieldException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        BUFFER_SIZE = defaultBufferSize > prefferedBufferSize ? defaultBufferSize : prefferedBufferSize;
    }
}

