/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalFileSystemProvider
implements FileSystemProviderImplementation {
    private FileSystem rootFileSystem = null;
    private Map<String, LocalFileSystem> nonRootFileSystems = new HashMap<String, LocalFileSystem>();
    private final boolean isWindows = Utilities.isWindows();

    @Override
    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return FileUtil.normalizePath((String)absPath);
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    @Override
    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        String absPath = FileSystemProvider.isAbsolute(relativeOrAbsolutePath) ? relativeOrAbsolutePath : baseFileObject.getPath() + File.separatorChar + relativeOrAbsolutePath.toString();
        return FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)absPath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getRootFileSystem() {
        if (this.rootFileSystem == null) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("NetBeans", ".tmp");
                tmpFile = FileUtil.normalizeFile((File)tmpFile);
                FileObject fo = FileUtil.toFileObject((File)tmpFile);
                this.rootFileSystem = fo.getFileSystem();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return this.rootFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        if (env.isLocal()) {
            LocalFileSystemProvider localFileSystemProvider = this;
            synchronized (localFileSystemProvider) {
                if ("/".equals(root) || "".equals(root)) {
                    return this.getRootFileSystem();
                }
                LocalFileSystem fs = this.nonRootFileSystems.get(root);
                if (fs == null) {
                    fs = new LocalFileSystem();
                    try {
                        fs.setRootDirectory(new File(root));
                        this.nonRootFileSystems.put(root, fs);
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return fs;
            }
        }
        return null;
    }

    @Override
    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        RemoteLogger.assertTrue(file != null, "null file");
        if (file == null) {
            return fileObject;
        }
        File canonicalFile = file.getCanonicalFile();
        if (canonicalFile.equals(file)) {
            return fileObject;
        }
        FileObject canonicalFileObject = FileUtil.toFileObject((File)canonicalFile);
        RemoteLogger.assertTrue(canonicalFileObject != null, "null canonical file");
        return canonicalFileObject == null ? fileObject : canonicalFileObject;
    }

    @Override
    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return this.getCanonicalFileObject(fileObject).getPath();
    }

    @Override
    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        return new File(absPath).getCanonicalPath();
    }

    @Override
    public boolean isMine(ExecutionEnvironment env) {
        return env.isLocal();
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        return ExecutionEnvironmentFactory.getLocal();
    }

    @Override
    public boolean isMine(FileObject fileObject) {
        try {
            return this.isMine(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            RemoteLogger.getInstance().log(Level.WARNING, ex.getLocalizedMessage(), ex);
            return false;
        }
    }

    @Override
    public boolean isMine(FileSystem fileSystem) {
        if (fileSystem instanceof LocalFileSystem) {
            return true;
        }
        FileSystem rootFS = this.getRootFileSystem();
        return rootFS != null && rootFS.getClass() == fileSystem.getClass();
    }

    @Override
    public boolean isMine(String absoluteURL) {
        if (this.isWindows) {
            return absoluteURL.length() > 1 && absoluteURL.charAt(1) == ':';
        }
        return absoluteURL.startsWith("/");
    }

    @Override
    public boolean waitWrites(ExecutionEnvironment env, List<String> failedFiles) throws InterruptedException {
        return true;
    }

    @Override
    public FileObject urlToFileObject(String absoluteURL) {
        File file = new File(absoluteURL);
        return FileUtil.toFileObject((File)file);
    }

    @Override
    public String toURL(FileObject fileObject) {
        return fileObject.getPath();
    }

    @Override
    public String toURL(FileSystem fileSystem, String absPath) {
        return absPath;
    }

    @Override
    public void addDownloadListener(FileSystemProvider.DownloadListener listener) {
    }

    @Override
    public void removeDownloadListener(FileSystemProvider.DownloadListener listener) {
    }
}

