/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.WritingQueue;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileSystemProvider
implements FileSystemProviderImplementation {
    @Override
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env);
    }

    @Override
    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env).normalizeAbsolutePath(absPath);
    }

    @Override
    public boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    @Override
    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        if (baseFileObject instanceof RemoteFileObjectBase) {
            ExecutionEnvironment execEnv = ((RemoteFileObjectBase)baseFileObject).getExecutionEnvironment();
            if (RemoteFileSystemProvider.isPathAbsolute(relativeOrAbsolutePath)) {
                relativeOrAbsolutePath = RemoteFileSystemManager.getInstance().getFileSystem(execEnv).normalizeAbsolutePath(relativeOrAbsolutePath);
                try {
                    return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                return baseFileObject.getFileObject(relativeOrAbsolutePath);
            }
        }
        return null;
    }

    private static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) > 0;
    }

    @Override
    public boolean isMine(ExecutionEnvironment env) {
        return env.isRemote();
    }

    @Override
    public boolean isMine(FileObject fileObject) {
        return fileObject instanceof RemoteFileObjectBase;
    }

    @Override
    public boolean isMine(FileSystem fileSystem) {
        return fileSystem instanceof RemoteFileSystem;
    }

    @Override
    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject);
    }

    @Override
    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject).getPath();
    }

    @Override
    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        FileObject fo = fs.findResource(absPath);
        return fo == null ? null : this.getCanonicalFileObject(fo).getPath();
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    @Override
    public boolean isMine(String absoluteURL) {
        return absoluteURL.startsWith("rfs:");
    }

    @Override
    public boolean waitWrites(ExecutionEnvironment env, List<String> failedFiles) throws InterruptedException {
        if (env.isRemote()) {
            return WritingQueue.getInstance(env).waitFinished(failedFiles);
        }
        return true;
    }

    @Override
    public FileObject urlToFileObject(String path) {
        if (path.startsWith("rfs:")) {
            int port = 0;
            StringBuilder hostName = new StringBuilder();
            CharSequence remotePath = "";
            boolean insideHost = true;
            for (int i = "rfs:".length(); i < path.length(); ++i) {
                char c = path.charAt(i);
                if (insideHost) {
                    if (c == ':') {
                        insideHost = false;
                        continue;
                    }
                    hostName.append(c);
                    continue;
                }
                if (Character.isDigit(c)) {
                    int digit = c - 48;
                    port = port * 10 + digit;
                    continue;
                }
                remotePath = path.subSequence(i, path.length());
                break;
            }
            if (hostName.length() == 0) {
                throw new IllegalArgumentException("Invalid path: " + path);
            }
            RemoteFileObjectBase fo = null;
            RemoteFileSystem fs = null;
            ExecutionEnvironment env = RemoteFileSystemUtils.getExecutionEnvironment(hostName.toString(), 0);
            if (env != null) {
                fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
                fo = fs.findResource(remotePath.toString());
            }
            return fo;
        }
        return null;
    }

    @Override
    public String toURL(FileObject fileObject) {
        if (fileObject instanceof RemoteFileObjectBase) {
            ExecutionEnvironment env = ((RemoteFileObjectBase)fileObject).getExecutionEnvironment();
            return this.getUrlPrefix(env) + fileObject.getPath();
        }
        return null;
    }

    private String getUrlPrefix(ExecutionEnvironment env) {
        return "rfs:" + env.getHost() + ':' + env.getSSHPort();
    }

    @Override
    public String toURL(FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(RemoteFileSystemUtils.isPathAbsolute(absPath), "Path must be absolute: " + absPath);
        if (fileSystem instanceof RemoteFileSystem) {
            ExecutionEnvironment env = ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
            return this.getUrlPrefix(env) + absPath;
        }
        throw new IllegalArgumentException("File system should be an istance of " + RemoteFileSystem.class.getName());
    }

    @Override
    public void addDownloadListener(FileSystemProvider.DownloadListener listener) {
        RemoteFileSystemManager.getInstance().addDownloadListener(listener);
    }

    @Override
    public void removeDownloadListener(FileSystemProvider.DownloadListener listener) {
        RemoteFileSystemManager.getInstance().removeDownloadListener(listener);
    }
}

