/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.openide.filesystems.FileObject;

public final class RemoteLink
extends RemoteLinkBase {
    private String link;

    public RemoteLink(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, FileObject parent, String remotePath, String link) {
        super(fileSystem, execEnv, parent, remotePath);
        this.setLink(link, parent);
    }

    private static String normalize(String link, FileObject parent) {
        if (link.startsWith("/")) {
            return link;
        }
        String parentPath = parent.getPath();
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        return parentPath + '/' + link;
    }

    public FileType getType() {
        return FileType.Symlink;
    }

    public RemoteFileObjectBase getDelegate() {
        RemoteFileObjectBase delegate = this.fileSystem.findResource(this.link);
        return delegate;
    }

    final void setLink(String link, FileObject parent) {
        this.link = RemoteLink.normalize(link, parent);
    }

    protected void postDeleteChild(FileObject child) {
        this.getDelegate().postDeleteChild(child);
    }

    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.execEnv, this.remotePath, false);
    }
}

