/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectionNotifierDelegate
implements ConnectionListener {
    private static final Map<ExecutionEnvironment, ConnectionNotifierDelegate> instances = new HashMap<ExecutionEnvironment, ConnectionNotifierDelegate>();
    private static RequestProcessor RP = new RequestProcessor("Connection notifier");
    private final ExecutionEnvironment env;
    private boolean shown;
    private Notification notification;
    private final Set<ConnectionNotifier.NamedRunnable> tasks = new HashSet<ConnectionNotifier.NamedRunnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionNotifierDelegate getInstance(ExecutionEnvironment env) {
        Map<ExecutionEnvironment, ConnectionNotifierDelegate> map = instances;
        synchronized (map) {
            ConnectionNotifierDelegate instance = instances.get(env);
            if (instance == null) {
                instance = new ConnectionNotifierDelegate(env);
                instances.put(env, instance);
            }
            return instance;
        }
    }

    public ConnectionNotifierDelegate(ExecutionEnvironment execEnv) {
        this.env = execEnv;
        this.shown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ConnectionNotifier.NamedRunnable task) {
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            this.tasks.add(task);
            this.showIfNeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(ConnectionNotifier.NamedRunnable task) {
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            this.tasks.remove(task);
        }
    }

    public void connected(ExecutionEnvironment env) {
        if (this.env.equals(env)) {
            ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
            RequestProcessor.getDefault().post((Runnable)new ConnectionNotifier.NamedRunnable("Connection notifier for " + env.getDisplayName()){

                protected void runImpl() {
                    ConnectionNotifierDelegate.this.onConnect();
                }
            });
        }
    }

    public void disconnected(ExecutionEnvironment env) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect() {
        ArrayList<ConnectionNotifier.NamedRunnable> toLaunch;
        Notification n;
        ConnectionNotifierDelegate connectionNotifierDelegate = this;
        synchronized (connectionNotifierDelegate) {
            n = this.notification;
            this.shown = false;
        }
        if (n != null) {
            n.clear();
        }
        Set<ConnectionNotifier.NamedRunnable> set = this.tasks;
        synchronized (set) {
            toLaunch = new ArrayList<ConnectionNotifier.NamedRunnable>(this.tasks);
            this.tasks.clear();
        }
        for (ConnectionNotifier.NamedRunnable task : toLaunch) {
            RP.post((Runnable)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showIfNeed() {
        ConnectionNotifierDelegate connectionNotifierDelegate = this;
        synchronized (connectionNotifierDelegate) {
            if (this.shown) {
                return;
            }
            this.shown = true;
            ConnectionManager cm = ConnectionManager.getInstance();
            cm.addConnectionListener((ConnectionListener)this);
            this.show(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void show(Exception error) {
        String details;
        ImageIcon icon;
        String title;
        ActionListener onClickAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post((Runnable)new ConnectionNotifier.NamedRunnable("Requesting connection for " + ConnectionNotifierDelegate.this.env.getDisplayName()){

                    protected void runImpl() {
                        ConnectionNotifierDelegate.this.connect();
                    }
                });
            }
        };
        String envString = this.env.getDisplayName();
        if (error == null) {
            StringBuilder reasons = new StringBuilder();
            for (ConnectionNotifier.NamedRunnable task : this.tasks) {
                reasons.append(' ');
                reasons.append(task.getName());
            }
            title = NbBundle.getMessage(ConnectionNotifierDelegate.class, (String)"ConnectionNotifier.TITLE", (Object)envString, (Object)reasons);
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/remote/impl/fs/ui/exclamation.gif", (boolean)false);
            details = NbBundle.getMessage(ConnectionNotifierDelegate.class, (String)"ConnectionNotifier.DETAILS", (Object)envString);
        } else {
            title = NbBundle.getMessage(this.getClass(), (String)"ConnectionNotifier.error.TITLE", (Object)envString);
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/remote/impl/fs/ui/error.png", (boolean)false);
            String errMsg = error.getMessage() == null ? "" : error.getMessage();
            details = NbBundle.getMessage(this.getClass(), (String)"ConnectionNotifier.error.DETAILS", (Object)errMsg, (Object)envString);
        }
        Notification n = NotificationDisplayer.getDefault().notify(title, (Icon)icon, details, onClickAction, NotificationDisplayer.Priority.HIGH);
        ConnectionNotifierDelegate connectionNotifierDelegate = this;
        synchronized (connectionNotifierDelegate) {
            this.notification = n;
        }
    }

    private void connect() {
        try {
            ConnectionManager.getInstance().connectTo(this.env);
        }
        catch (IOException ex) {
            this.reShow(ex);
        }
        catch (CancellationException ex) {
            this.reShow(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reShow(Exception error) {
        ConnectionNotifierDelegate connectionNotifierDelegate = this;
        synchronized (connectionNotifierDelegate) {
            this.shown = false;
        }
        this.show(error);
    }
}

