/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.RequestProcessor;

public final class ExecSupport {
    private ExecSupport() {
    }

    public static Status call(NativeProcessBuilder npb) {
        Status result;
        if (npb == null) {
            throw new NullPointerException("NULL process builder!");
        }
        RequestProcessor rp = new RequestProcessor("e/o reading", 2);
        try {
            final NativeProcess process = npb.call();
            if (process.getState() == NativeProcess.State.ERROR) {
                process.destroy();
                return new Status(-100, Collections.emptyList(), Arrays.asList("Error while starting a process"));
            }
            Callable<List<String>> ereader = new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessError((Process)process);
                }
            };
            Callable<List<String>> oreader = new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ProcessUtils.readProcessOutput((Process)process);
                }
            };
            FutureTask<List<String>> etask = new FutureTask<List<String>>(ereader);
            FutureTask<List<String>> otask = new FutureTask<List<String>>(oreader);
            rp.post(otask);
            rp.post(etask);
            result = new Status(process.waitFor(), otask.get(), etask.get());
        }
        catch (Throwable th) {
            result = new Status(-100, Collections.emptyList(), Arrays.asList(th.getMessage()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Status {
        public final int exitCode;
        public final List<String> error;
        public final List<String> output;

        private Status(int exitCode, List<String> output, List<String> error) {
            this.exitCode = exitCode;
            this.error = error;
            this.output = output;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

