/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;

public class FindSubtypesVisitor
extends FindVisitor {
    private boolean recursive;

    public FindSubtypesVisitor(boolean recursive, WorkingCopy workingCopy) {
        super(workingCopy);
        this.recursive = recursive;
    }

    @Override
    public Tree visitClass(ClassTree node, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return (Tree)super.visitClass(node, elementToFind);
        }
        if (this.recursive) {
            if (this.isSubtype(this.getCurrentPath(), elementToFind)) {
                this.addUsage(this.getCurrentPath());
            }
        } else {
            TypeElement el = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            Types types = this.workingCopy.getTypes();
            if (el.getSuperclass() != null && types.isSameType(types.erasure(el.getSuperclass()), types.erasure(elementToFind.asType())) || this.containsType(el.getInterfaces(), elementToFind.asType())) {
                this.addUsage(this.getCurrentPath());
            }
        }
        return (Tree)super.visitClass(node, elementToFind);
    }

    private boolean containsType(List<? extends TypeMirror> list, TypeMirror t) {
        Types types = this.workingCopy.getTypes();
        t = types.erasure(t);
        for (TypeMirror typeMirror : list) {
            if (!types.isSameType(t, types.erasure(typeMirror))) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubtype(TreePath t1, Element t2) {
        TypeMirror tm2;
        Types types = this.workingCopy.getTypes();
        Trees trees = this.workingCopy.getTrees();
        TypeMirror tm1 = trees.getTypeMirror(t1);
        if (tm1 == null) {
            return false;
        }
        return types.isSubtype(tm1 = types.erasure(tm1), tm2 = types.erasure(t2.asType())) && !types.isSameType(tm1, tm2);
    }
}

