/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.SafeDeletePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SafeDeleteUI
implements RefactoringUI,
RefactoringUIBypass {
    private final SafeDeleteRefactoring refactoring;
    private Object[] elementsToDelete;
    private SafeDeletePanel panel;
    private ResourceBundle bundle;
    private boolean regulardelete = false;

    public SafeDeleteUI(FileObject[] selectedElements, Collection<TreePathHandle> handles, boolean regulardelete) {
        this.elementsToDelete = selectedElements;
        this.refactoring = new SafeDeleteRefactoring((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])this.elementsToDelete), Lookups.fixed((Object[])handles.toArray(new Object[handles.size()]))}));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(selectedElements));
        this.regulardelete = regulardelete;
    }

    public SafeDeleteUI(TreePathHandle[] selectedElements) {
        this.elementsToDelete = selectedElements;
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])this.elementsToDelete));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(selectedElements[0]));
    }

    public SafeDeleteUI(NonRecursiveFolder nonRecursiveFolder, boolean regulardelete) {
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])new Object[]{nonRecursiveFolder}));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder()));
        this.regulardelete = regulardelete;
    }

    public Problem checkParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.fastCheckParameters();
    }

    public String getDescription() {
        NonRecursiveFolder folder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDelPkg", (Object)folder.getFolder().getNameExt().replace('/', '.'));
        }
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDel", (Object[])this.elementsToDelete);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SafeDeleteUI.class.getName());
    }

    public String getName() {
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"LBL_SafeDel");
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new SafeDeletePanel(this.refactoring, this.regulardelete, parent);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public Problem setParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.checkParameters();
    }

    public boolean isRefactoringBypassRequired() {
        return this.panel.isRegularDelete();
    }

    public void doRefactoringBypass() throws IOException {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            for (FileObject file : SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookupAll(FileObject.class)) {
                                DataObject.find((FileObject)file).delete();
                            }
                            NonRecursiveFolder f = (NonRecursiveFolder)SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookup(NonRecursiveFolder.class);
                            if (f != null) {
                                SafeDeleteUI.this.deletePackage(f.getFolder());
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void deletePackage(FileObject source) {
        FileObject root = ClassPath.getClassPath((FileObject)source, (String)"classpath/source").findOwnerRoot(source);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)source);
        FileObject parent = dataFolder.getPrimaryFile().getParent();
        try {
            DataObject[] ch = dataFolder.getChildren();
            boolean empty = true;
            for (int i = 0; ch != null && i < ch.length; ++i) {
                if (!ch[i].getPrimaryFile().isFolder()) {
                    ch[i].delete();
                    continue;
                }
                if (!empty || !VisibilityQuery.getDefault().isVisible(ch[i].getPrimaryFile())) continue;
                empty = false;
            }
            if (empty) {
                dataFolder.delete();
            }
            while (!parent.equals(root) && parent.getChildren().length == 0) {
                FileObject newParent = parent.getParent();
                parent.delete();
                parent = newParent;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

