/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.support.TableDataProvider;
import org.netbeans.modules.dlight.util.ui.DualPaneSupport;
import org.netbeans.modules.dlight.visualizers.TableViewVisualizer;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.DataRowNode;
import org.netbeans.modules.dlight.visualizers.api.VisualizerToolbarComponentsProvider;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.netbeans.modules.dlight.visualizers.ui.AdvancedDataRowTableOutline;
import org.netbeans.modules.dlight.visualizers.ui.AdvancedTableDataRowNodeChildren;
import org.netbeans.modules.dlight.visualizers.ui.TableViewNodeChildren;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public final class AdvancedTableViewVisualizer
extends TableViewVisualizer<AdvancedTableViewVisualizerConfiguration, DataRow> {
    private final TableDataProvider provider;
    private final JComponent dualViewPane;
    private final String nodeColumnName;
    private final String emptyAnalyzeMessage;
    private final String emptyRunningMessage;
    private final String nodeColumnUName;

    public AdvancedTableViewVisualizer(TableDataProvider provider, AdvancedTableViewVisualizerConfiguration configuration) {
        super((DataProvider)provider, configuration);
        this.provider = provider;
        AdvancedTableViewVisualizerConfigurationAccessor accessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        this.nodeColumnName = accessor.getRowNodeColumnName(configuration);
        this.nodeColumnUName = accessor.getNodeColumnName(configuration);
        this.emptyAnalyzeMessage = accessor.getEmptyAnalyzeMessage(configuration);
        this.emptyRunningMessage = accessor.getEmptyRunningMessage(configuration);
        boolean dualPaneMode = accessor.isDualPaneMode(configuration);
        this.dualViewPane = dualPaneMode ? this.createDualViewPane() : null;
    }

    @Override
    public JComponent getComponent() {
        return this.dualViewPane == null ? this : this.dualViewPane;
    }

    @Override
    protected TableViewNodeChildren<DataRow> initChildren() {
        return new AdvancedTableDataRowNodeChildren((AdvancedTableViewVisualizerConfiguration)this.getVisualizerConfiguration(), this.getLookup());
    }

    @Override
    protected Component initTableView() {
        return new AdvancedDataRowTableOutline(this.nodeColumnUName, (AdvancedTableViewVisualizerConfiguration)this.getVisualizerConfiguration());
    }

    @Override
    protected List<DataRow> getUpdatedData() {
        return this.provider.queryData(this.getMetadata());
    }

    @Override
    protected boolean matchesFilter(String filter, DataRow data) {
        return data.getData(this.nodeColumnName).toString().contains(filter);
    }

    @Override
    protected String getEmptyAnalyzeMessage() {
        return this.emptyAnalyzeMessage;
    }

    @Override
    protected String getEmptyRunningMessage() {
        return this.emptyRunningMessage;
    }

    private JComponent createDualViewPane() {
        AdvancedTableViewVisualizerConfigurationAccessor accessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        DualView result = new DualView(this);
        result.add((Component)DualPaneSupport.forExplorerManager((JComponent)this, (ExplorerManager)super.getExplorerManager(), accessor.getDetailsRenderer((AdvancedTableViewVisualizerConfiguration)this.getVisualizerConfiguration()), (DualPaneSupport.DataAdapter)new DualPaneSupport.DataAdapter<Node, DataRow>(){

            public DataRow convert(Node obj) {
                if (obj instanceof DataRowNode) {
                    return ((DataRowNode)obj).getDataRow();
                }
                return null;
            }
        }), "Center");
        return result;
    }

    private static final class DualView
    extends JPanel
    implements VisualizerToolbarComponentsProvider {
        private final AdvancedTableViewVisualizer orig;

        public DualView(AdvancedTableViewVisualizer orig) {
            this.orig = orig;
            this.setLayout(new BorderLayout());
            this.setFocusable(false);
        }

        @Override
        public List<Component> getToolbarComponents() {
            return this.orig.getToolbarComponents();
        }

        @Override
        public void requestFocus() {
            this.orig.requestFocus();
        }
    }
}

