/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackVisualizer;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CallStackTopComponent
extends TopComponent
implements VisualizerContainer {
    private static CallStackTopComponent instance;
    private static final String PREFERRED_ID = "CallStackTopComponent";
    private String currentToolName;
    private JComponent viewComponent;

    public CallStackTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CallStackTopComponent.class, (String)"CTL_CallStackTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CallStackTopComponent.class, (String)"HINT_CallStackTopComponent"));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized CallStackTopComponent getDefault() {
        if (instance == null) {
            instance = new CallStackTopComponent();
        }
        return instance;
    }

    public static synchronized CallStackTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CallStackTopComponent.class.getName()).warning("Cannot find CallStackTopComponent component. It will not be located properly in the window system.");
            return CallStackTopComponent.getDefault();
        }
        if (win instanceof CallStackTopComponent) {
            return (CallStackTopComponent)win;
        }
        Logger.getLogger(CallStackTopComponent.class.getName()).warning("There seem to be multiple components with the 'CallStackTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CallStackTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocus(boolean temporary) {
        return this.viewComponent.requestFocus(temporary);
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        CallStackTopComponent singleton = CallStackTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void addVisualizer(String toolID, String toolName, Visualizer<?> v) {
        this.setContent(toolName, v.getComponent());
    }

    public void setContent(String toolName, JComponent component) {
        if (component instanceof ThreadStackVisualizer) {
            toolName = ((ThreadStackVisualizer)component).getDisplayName();
        }
        if (this.currentToolName != null && this.currentToolName.equals(toolName) && this.viewComponent == component) {
            return;
        }
        this.currentToolName = toolName;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.viewComponent = component;
        this.add(this.viewComponent, "Center");
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
    }

    public void addContent(String toolName, JComponent component) {
        this.setContent(toolName, component);
    }

    public void removeVisualizer(final Visualizer<?> view) {
        if (EventQueue.isDispatchThread()) {
            this.closeCallStack(view);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallStackTopComponent.this.closeCallStack(view);
                }
            });
        }
    }

    public void showup() {
        this.open();
        this.requestActive();
    }

    private void closeCallStack(Visualizer<?> view) {
        if (this.viewComponent != view.getComponent()) {
            return;
        }
        this.remove(view.getComponent());
        this.setName(NbBundle.getMessage(CallStackTopComponent.class, (String)"CallStackDetails"));
        this.repaint();
    }
}

