/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.TreeTableVisualizer;
import org.netbeans.modules.dlight.visualizers.api.CallersCalleesVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.TreeTableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class CallersCalleesVisualizer
extends TreeTableVisualizer<FunctionCallTreeTableNode> {
    public static final String IS_CALLS = "TopTenFunctionsIsCalls";
    private static final int TOP_FUNCTIONS_COUNT = 10;
    private final CallersCalleesVisualizerConfiguration configuration;
    private final StackDataProvider dataProvider;
    private final Object syncFillInLock = new Object();
    private JToggleButton callers;
    private JToggleButton calls;
    private boolean isCalls = true;
    private Future<List<FunctionCallWithMetric>> syncFillDataTask;
    private DefaultMutableTreeNode focusedTreeNode = null;
    private final List<DataTableMetadata.Column> metricsList;

    CallersCalleesVisualizer(StackDataProvider dataProvider, TreeTableVisualizerConfiguration configuration) {
        super(configuration, dataProvider);
        this.configuration = (CallersCalleesVisualizerConfiguration)configuration;
        this.configuration.setNodeActionProvider(new NodeActionsProviderImpl());
        this.dataProvider = dataProvider;
        this.isCalls = NbPreferences.forModule(CallersCalleesVisualizer.class).getBoolean(IS_CALLS, true);
        this.metricsList = Arrays.asList(TreeTableVisualizerConfigurationAccessor.getDefault().getTableColumns(configuration));
    }

    public TreeTableVisualizerConfiguration getConfiguration() {
        return super.getVisualizerConfiguration();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(this.getConfiguration())) {
            return;
        }
        JButton focusOn = new JButton();
        this.calls = new JToggleButton();
        this.callers = new JToggleButton();
        JToolBar buttonsToolbar = this.getButtonsTolbar();
        buttonsToolbar.setFloatable(false);
        buttonsToolbar.setOrientation(1);
        buttonsToolbar.setRollover(true);
        focusOn.setIcon(ImageLoader.loadIcon("focus.png"));
        focusOn.setFocusable(false);
        focusOn.setHorizontalTextPosition(0);
        focusOn.setMaximumSize(new Dimension(28, 28));
        focusOn.setMinimumSize(new Dimension(28, 28));
        focusOn.setPreferredSize(new Dimension(28, 28));
        focusOn.setVerticalTextPosition(3);
        focusOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallersCalleesVisualizer.this.focusOnActionPerformed(evt);
            }
        });
        buttonsToolbar.add(focusOn);
        buttonsToolbar.add(new JToolBar.Separator());
        this.calls.setIcon(ImageLoader.loadIcon("who_is_called.png"));
        this.calls.setFocusable(false);
        this.calls.setHorizontalTextPosition(0);
        this.calls.setVerticalTextPosition(3);
        this.calls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallersCalleesVisualizer.this.callsActionPerformed(evt);
            }
        });
        buttonsToolbar.add(this.calls);
        this.callers.setIcon(ImageLoader.loadIcon("who_calls.png"));
        this.callers.setFocusable(false);
        this.callers.setHorizontalTextPosition(0);
        this.callers.setVerticalTextPosition(3);
        this.callers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallersCalleesVisualizer.this.callersActionPerformed(evt);
            }
        });
        buttonsToolbar.add(this.callers);
        this.repaint();
        this.revalidate();
    }

    private void callsActionPerformed(ActionEvent evt) {
        if (this.isCalls == this.calls.isSelected()) {
            return;
        }
        this.setDirection(true);
    }

    private void callersActionPerformed(ActionEvent evt) {
        if (this.isCalls != this.callers.isSelected()) {
            return;
        }
        this.setDirection(false);
    }

    private void focusOnActionPerformed(ActionEvent evt) {
        ExplorerManager manager = this.getExplorerManager();
        if (manager == null) {
            return;
        }
        Node[] selectedNodes = manager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length == 0) {
            return;
        }
        Node selectedNode = selectedNodes[0];
        this.focusedTreeNode = (DefaultMutableTreeNode)selectedNode.getLookup().lookup(DefaultMutableTreeNode.class);
        FunctionCallWithMetric focusedFunction = this.focusedTreeNode == null ? null : ((FunctionCallTreeTableNode)this.focusedTreeNode.getUserObject()).getDeligator();
        this.setNodes(Arrays.asList(this.focusedTreeNode));
        this.loadTree(this.focusedTreeNode, Arrays.asList(new FunctionCallTreeTableNode(focusedFunction)));
    }

    private ExplorerManager getExplorerManager() {
        if (this.treeTableView != null && this.treeTableView instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)this.treeTableView).getExplorerManager();
        }
        return null;
    }

    private void setDirection(boolean direction) {
        this.isCalls = direction;
        NbPreferences.forModule(CallersCalleesVisualizer.class).putBoolean(IS_CALLS, this.isCalls);
        this.updateButtons();
        this.update();
    }

    private synchronized void update() {
        if (this.focusedTreeNode == null) {
            this.asyncFillModel(this.getConfiguration().getMetadata().getColumns(), true);
            return;
        }
        this.loadTree(this.focusedTreeNode, Arrays.asList((FunctionCallTreeTableNode)this.focusedTreeNode.getUserObject()));
    }

    @Override
    protected void loadTree(final DefaultMutableTreeNode rootNode, final List<FunctionCallTreeTableNode> ppath) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List path = FunctionCallTreeTableNode.getFunctionCalls((List)ppath);
                final List result = CallersCalleesVisualizer.this.dataProvider.getCallees(path, CallersCalleesVisualizer.this.configuration.getMetadata().getColumns(), null, CallersCalleesVisualizer.this.isCalls);
                UIThread.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CallersCalleesVisualizer.this.update(rootNode, result);
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            DLightExecutorService.submit((Runnable)r, (String)"Get callers/callees");
        } else {
            r.run();
        }
    }

    @Override
    protected void updateTree(DefaultMutableTreeNode rootNode, List<FunctionCallTreeTableNode> result) {
        rootNode.removeAllChildren();
        if (result != null) {
            for (FunctionCallTreeTableNode call : result) {
                rootNode.add(new DefaultMutableTreeNode(call));
            }
        }
        this.fireTreeModelChanged(rootNode);
    }

    private void update(DefaultMutableTreeNode rootNode, List<FunctionCallWithMetric> result) {
        rootNode.removeAllChildren();
        if (result != null) {
            for (FunctionCallWithMetric call : result) {
                rootNode.add(new DefaultMutableTreeNode(new FunctionCallTreeTableNode(call)));
            }
        }
        this.fireTreeModelChanged(rootNode);
        this.notifyAnnotedSourceProviders();
    }

    @Override
    protected void syncFillModel(List<DataTableMetadata.Column> columns) {
        List flist = this.dataProvider.getHotSpotFunctions(columns, null, 10);
        this.update(flist);
    }

    private List<FunctionCallWithMetric> getAllChildren(TreeNode n) {
        if (!(n instanceof DefaultMutableTreeNode)) {
            return Collections.emptyList();
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)n;
        if (!(node.getUserObject() instanceof FunctionCallTreeTableNode)) {
            return Collections.emptyList();
        }
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        result.add(((FunctionCallTreeTableNode)node.getUserObject()).getDeligator());
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            result.addAll(this.getAllChildren(node.getChildAt(i)));
        }
        return result;
    }

    private List<FunctionCallWithMetric> getAllFunctions() {
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        int count = this.TREE_ROOT.getChildCount();
        for (int i = 0; i < count; ++i) {
            result.addAll(this.getAllChildren(this.TREE_ROOT.getChildAt(i)));
        }
        return result;
    }

    private void notifyAnnotedSourceProviders() {
        final List<FunctionCallWithMetric> list = this.getAllFunctions();
        Collection supports = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport sourceSupport : supports) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    sourceSupport.updateSource((SourceFileInfoDataProvider)CallersCalleesVisualizer.this.dataProvider, CallersCalleesVisualizer.this.metricsList, list, null);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    private void notifyAnnotedSourceProviders(final List<FunctionCallWithMetric> list) {
        Collection supports = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport sourceSupport : supports) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    sourceSupport.updateSource((SourceFileInfoDataProvider)CallersCalleesVisualizer.this.dataProvider, CallersCalleesVisualizer.this.metricsList, list, null);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    private void update(List<FunctionCallWithMetric> list) {
        boolean isEmptyConent = list == null || list.isEmpty();
        this.setContent(isEmptyConent);
        if (!isEmptyConent) {
            ArrayList<FunctionCallTreeTableNode> res = new ArrayList<FunctionCallTreeTableNode>();
            for (FunctionCallWithMetric c : list) {
                res.add(new FunctionCallTreeTableNode(c));
            }
            this.updateList(res);
            this.notifyAnnotedSourceProviders(list);
        }
    }

    @Override
    protected String getIcon(FunctionCallTreeTableNode node) {
        return super.getIcon(node);
    }

    @Override
    protected void updateButtons() {
        if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(this.getConfiguration())) {
            return;
        }
        if (this.calls != null) {
            this.calls.setSelected(this.isCalls);
            this.callers.setSelected(!this.isCalls);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.syncFillInLock;
        synchronized (object) {
            if (this.syncFillDataTask != null) {
                this.syncFillDataTask.cancel(true);
                this.syncFillDataTask = null;
            }
        }
    }

    @Override
    public int onTimer() {
        if (!this.isShown() || !this.isShowing()) {
            return 0;
        }
        this.syncFillModel(this.configuration.getMetadata().getColumns());
        return 0;
    }

    private class GoToSourceAction
    extends AbstractAction {
        private final FunctionCallWithMetric functionCall;
        private final Future<SourceFileInfoProvider.SourceFileInfo> sourceFileInfoTask;
        private boolean isEnabled;
        private boolean gotTheInfo;

        public GoToSourceAction(FunctionCallWithMetric funcCall) {
            super(NbBundle.getMessage(CallersCalleesVisualizer.class, (String)"GoToSourceActionName"));
            this.isEnabled = false;
            this.gotTheInfo = false;
            this.functionCall = funcCall;
            this.sourceFileInfoTask = DLightExecutorService.submit((Callable)new Callable<SourceFileInfoProvider.SourceFileInfo>(){

                @Override
                public SourceFileInfoProvider.SourceFileInfo call() {
                    return CallersCalleesVisualizer.this.dataProvider.getSourceFileInfo((FunctionCall)GoToSourceAction.this.functionCall);
                }
            }, (String)"SourceFileInfo getting info from CallersCalees Visualizer");
            this.waitForSourceFileInfo();
        }

        private void waitForSourceFileInfo() {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object sourceFileInfo = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                        GoToSourceAction.this.isEnabled = sourceFileInfo != null && sourceFileInfo.isSourceKnown();
                    }
                    catch (InterruptedException ex) {
                        GoToSourceAction.this.isEnabled = false;
                    }
                    catch (ExecutionException ex) {
                        GoToSourceAction.this.isEnabled = false;
                    }
                    finally {
                        GoToSourceAction ex = GoToSourceAction.this;
                        synchronized (ex) {
                            GoToSourceAction.this.gotTheInfo = true;
                        }
                        GoToSourceAction.this.setEnabled(GoToSourceAction.this.isEnabled);
                    }
                }
            }, (String)"Wait For the SourceFileInfo");
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    SourceFileInfoProvider.SourceFileInfo sourceFileInfo = null;
                    try {
                        sourceFileInfo = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if (sourceFileInfo == null) {
                        return;
                    }
                    SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);
                    sourceSupportProvider.showSource(sourceFileInfo);
                    CallersCalleesVisualizer.this.notifyAnnotedSourceProviders();
                }
            }, (String)"GoToSource from Callers Calees Visualizer");
        }
    }

    class NodeActionsProviderImpl
    implements NodeActionsProvider {
        NodeActionsProviderImpl() {
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            if (!(node instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(node);
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object nodeObject = treeNode.getUserObject();
            if (!(nodeObject instanceof FunctionCallTreeTableNode)) {
                return;
            }
            FunctionCallWithMetric functionCall = ((FunctionCallTreeTableNode)nodeObject).getDeligator();
            GoToSourceAction action = new GoToSourceAction(functionCall);
            action.actionPerformed(null);
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            if (!(node instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(node);
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object nodeObject = treeNode.getUserObject();
            if (!(nodeObject instanceof FunctionCallTreeTableNode)) {
                return null;
            }
            return new Action[]{new GoToSourceAction(((FunctionCallTreeTableNode)nodeObject).getDeligator())};
        }
    }
}

