/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;

public class ThreadNameHeaderRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private static final boolean CHANGE_BUTTON = false;
    private ThreadsPanel viewManager;
    private JLabel label;
    private JLabel shift;
    private Rectangle shiftRect;

    public ThreadNameHeaderRenderer(ThreadsPanel aViewManager) {
        this.viewManager = aViewManager;
        this.setLayout(new BorderLayout());
        this.label = new JLabel(ThreadsPanel.THREAD_NAME_ID);
        this.add((Component)this.label, "Center");
        this.shiftRect = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ThreadNameHeaderRenderer component = this;
        component.setBackground(Color.WHITE);
        this.label.setFont(table.getFont().deriveFont(1));
        component.setBorder(new EmptyBorder(0, 3, 0, 3));
        switch (this.viewManager.getThreadNameFormat()) {
            case 1: {
                this.label.setText(ThreadsPanel.THREAD_NAME_CALLEE);
                break;
            }
            case 2: {
                this.label.setText(ThreadsPanel.THREAD_NAME_CALLEE_CALLEE);
                break;
            }
            default: {
                this.label.setText(ThreadsPanel.THREAD_NAME_ID);
            }
        }
        if (column == this.viewManager.getSortedColumn() && this.viewManager.getSortedOrder() != 0) {
            this.label.setIcon(this.getProperIcon(this.viewManager.getSortedOrder() == -1));
        } else {
            this.label.setIcon(null);
        }
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.shiftRect != null && this.shiftRect.getX() <= (double)event.getX() && (double)event.getX() <= this.shiftRect.getX() + this.shiftRect.getWidth()) {
            return ThreadsPanel.THREAD_NAME_FORMAT_TOOL_TIP;
        }
        return super.getToolTipText(event);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    Rectangle getFormatRectangle() {
        return this.shiftRect;
    }

    private ImageIcon getProperIcon(boolean descending) {
        if (descending) {
            return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedDesc.png"));
        }
        return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedAsc.png"));
    }
}

