/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.junit.actions.TestClassInfoTask;
import org.netbeans.modules.junit.output.OutputUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(TestMethodAction.class.getName());
    private String command;

    protected TestMethodAction(String command) {
        this.command = command;
    }

    protected boolean enable(Node[] activatedNodes) {
        ActionProvider ap;
        if (activatedNodes.length != 1) {
            return false;
        }
        SingleMethod sm = this.getTestMethod(activatedNodes[0].getLookup());
        if (sm != null && (ap = OutputUtils.getActionProvider(sm.getFile())) != null) {
            return Arrays.asList(ap.getSupportedActions()).contains(this.command) && ap.isActionEnabled(this.command, Lookups.singleton((Object)sm));
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        ActionProvider ap;
        SingleMethod sm = this.getTestMethod(activatedNodes[0].getLookup());
        if (sm != null && (ap = OutputUtils.getActionProvider(sm.getFile())) != null) {
            ap.invokeAction(this.command, Lookups.singleton((Object)sm));
        }
    }

    private SingleMethod getTestMethod(Lookup lkp) {
        JEditorPane[] panes;
        EditorCookie ec;
        SingleMethod sm = (SingleMethod)lkp.lookup(SingleMethod.class);
        if (sm == null && (ec = (EditorCookie)lkp.lookup(EditorCookie.class)) != null && (panes = ec.getOpenedPanes()).length > 0) {
            int cursor = panes[0].getCaret().getDot();
            JavaSource js = JavaSource.forDocument((Document)panes[0].getDocument());
            TestClassInfoTask task = new TestClassInfoTask(cursor);
            try {
                Future f = js.runWhenScanFinished((Task)task, true);
                if (f.isDone() && task.getFileObject() != null && task.getMethodName() != null) {
                    sm = new SingleMethod(task.getFileObject(), task.getMethodName());
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return sm;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

