/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.netbeans.modules.junit.output.antutils.PatternSet;

final class FileSet {
    private final AntProject project;
    private PatternSet implicitPatternSet;
    private File baseDir;
    private File file;
    private boolean defaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks;

    FileSet(AntProject project) {
        this.project = project;
    }

    void handleChildrenAndAttrs(TaskStructure struct) {
        this.setAttrs(struct);
        this.implicitPatternSet = new PatternSet(this.project);
        this.implicitPatternSet.handleChildrenAndAttrs(struct);
    }

    private void setAttrs(TaskStructure struct) {
        String dirName = struct.getAttribute("dir");
        String fileName = struct.getAttribute("file");
        String defaultExcludes = struct.getAttribute("defaultexcludes");
        String caseSensitive = struct.getAttribute("casesensitive");
        String followSymlinks = struct.getAttribute("followsymlinks");
        if (dirName != null) {
            dirName = this.project.replaceProperties(dirName);
            this.setBaseDir(this.project.resolveFile(dirName));
        }
        if (fileName != null) {
            fileName = this.project.replaceProperties(fileName);
            this.setFile(this.project.resolveFile(fileName));
        }
        if (defaultExcludes != null) {
            defaultExcludes = this.project.replaceProperties(defaultExcludes);
            this.setDefaultExcludes(AntProject.toBoolean(defaultExcludes));
        }
        if (caseSensitive != null) {
            caseSensitive = this.project.replaceProperties(caseSensitive);
            this.setCaseSensitive(AntProject.toBoolean(caseSensitive));
        }
        if (followSymlinks != null) {
            followSymlinks = this.project.replaceProperties(followSymlinks);
            this.setFollowSymlinks(AntProject.toBoolean(followSymlinks));
        }
    }

    private void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    private void setFile(File file) {
        this.file = file;
    }

    private void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    private void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    File getBaseDir() {
        return this.baseDir;
    }

    File getFile() {
        return this.file;
    }

    boolean isDefaultExcludes() {
        return this.defaultExcludes;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    Collection<String> getIncludePatterns() {
        return this.implicitPatternSet.getIncludePatterns();
    }

    Collection<String> getExcludesPatterns() {
        return this.implicitPatternSet.getExcludePatterns();
    }
}

