/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.antutils.AntProject;

final class PatternSet {
    private final AntProject project;
    private Collection<String> includePatterns;
    private Collection<String> excludePatterns;

    PatternSet(AntProject project) {
        this.project = project;
    }

    void handleChildrenAndAttrs(TaskStructure struct) {
        this.setAttrs(struct);
        for (TaskStructure child : struct.getChildren()) {
            Entry entry;
            String childName = child.getName();
            if (childName.equals("include")) {
                entry = new Entry();
                entry.handleChildrenAndAttrs(child);
                if (!entry.isApplicable()) continue;
                this.addIncludePatterns(entry.getPattern());
                continue;
            }
            if (childName.equals("exclude")) {
                entry = new Entry();
                entry.handleChildrenAndAttrs(child);
                if (!entry.isApplicable()) continue;
                this.addExcludePatterns(entry.getPattern());
                continue;
            }
            if (childName.equals("includesfile")) {
                entry = new Entry();
                entry.handleChildrenAndAttrs(child);
                if (!entry.isApplicable()) continue;
                this.addIncludePatterns(this.project.resolveFile(entry.getPattern()));
                continue;
            }
            if (childName.equals("excludesfile")) {
                entry = new Entry();
                entry.handleChildrenAndAttrs(child);
                if (!entry.isApplicable()) continue;
                this.addExcludePatterns(this.project.resolveFile(entry.getPattern()));
                continue;
            }
            if (!childName.equals("patternset")) continue;
            PatternSet patternSet = new PatternSet(this.project);
            patternSet.handleChildrenAndAttrs(child);
            this.addPatternSet(patternSet);
        }
    }

    Collection<String> getIncludePatterns() {
        if (this.includePatterns != null) {
            return this.includePatterns;
        }
        return Collections.emptyList();
    }

    Collection<String> getExcludePatterns() {
        if (this.excludePatterns != null) {
            return this.excludePatterns;
        }
        return Collections.emptyList();
    }

    private void setAttrs(TaskStructure struct) {
        String includes = struct.getAttribute("includes");
        String includesFile = struct.getAttribute("includesFile");
        String excludes = struct.getAttribute("excludes");
        String excludesFile = struct.getAttribute("excludesFile");
        if (includes != null) {
            this.addIncludePatterns(this.project.replaceProperties(includes));
        }
        if (excludes != null) {
            this.addExcludePatterns(this.project.replaceProperties(excludes));
        }
        if (includesFile != null) {
            this.addIncludePatterns(this.project.resolveFile(this.project.replaceProperties(includesFile)));
        }
        if (excludesFile != null) {
            this.addExcludePatterns(this.project.resolveFile(this.project.replaceProperties(excludesFile)));
        }
    }

    private void addIncludePatterns(String patternsString) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.addPatterns(patternsString, this.includePatterns);
    }

    private void addExcludePatterns(String patternsString) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.addPatterns(patternsString, this.excludePatterns);
    }

    private void addIncludePatterns(File includesFile) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.readPatterns(includesFile, this.includePatterns);
    }

    private void addExcludePatterns(File excludesFile) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.readPatterns(excludesFile, this.excludePatterns);
    }

    private void addPatterns(String patternsString, Collection<String> patterns) {
        StringTokenizer tokenizer = new StringTokenizer(patternsString, ", ");
        while (tokenizer.hasMoreTokens()) {
            patterns.add(tokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPatterns(File patternsFile, Collection<String> patterns) {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(patternsFile));
            String line = fileReader.readLine();
            while (line != null) {
                if (line.length() == 0) continue;
                this.addPatterns(this.project.replaceProperties(line), patterns);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "failed to read Ant patterns file " + patternsFile.getAbsolutePath(), ex);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ex2) {}
            }
        }
    }

    private void addPatternSet(PatternSet p) {
        if (p.includePatterns != null) {
            if (this.includePatterns != null) {
                this.includePatterns.addAll(p.includePatterns);
            } else {
                this.includePatterns = p.includePatterns;
            }
        }
        if (p.excludePatterns != null) {
            if (this.excludePatterns != null) {
                this.excludePatterns.addAll(p.excludePatterns);
            } else {
                this.excludePatterns = p.excludePatterns;
            }
        }
    }

    class Entry {
        private String pattern;
        private String ifCondition;
        private String unlessCondition;

        Entry() {
        }

        void handleChildrenAndAttrs(TaskStructure struct) {
            this.setAttrs(struct);
        }

        private void setAttrs(TaskStructure struct) {
            this.pattern = struct.getAttribute("name");
            this.ifCondition = struct.getAttribute("if");
            this.unlessCondition = struct.getAttribute("unless");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isApplicable() {
            if (this.ifCondition != null) {
                PatternSet.this.project;
                if (!AntProject.toBoolean(PatternSet.this.project.replaceProperties(this.ifCondition))) return false;
            }
            if (this.unlessCondition == null) return true;
            PatternSet.this.project;
            if (AntProject.toBoolean(PatternSet.this.project.replaceProperties(this.unlessCondition))) return false;
            return true;
        }

        String getPattern() {
            return PatternSet.this.project.replaceProperties(this.pattern);
        }
    }
}

