/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;

public class CndUtils {
    private static final Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;
    private static volatile Exception lastAssertion;

    private CndUtils() {
    }

    public static boolean isStandalone() {
        return !CndUtils.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !CndUtils.isReleaseMode();
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean isCodeCompletionUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.completion.unittest");
    }

    public static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static void threadsDump() {
        Set<Map.Entry<Thread, StackTraceElement[]>> stack = Thread.getAllStackTraces().entrySet();
        System.err.println("-----Start Thread Dump-----");
        for (Map.Entry<Thread, StackTraceElement[]> entry : stack) {
            System.err.println(entry.getKey().getName());
            for (StackTraceElement element : entry.getValue()) {
                System.err.println("\tat " + element.toString());
            }
            System.err.println();
        }
        System.err.println("-----End Thread Dump-----");
    }

    public static void assertTrue(boolean value) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(value, "Assertion error");
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(object != null, message);
        }
    }

    public static void assertNull(Object object, String message) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(object == null, message);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int threadCount = Integer.getInteger("cnd.modelimpl.parser.threads", Runtime.getRuntime().availableProcessors());
        return Math.max(threadCount, 1);
    }

    public static int getConcurrencyLevel() {
        return CndUtils.getNumberCndWorkerThreads();
    }

    public static void assertFalse(boolean value) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(!value, "Assertion error");
        }
    }

    public static void assertFalse(boolean value, String message) {
        CndUtils.assertTrue(!value, message);
    }

    public static void assertTrue(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value) {
            lastAssertion = new Exception(message);
            LOG.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value) {
            lastAssertion = new Exception(message);
            LOG.log(Level.INFO, message, lastAssertion);
        }
    }

    public static Exception getLastAssertion() {
        return lastAssertion;
    }

    public static void assertAbsolutePathInConsole(String path) {
        if (CndUtils.isDebugMode() && !CndPathUtilitities.isPathAbsolute(path)) {
            CndUtils.assertTrueInConsole(false, "path must be absolute " + path);
        }
    }

    public static void assertAbsolutePathInConsole(String path, String message) {
        if (CndUtils.isDebugMode() && !CndPathUtilitities.isPathAbsolute(path)) {
            CndUtils.assertTrueInConsole(false, message + ' ' + path);
        }
    }

    public static void assertAbsoluteFileInConsole(File file) {
        CndUtils.assertAbsoluteFileInConsole(file, "Absolute path should be used");
    }

    public static void assertAbsoluteFileInConsole(File file, String message) {
        if (CndUtils.isDebugMode() && !file.isAbsolute()) {
            CndUtils.assertTrueInConsole(false, message + ' ' + file.getPath());
        }
    }

    public static void assertNonUiThread() {
        CndUtils.assertFalse(SwingUtilities.isEventDispatchThread(), "Should not be called from UI thread");
    }

    public static void assertUiThread() {
        CndUtils.assertTrue(SwingUtilities.isEventDispatchThread(), "Should be called only from UI thread");
    }

    public static void assertNormalized(File file) {
        File normFile;
        if (CndUtils.isDebugMode() && !file.equals(normFile = CndFileUtils.normalizeFile(file))) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + file + " instead of " + normFile);
        }
    }

    public static void assertNormalized(FileSystem fs, CharSequence absPath) {
        String normFile;
        if (CndUtils.isDebugMode() && !(normFile = CndFileUtils.normalizeAbsolutePath(fs, ((Object)absPath).toString())).contentEquals(absPath)) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + absPath + " instead of " + normFile);
        }
    }

    public static Logger getLogger() {
        return LOG;
    }

    static {
        String text = System.getProperty("cnd.release.mode");
        if (text == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(text);
        }
    }
}

