/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.filters.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.utils.filters.PeDynamicLibraryFileFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AllLibraryFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    private static AllLibraryFileFilter instance = null;
    private List<FileFilterFactory.FileAndFileObjectFilter> filters = new ArrayList<FileFilterFactory.FileAndFileObjectFilter>();
    private ResourceBundle bundle;

    public static AllLibraryFileFilter getInstance() {
        if (instance == null) {
            instance = new AllLibraryFileFilter();
        }
        return instance;
    }

    private AllLibraryFileFilter() {
        this.filters.add(ElfStaticLibraryFileFilter.getInstance());
        if (Utilities.isWindows()) {
            this.filters.add(PeDynamicLibraryFileFilter.getInstance());
        } else if (Utilities.getOperatingSystem() == 4096) {
            this.filters.add(MacOSXDynamicLibraryFileFilter.getInstance());
        } else {
            this.filters.add(ElfDynamicLibraryFileFilter.getInstance());
        }
    }

    @Override
    public String getDescription() {
        return this.getString("ALL_LIB_FILTER");
    }

    @Override
    public boolean accept(File f) {
        for (FileFilterFactory.FileAndFileObjectFilter filter : this.filters) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(FileObject fileObject) {
        for (FileFilterFactory.FileAndFileObjectFilter filter : this.filters) {
            if (!filter.accept(fileObject)) continue;
            return true;
        }
        return false;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ElfDynamicLibraryFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

