/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ElfExecutableFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    private static ElfExecutableFileFilter instance = null;
    private ResourceBundle bundle;

    public static ElfExecutableFileFilter getInstance() {
        if (instance == null) {
            instance = new ElfExecutableFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return this.getString("FILECHOOSER_ELFEXECUTABLE_FILEFILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return this.checkElfHeader(f);
        }
        return false;
    }

    @Override
    public boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            return this.checkElfHeader(f);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkElfHeader(Object f) {
        short e_type;
        CndUtils.assertTrue(f instanceof File || f instanceof FileObject);
        byte[] b = new byte[18];
        int offset = 0;
        InputStream is = null;
        try {
            int n;
            is = f instanceof File ? new FileInputStream((File)f) : ((FileObject)f).getInputStream();
            for (int left = 18; left > 0; left -= n) {
                n = is.read(b, offset, left);
                if (n <= 0) {
                    boolean bl = false;
                    return bl;
                }
                offset += n;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (b[5] == 1) {
            e_type = b[17];
            e_type = (short)(e_type << 8);
            e_type = (short)(e_type + (short)b[16]);
        } else {
            e_type = b[16];
            e_type = (short)(e_type << 8);
            e_type = (short)(e_type + (short)b[17]);
        }
        return b[0] == 127 && b[1] == 69 && b[2] == 76 && b[3] == 70 && e_type == 2;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ElfExecutableFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

