/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PeExecutableFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    private static PeExecutableFileFilter instance = null;
    private ResourceBundle bundle;

    public static PeExecutableFileFilter getInstance() {
        if (instance == null) {
            instance = new PeExecutableFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return this.getString("PE_EXECUTABLE_FILTER");
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".exe");
        }
        return false;
    }

    @Override
    public boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            return f.getExt().equals("exe");
        }
        return false;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(PeExecutableFileFilter.class);
        }
        return this.bundle.getString(s);
    }
}

