/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider2;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public final class JavaSourceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        Project project = (Project)p.getLookup().lookup(Project.class);
        assert (project != null);
        return new SourcesNodeList(project);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String nodeName) {
            this(project, nodeName, null);
        }

        public PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(JavaSourceNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerProvider2 cp2 = (CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class);
            if (cp2 != null) {
                cp2.showCustomizer(this.nodeName, this.panelName);
            } else {
                CustomizerProvider cp = (CustomizerProvider)this.project.getLookup().lookup(CustomizerProvider.class);
                if (cp != null) {
                    cp.showCustomizer();
                }
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private final String nodeName;
        private final Project project;
        private final boolean trueSource;

        public PackageViewFilterNode(SourceGroupKey sourceGroupKey, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroupKey.group));
            this.project = project;
            this.nodeName = "Sources";
            this.trueSource = sourceGroupKey.trueSource;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(super.getActions(context)));
            if (this.trueSource) {
                actions.add(null);
                actions.add(new PreselectPropertiesAction(this.project, this.nodeName));
            } else {
                Iterator scan = actions.iterator();
                while (scan.hasNext()) {
                    Action a = (Action)scan.next();
                    if (a == null || !a.getClass().getName().equals("org.netbeans.modules.project.ui.actions.NewFile$WithSubMenu")) continue;
                    scan.remove();
                }
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public String getHtmlDisplayName() {
            if (this.trueSource) {
                return super.getHtmlDisplayName();
            }
            String htmlName = this.getOriginal().getHtmlDisplayName();
            if (htmlName == null) {
                try {
                    htmlName = XMLUtil.toElementContent((String)super.getDisplayName());
                }
                catch (CharConversionException x) {
                    return null;
                }
            }
            return "<font color='!controlShadow'>" + htmlName + "</font>";
        }
    }

    private static class GeneratedSourceGroup
    implements SourceGroup {
        private final FileObject child;

        GeneratedSourceGroup(FileObject child) {
            this.child = child;
        }

        public FileObject getRootFolder() {
            return this.child;
        }

        public String getName() {
            return this.child.getNameExt();
        }

        public String getDisplayName() {
            try {
                return NbBundle.getBundle((String)("org.netbeans.modules.java.api.common.project.ui.gensrc-" + this.getName())).getString("label");
            }
            catch (MissingResourceException x) {
                return NbBundle.getMessage(JavaSourceNodeFactory.class, (String)"JavaSourceNodeFactory.gensrc", (Object)this.getName());
            }
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) throws IllegalArgumentException {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;
        public final boolean trueSource;

        SourceGroupKey(SourceGroup group, boolean trueSource) {
            this.group = group;
            this.fileObject = group.getRootFolder();
            this.trueSource = trueSource;
        }

        public int hashCode() {
            int hash = 5;
            String disp = this.group.getDisplayName();
            hash = 79 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
            hash = 79 * hash + (disp != null ? disp.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            boolean twoNull;
            if (!(obj instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey otherKey = (SourceGroupKey)obj;
            if (!(this.fileObject == otherKey.fileObject || this.fileObject != null && this.fileObject.equals(otherKey.fileObject))) {
                return false;
            }
            String thisDisplayName = this.group.getDisplayName();
            String otherDisplayName = otherKey.group.getDisplayName();
            boolean oneNull = thisDisplayName == null;
            boolean bl = twoNull = otherDisplayName == null;
            return oneNull == twoNull && thisDisplayName.equals(otherDisplayName);
        }
    }

    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private final Project project;
        private final File genSrcDir;
        private final FileChangeListener genSrcDirListener;
        private final FileChangeListener genContentListener;
        private final List<File> listensOn = Collections.synchronizedList(new LinkedList());
        private final Runnable changeTask;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(Project proj) {
            this.project = proj;
            this.changeTask = new Runnable(){

                @Override
                public void run() {
                    SourcesNodeList.this.stateChanged(null);
                }
            };
            this.genSrcDirListener = new FileChangeAdapter(){

                public void fileFolderCreated(FileEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }

                public void fileDeleted(FileEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }

                public void fileRenamed(FileRenameEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }
            };
            this.genContentListener = new FileChangeAdapter(){

                public void fileFolderCreated(FileEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }

                public void fileDataCreated(FileEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }

                public void fileDeleted(FileEvent fe) {
                    fe.runWhenDeliveryOver(SourcesNodeList.this.changeTask);
                }
            };
            File d = FileUtil.toFile((FileObject)proj.getProjectDirectory());
            this.genSrcDir = d != null ? new File(d, "build/generated-sources") : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SourceGroupKey> keys() {
            File[] removeFrom;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            ArrayList<SourceGroupKey> result = new ArrayList<SourceGroupKey>();
            for (SourceGroup group : this.getSources().getSourceGroups("java")) {
                result.add(new SourceGroupKey(group, true));
            }
            List<File> len$ = this.listensOn;
            synchronized (len$) {
                removeFrom = this.listensOn.toArray(new File[this.listensOn.size()]);
                this.listensOn.clear();
            }
            for (File file : removeFrom) {
                FileUtil.removeFileChangeListener((FileChangeListener)this.genContentListener, (File)file);
            }
            FileObject genSrc = FileUtil.toFileObject((File)this.genSrcDir);
            if (genSrc != null) {
                VisibilityQuery vq = VisibilityQuery.getDefault();
                for (FileObject child : genSrc.getChildren()) {
                    File childFile;
                    if (!child.isFolder() || !vq.isVisible(child) || (childFile = FileUtil.toFile((FileObject)child)) == null) continue;
                    FileUtil.addFileChangeListener((FileChangeListener)this.genContentListener, (File)childFile);
                    this.listensOn.add(childFile);
                    if (child.getChildren().length <= 0) continue;
                    result.add(new SourceGroupKey(new GeneratedSourceGroup(child), false));
                }
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
            FileUtil.addFileChangeListener((FileChangeListener)this.genSrcDirListener, (File)this.genSrcDir);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
            FileUtil.removeFileChangeListener((FileChangeListener)this.genSrcDirListener, (File)this.genSrcDir);
        }

        public Node node(SourceGroupKey key) {
            return new PackageViewFilterNode(key, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

