/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.PrecheckException;
import com.sun.javacard.converter.util.Notifier;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class JPackage
extends PackageDefinition {
    private JClassFile[] java_classes;

    public JClassFile[] getClasses() {
        return this.java_classes;
    }

    public void setClasses(JClassFile[] jClassFileArray) {
        this.java_classes = jClassFileArray;
    }

    public JPackage(String string) {
        this.package_name = string;
    }

    public void parse(File[] fileArray) {
        this.java_classes = new JClassFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            JClassFile jClassFile = new JClassFile();
            DataInputStream dataInputStream = null;
            try {
                Notifier.progress("progress.1", fileArray[i].getCanonicalPath());
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileArray[i])));
                jClassFile.parse(dataInputStream);
                this.java_classes[i] = jClassFile;
                continue;
            }
            catch (IOException iOException) {
                Notifier.error("converter.1", fileArray[i].getName());
            }
        }
    }

    public void resolve() throws PrecheckException {
        for (JClassFile jClassFile : this.java_classes) {
            jClassFile.resolve();
        }
    }

    public JClassFile getClass(String string) {
        for (JClassFile jClassFile : this.java_classes) {
            if (!jClassFile.getClassName().equals(string)) continue;
            return jClassFile;
        }
        return null;
    }

    public JMethod getMethod(String string, String string2, String string3) {
        JMethod[] jMethodArray;
        JClassFile jClassFile = this.getClass(string);
        if (jClassFile == null) {
            return null;
        }
        for (JMethod jMethod : jMethodArray = jClassFile.getMethods()) {
            if (!jMethod.getMethodName().equals(string2) || !jMethod.getMethodDescriptor().equals(string3)) continue;
            return jMethod;
        }
        return null;
    }

    public JField getField(String string, String string2, String string3) {
        JField[] jFieldArray;
        JClassFile jClassFile = this.getClass(string);
        if (jClassFile == null) {
            return null;
        }
        for (JField jField : jFieldArray = jClassFile.getFields()) {
            if (!jField.getFieldName().equals(string2) || !jField.getFieldDescriptor().equals(string3)) continue;
            return jField;
        }
        return null;
    }
}

