/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

public class FieldInstrOptimizer {
    JcPackage jc_package;

    public FieldInstrOptimizer(JcPackage jcPackage) {
        this.jc_package = jcPackage;
    }

    public JcPackage optimize() {
        JcClass[] jcClassArray;
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            JcMethod[] jcMethodArray;
            for (JcMethod jcMethod : jcMethodArray = jcClass.getMethods()) {
                int n = jcMethod.getAccessFlags();
                if (Modifier.isStatic(n)) continue;
                JcInstruction jcInstruction = jcMethod.getCode();
                JcInstruction jcInstruction2 = this.optimizeCode(jcInstruction);
                jcMethod.setCode(jcInstruction2);
            }
        }
        return this.jc_package;
    }

    private JcInstruction optimizeCode(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return null;
        }
        JcInstruction jcInstruction2 = jcInstruction;
        if (this.canOptimize(jcInstruction2)) {
            jcInstruction = this.createOptimizedInstrs(jcInstruction2);
            jcInstruction2 = jcInstruction2.getNextInstr().getNextInstr();
            jcInstruction.setNextInstr(jcInstruction2);
            if (jcInstruction2 != null) {
                jcInstruction2.setPrevInstr(jcInstruction);
            }
        } else {
            jcInstruction2 = jcInstruction2.getNextInstr();
        }
        while (jcInstruction2 != null) {
            if (this.canOptimize(jcInstruction2)) {
                JcInstruction jcInstruction3 = this.createOptimizedInstrs(jcInstruction2);
                JcInstruction jcInstruction4 = jcInstruction2.getPrevInstr();
                jcInstruction4.setNextInstr(jcInstruction3);
                jcInstruction3.setPrevInstr(jcInstruction4);
                jcInstruction2 = jcInstruction2.getNextInstr().getNextInstr();
                jcInstruction3.setNextInstr(jcInstruction2);
                if (jcInstruction2 == null) continue;
                jcInstruction2.setPrevInstr(jcInstruction3);
                continue;
            }
            jcInstruction2 = jcInstruction2.getNextInstr();
        }
        return jcInstruction;
    }

    private boolean canOptimize(JcInstruction jcInstruction) {
        int n = jcInstruction.getOpcode();
        if (n == 24) {
            JcInstruction jcInstruction2 = jcInstruction.getNextInstr();
            if (jcInstruction2 == null) {
                return false;
            }
            if (jcInstruction2.getLabel() != -1) {
                return false;
            }
            int n2 = jcInstruction2.getOpcode();
            return n2 >= 131 && n2 <= 134;
        }
        return false;
    }

    private JcInstruction createOptimizedInstrs(JcInstruction jcInstruction) {
        JcInstruction jcInstruction2 = jcInstruction.getNextInstr();
        int n = 0;
        switch (jcInstruction2.getOpcode()) {
            case 131: {
                n = 173;
                break;
            }
            case 132: {
                n = 174;
                break;
            }
            case 133: {
                n = 175;
                break;
            }
            case 134: {
                n = 176;
            }
        }
        JcConstantFieldRef jcConstantFieldRef = ((JcInstrFieldRef)jcInstruction2).getFieldRef();
        JcInstrFieldRef jcInstrFieldRef = new JcInstrFieldRef(n, jcConstantFieldRef);
        if (jcInstruction.getLabel() != -1) {
            jcInstrFieldRef.setLabel(jcInstruction.getLabel());
        }
        if (jcInstruction2.getLabel() != -1) {
            jcInstrFieldRef.setLabel(jcInstruction2.getLabel());
        }
        jcInstrFieldRef.setSourceLineNumber(jcInstruction.getSourceLineNumber());
        return jcInstrFieldRef;
    }
}

