/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HeaderComponent
extends Component {
    public static final int MAGIC = -557121555;
    public static final int MAJOR = 2;
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    protected int major;
    protected int minor;
    protected int flags;
    protected Aid aid;

    HeaderComponent(JCPackage jCPackage, Aid aid, int n, int n2, int n3) {
        super(jCPackage);
        if (aid == null || n < 0 || n > 255 || n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException();
        }
        this.tag = 1;
        this.aid = aid;
        this.major = n;
        this.minor = n2;
        this.flags = n3;
    }

    @Override
    public int dataSize() {
        if (this.getParentPackage().is22Package()) {
            return 10 + this.aid.getSize() + 1 + this.getParentPackage().getName().getBytes().length;
        }
        return 10 + this.aid.getSize();
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeInt(-557121555);
            dataOutputStream.writeByte(this.getParentPackage().is22Package() ? 2 : 1);
            dataOutputStream.writeByte(2);
            dataOutputStream.writeByte(this.flags);
            dataOutputStream.writeByte(this.minor);
            dataOutputStream.writeByte(this.major);
            dataOutputStream.writeByte(this.aid.getSize());
            dataOutputStream.write(this.aid.toByteArray());
            if (this.getParentPackage().is22Package()) {
                byte[] byArray2 = this.getParentPackage().getName().getBytes();
                dataOutputStream.writeByte(byArray2.length);
                if (byArray2.length > 0) {
                    dataOutputStream.write(byArray2);
                }
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Magic: " + Msg.toHexString(-557121555) + Msg.eol);
        stringBuffer.append("Minor: " + Msg.toHexString((byte)(this.getParentPackage().is22Package() ? 2 : 1)) + Msg.eol);
        stringBuffer.append("Major: " + Msg.toHexString((byte)2) + Msg.eol);
        stringBuffer.append("Flags: " + Msg.toHexString((byte)this.flags) + Msg.eol);
        stringBuffer.append("Package Minor: " + Msg.toHexString((byte)this.minor) + Msg.eol);
        stringBuffer.append("Package Major: " + Msg.toHexString((byte)this.major) + Msg.eol);
        stringBuffer.append("Package AID Length: " + this.aid.getSize() + Msg.eol);
        stringBuffer.append("Package AID: " + this.aid.toString() + Msg.eol);
        return stringBuffer.toString();
    }
}

