/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class MethodComponent
extends Component {
    public static final int ACC_EXTENDED = 8;
    public static final int ACC_ABSTRACT = 4;
    protected Vector<JCMethod> methodVector = new Vector();
    protected Vector<ExceptionTable> exceptionVector = new Vector();
    protected int handlerCount;

    public MethodComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    @Override
    public int dataSize() {
        int n = 1;
        for (ExceptionTable object : this.exceptionVector) {
            n += object.size();
        }
        for (JCMethod jCMethod : this.methodVector) {
            n += jCMethod.size();
        }
        return n;
    }

    public void add(JCClass jCClass) {
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration<JCMethod> enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            JCMethod jCMethod = enumeration.nextElement();
            this.methodVector.addElement(jCMethod);
            ExceptionTable exceptionTable = jCMethod.getExceptionTable();
            if (exceptionTable == null) continue;
            this.exceptionVector.addElement(exceptionTable);
            this.handlerCount += exceptionTable.count();
            if (this.handlerCount <= 255) continue;
            Msg.error(Msg.getMessage("package.5"));
            return;
        }
    }

    void assignAddresses() {
        int n = 1;
        for (ExceptionTable object : this.exceptionVector) {
            object.relocate(n);
            n += object.size();
        }
        for (JCMethod jCMethod : this.methodVector) {
            jCMethod.relocate(n);
            n += jCMethod.size();
        }
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            byte[] byArray2 = super.toByteArray();
            dataOutputStream.write(byArray2, 0, byArray2.length);
            dataOutputStream.writeByte(this.handlerCount);
            for (ExceptionTable object : this.exceptionVector) {
                byArray = object.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            for (JCMethod jCMethod : this.methodVector) {
                byArray = jCMethod.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Handler count: " + this.handlerCount + Msg.eol);
        for (ExceptionTable object : this.exceptionVector) {
            stringBuffer.append(object.toString() + Msg.eol);
        }
        for (JCMethod jCMethod : this.methodVector) {
            stringBuffer.append(jCMethod.toString());
        }
        return stringBuffer.toString();
    }

    protected void getDebugOffsets(Map<String, Integer> map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            dataOutputStream.writeByte(this.handlerCount);
            for (ExceptionTable object : this.exceptionVector) {
                byArray = object.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            for (JCMethod jCMethod : this.methodVector) {
                byArray = jCMethod.toByteArray();
                map.put(jCMethod.getName(), new Integer(dataOutputStream.size()));
                dataOutputStream.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

