/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cref211OutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble = new StringBuffer();
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    protected Vector<String> suppressionVector;
    private int relocPc;
    private int relocFieldPc;
    private int m_romBase = 0;
    private int m_e2Base = 32768;
    private static final int ARRAY_HEADER_SIZE = 6;

    public Cref211OutputFormatter(BufferedReader bufferedReader) throws IOException {
        super(bufferedReader);
        String string;
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.applets = new StringBuffer();
        this.packages = new StringBuffer();
        this.defineList = new StringBuffer();
        this.exceptionTable = new StringBuffer();
        this.exportComponent = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        try {
            string = this.getMapEntry("ROMBASE");
            if (string != null) {
                this.m_romBase = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        try {
            string = this.getMapEntry("E2BASE");
            if (string != null) {
                this.m_e2Base = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.1", null);
        }
        string = this.getMapEntry("NOEXPORTCOMPONENT");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.suppressionVector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        this.relocPc = this.m_romBase;
        this.relocFieldPc = this.m_e2Base;
    }

    @Override
    public void format(RomMask romMask) {
        this.pass1(romMask);
        if (Globals.errors == 0) {
            this.pass2(romMask);
        }
    }

    protected void pass1(RomMask romMask) {
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = enumeration.nextElement();
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Member member;
                JCClass jCClass = enumeration2.nextElement();
                jCClass.relocate(this.relocPc);
                this.relocPc += jCClass.size();
                if (Modifier.isInterface(jCClass.getAttributes())) continue;
                Enumeration<Member> enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    Object[] objectArray;
                    member = enumeration3.nextElement();
                    if (!Modifier.isStatic(member.getAttributes())) continue;
                    FieldDescriptor fieldDescriptor = ((Field)member).getDescriptor();
                    if (Modifier.isFinal(member.getAttributes()) && fieldDescriptor.isPrimitive()) continue;
                    member.relocate(this.relocFieldPc);
                    this.relocFieldPc += ((Field)member).size();
                    StaticFieldInitializer staticFieldInitializer = ((Field)member).getFieldInitializer();
                    if (staticFieldInitializer == null || staticFieldInitializer.isPrimitive()) continue;
                    if (jCPackage.appletCount() == 0) {
                        objectArray = new Object[]{member.getName(), jCPackage.getName()};
                        Msg.error("mlink.17", objectArray);
                        continue;
                    }
                    objectArray = fieldDescriptor.getDescriptorString();
                    int[] nArray = staticFieldInitializer.getArrayData();
                    if (objectArray.equals("[B") || objectArray.equals("[Z")) {
                        this.relocFieldPc += 6 + nArray.length;
                        continue;
                    }
                    if (objectArray.equals("[S")) {
                        this.relocFieldPc += 6 + nArray.length * 2;
                        continue;
                    }
                    if (objectArray.equals("[I")) {
                        this.relocFieldPc += 6 + nArray.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
                enumeration3 = jCClass.methodElements();
                while (enumeration3.hasMoreElements()) {
                    member = (JCMethod)enumeration3.nextElement();
                    member.relocate(this.relocPc);
                    this.relocPc += ((JCMethod)member).size();
                    if (!Modifier.isNative(member.getAttributes())) continue;
                    this.relocPc += 2;
                }
            }
        }
    }

    protected void pass2(RomMask romMask) {
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            int n;
            Object object;
            Object object2;
            JCPackage jCPackage = enumeration.nextElement();
            boolean bl = this.suppressionVector.contains(jCPackage.getName());
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            PackageIdentifier packageIdentifier = jCPackage.getIdentifier();
            this.packageDirectory.addPackage(packageIdentifier);
            byte[] byArray = packageIdentifier.getAid().toByteArray();
            this.packages.append("{ { " + byArray.length + ", { ");
            this.packages.append(Msg.toHexString(byArray, ", ") + ", ");
            this.packages.append("} }, " + packageIdentifier.getMajorVersion() + ", " + packageIdentifier.getMinorVersion() + ", " + this.exportComponentLength + " }," + Msg.eol);
            Object object3 = jCPackage.appletElements();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = ((AppletDeclarator)object2).getAid().toByteArray();
                n = ((AppletDeclarator)object2).resolve().getRelocAddr();
                this.applets.append("{ " + this.packageDirectory.indexOf(packageIdentifier) + ", { " + ((byte[])object).length + ", { ");
                this.applets.append(Msg.toHexString(object, ", ") + ", ");
                this.applets.append(" } }, " + Msg.toHexString((short)n) + " }," + Msg.eol);
            }
            object3 = jCPackage.classElements();
            while (object3.hasMoreElements()) {
                Object object5;
                object2 = (JCClass)object3.nextElement();
                if (!bl) {
                    exportComponent.add((JCClass)object2);
                }
                this.rom.append(Msg.eol + "/* class@" + Msg.toHexString((short)((Member)object2).getRelocAddr()) + ": " + Modifier.toString(((Member)object2).getAttributes()) + " " + ((Member)object2).getName() + " */" + Msg.eol);
                object = this.getMapEntry(((Member)object2).getName());
                if (object != null) {
                    this.defineList.append("#define " + (String)object + " " + ((Member)object2).getRelocAddr() + "\t/* " + ((Member)object2).getName() + " */" + Msg.eol);
                }
                int n2 = n = ((JCClass)object2).isShareable() ? 64 : 0;
                if (Modifier.isInterface(((Member)object2).getAttributes())) {
                    int n3 = ((JCClass)object2).superInterfaceVector.size();
                    this.rom.append(Msg.toHexString((byte)((n |= 0x80) | n3 & 0xF)) + ", ");
                    object5 = ((JCClass)object2).superInterfaceVector.iterator();
                    while (object5.hasNext()) {
                        SuperInterface superInterface = object5.next();
                        int n4 = superInterface.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + Msg.toHexString((short)n4) + "), ");
                        this.rom.append("LOW(" + Msg.toHexString((short)n4) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append(Msg.toHexString((byte)(n | ((JCClass)object2).interfaceVector.size() & 0xF)) + ", ");
                Enumeration<JCMethod> enumeration2 = ((JCClass)object2).getSuperClass();
                if (enumeration2 == null) {
                    this.rom.append(Msg.toHexString((byte)-1) + ", ");
                    this.rom.append(Msg.toHexString((byte)-1) + ", ");
                } else {
                    this.rom.append("HIGH(" + Msg.toHexString((short)((Member)((Object)enumeration2)).getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)((Member)((Object)enumeration2)).getRelocAddr()) + "), ");
                }
                int n5 = 0;
                for (object5 = object2; object5 != null; object5 = ((JCClass)object5).getSuperClass()) {
                    n5 += ((JCClass)object5).getInstanceSize();
                }
                this.rom.append(Msg.toHexString((byte)n5) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).getFirstReferenceToken()) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).getReferenceCount()) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).publicMethodTable.getBase()) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).publicMethodTable.getCount()) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).packageMethodTable.getBase()) + ", ");
                this.rom.append(Msg.toHexString((byte)((JCClass)object2).packageMethodTable.getCount()) + ", ");
                this.rom.append(Msg.eol);
                Enumeration<ExceptionTableEntry> enumeration3 = ((JCClass)object2).publicMethodTable.elements();
                while (enumeration3.hasMoreElements()) {
                    JCMethod jCMethod = enumeration3.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)jCMethod.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)jCMethod.getRelocAddr()) + "),\t\t/* " + jCMethod.getName() + " */" + Msg.eol);
                }
                enumeration3 = ((JCClass)object2).packageMethodTable.elements();
                while (enumeration3.hasMoreElements()) {
                    JCMethod jCMethod = enumeration3.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)jCMethod.getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)jCMethod.getRelocAddr()) + "),\t\t/* " + jCMethod.getName() + " */" + Msg.eol);
                }
                for (InterfaceTable interfaceTable : ((JCClass)object2).interfaceVector) {
                    byte[] byArray2 = interfaceTable.toByteArray();
                    int n3 = interfaceTable.resolve().getRelocAddr();
                    this.rom.append("HIGH(" + Msg.toHexString((short)n3) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)n3) + "), ");
                    for (int i = 2; i < byArray2.length; ++i) {
                        this.rom.append(byArray2[i] + ", ");
                    }
                    this.rom.append(Msg.eol);
                }
                enumeration2 = ((JCClass)object2).fieldElements();
                while (enumeration2.hasMoreElements()) {
                    int n4;
                    object5 = (Field)enumeration2.nextElement();
                    n5 = ((Member)object5).getAttributes();
                    if (Modifier.isStatic(n5) && !Modifier.isFinal(n5) && (object = (Object)this.getMapEntry(((Member)object5).getName())) != null) {
                        this.defineList.append("#define " + (String)object + " " + ((Member)object5).getRelocAddr() + "\t/* " + ((Member)object5).getName() + " */" + Msg.eol);
                    }
                    if (!Modifier.isStatic(n5)) continue;
                    enumeration3 = ((Field)object5).getDescriptor();
                    if (Modifier.isFinal(((Member)object5).getAttributes()) && ((FieldDescriptor)((Object)enumeration3)).isPrimitive()) continue;
                    StaticFieldInitializer staticFieldInitializer = ((Field)object5).getFieldInitializer();
                    if (staticFieldInitializer != null && staticFieldInitializer.isPrimitive()) {
                        n4 = staticFieldInitializer.getPrimitiveData();
                        switch (((Field)object5).size()) {
                            case 1: {
                                this.staticInit.append(Msg.toHexString((byte)n4) + ",");
                                break;
                            }
                            case 2: {
                                this.staticInit.append(Msg.toHexString((byte)(n4 >> 8)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)n4) + ",");
                                break;
                            }
                            case 4: {
                                this.staticInit.append(Msg.toHexString((byte)(n4 >> 24)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)(n4 >> 16)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)(n4 >> 8)) + ", ");
                                this.staticInit.append(Msg.toHexString((byte)n4) + ",");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                        this.staticInit.append("\t/* " + ((Member)object5).getName() + " @ " + Msg.toHexString((short)((Member)object5).getRelocAddr()) + " */" + Msg.eol);
                        continue;
                    }
                    if (staticFieldInitializer != null && !staticFieldInitializer.isPrimitive()) {
                        int n6;
                        byte[] byArray3;
                        n4 = ((Member)object5).getRelocAddr() + 2;
                        this.staticInit.append(Msg.toHexString((byte)(n4 >> 8)) + ", ");
                        this.staticInit.append(Msg.toHexString((byte)n4) + ",");
                        this.staticInit.append("\t/* " + ((Member)object5).getName() + " @ " + Msg.toHexString((short)((Member)object5).getRelocAddr()) + " */" + Msg.eol);
                        String string = ((FieldDescriptor)((Object)enumeration3)).getDescriptorString();
                        int[] nArray = staticFieldInitializer.getArrayData();
                        if (string.equals("[B")) {
                            byArray3 = new byte[nArray.length + 6];
                            byArray3[0] = -128;
                            n4 = ((JCClass)romMask.classSymbolTable.get("[B")).getRelocAddr();
                            for (n6 = 0; n6 < nArray.length; ++n6) {
                                byArray3[6 + n6] = (byte)nArray[n6];
                            }
                        } else if (string.equals("[Z")) {
                            byArray3 = new byte[nArray.length + 6];
                            byArray3[0] = 96;
                            n4 = ((JCClass)romMask.classSymbolTable.get("[Z")).getRelocAddr();
                            for (n6 = 0; n6 < nArray.length; ++n6) {
                                byArray3[6 + n6] = (byte)nArray[n6];
                            }
                        } else if (string.equals("[S")) {
                            byArray3 = new byte[nArray.length * 2 + 6];
                            byArray3[0] = -96;
                            n4 = ((JCClass)romMask.classSymbolTable.get("[S")).getRelocAddr();
                            for (n6 = 0; n6 < nArray.length; ++n6) {
                                byArray3[6 + n6 * 2] = (byte)(nArray[n6] >> 8);
                                byArray3[6 + n6 * 2 + 1] = (byte)nArray[n6];
                            }
                        } else if (string.equals("[I")) {
                            byArray3 = new byte[nArray.length * 4 + 6];
                            byArray3[0] = -64;
                            n4 = ((JCClass)romMask.classSymbolTable.get("[I")).getRelocAddr();
                            for (n6 = 0; n6 < nArray.length; ++n6) {
                                byArray3[6 + n6 * 4] = (byte)(nArray[n6] >> 24);
                                byArray3[6 + n6 * 4 + 1] = (byte)(nArray[n6] >> 16);
                                byArray3[6 + n6 * 4 + 2] = (byte)(nArray[n6] >> 8);
                                byArray3[6 + n6 * 4 + 3] = (byte)nArray[n6];
                            }
                        } else {
                            throw new InternalError();
                        }
                        byArray3[1] = (byte)(this.packageDirectory.indexOf(packageIdentifier) << 4);
                        byArray3[2] = (byte)(n4 >> 8);
                        byArray3[3] = (byte)n4;
                        byArray3[4] = (byte)(nArray.length >> 8);
                        byArray3[5] = (byte)nArray.length;
                        this.staticInit.append(Msg.toHexString(byArray3, ", ") + "," + Msg.eol);
                        continue;
                    }
                    switch (((Field)object5).size()) {
                        case 1: {
                            this.staticInit.append("0,");
                            break;
                        }
                        case 2: {
                            this.staticInit.append("0, 0,");
                            break;
                        }
                        case 4: {
                            this.staticInit.append("0, 0, 0, 0,");
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + ((Member)object5).getName() + " @ " + Msg.toHexString((short)((Member)object5).getRelocAddr()) + " */" + Msg.eol);
                }
                enumeration2 = ((JCClass)object2).methodElements();
                while (enumeration2.hasMoreElements()) {
                    object5 = enumeration2.nextElement();
                    object = this.getMapEntry(((Member)object5).getName());
                    if (object != null) {
                        this.defineList.append("#define " + (String)object + " " + ((Member)object5).getRelocAddr() + "\t/* " + ((Member)object5).getName() + " */" + Msg.eol);
                    }
                    this.rom.append(Msg.eol + "/* method@" + Msg.toHexString((short)((Member)object5).getRelocAddr()) + ": " + Modifier.toString(((Member)object5).getAttributes()) + " " + ((Member)object5).getName() + " */" + Msg.eol);
                    this.rom.append(Msg.toHexString(((JCMethod)object5).getMethodHeader(), ", ") + ", " + Msg.eol);
                    if (Modifier.isAbstract(((Member)object5).getAttributes())) continue;
                    if (Modifier.isNative(((Member)object5).getAttributes())) {
                        int n9 = ((Member)object5).getRelocAddr();
                        this.rom.append(Msg.toHexString((byte)(n9 >> 8)) + ", " + Msg.toHexString((byte)n9) + ", " + Msg.eol);
                        continue;
                    }
                    Object object6 = ((JCMethod)object5).statementElements();
                    while (object6.hasMoreElements()) {
                        enumeration3 = object6.nextElement();
                        this.format((Statement)((Object)enumeration3));
                        this.rom.append(", " + Msg.eol);
                    }
                    object6 = ((JCMethod)object5).getExceptionTable();
                    if (object6 == null) continue;
                    enumeration3 = ((ExceptionTable)object6).elements();
                    while (enumeration3.hasMoreElements()) {
                        ExceptionTableEntry exceptionTableEntry = enumeration3.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(Msg.toHexString((short)exceptionTableEntry.getStartOffset()) + ", ");
                        int n7 = exceptionTableEntry.getActiveLength();
                        if (exceptionTableEntry.isOuterMost()) {
                            n7 |= 0x8000;
                        }
                        this.exceptionTable.append(Msg.toHexString((short)n7) + ", ");
                        this.exceptionTable.append(Msg.toHexString((short)exceptionTableEntry.getHandlerOffset()) + ", ");
                        this.exceptionTable.append(Msg.toHexString((short)exceptionTableEntry.getCatchIndex()) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            object3 = exportComponent.toByteArray();
            this.exportComponent.append("/* " + jCPackage.getName() + " */" + Msg.eol);
            for (int i = 0; i < ((Object)object3).length; ++i) {
                this.exportComponent.append(Msg.toHexString((byte)object3[i]) + ", ");
                if (i % 8 != 7) continue;
                this.exportComponent.append(Msg.eol);
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += ((Object)object3).length;
        }
    }

    protected void format(Statement statement) {
        if (statement.getInstruction() == null) {
            return;
        }
        this.format(statement.getInstruction());
    }

    protected void format(Instruction instruction) {
        this.rom.append("_" + instruction.getMnemonic().toUpperCase());
        Enumeration<Operand> enumeration = instruction.operandElements();
        while (enumeration.hasMoreElements()) {
            Operand operand = enumeration.nextElement();
            this.format(operand);
        }
    }

    protected void format(Operand operand) {
        if (operand.getType() == 8) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    break;
                }
                case 5: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    break;
                }
                case 3: {
                    JCMethod jCMethod = (JCMethod)info.resolve();
                    MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
                    int n = methodIdentifier.getMethodToken();
                    int n2 = jCMethod.getParams();
                    this.rom.append(", " + Msg.toHexString((byte)n2) + ", " + Msg.toHexString((byte)n));
                    break;
                }
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n3 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)n3 >> 8) + ", " + Msg.toHexString((byte)n3));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.getType() == 7) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n4 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)n4));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (operand.size() == 1) {
            this.rom.append(", " + operand.getValue());
        } else if (operand.size() == 2) {
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        } else if (operand.size() == 4) {
            this.rom.append(", " + (operand.getValue() >> 24 & 0xFF) + ", " + (operand.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        }
    }

    @Override
    public void write(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("#ifdef __MASK_HEADER__" + Msg.eol);
        printWriter.println(this.defineList.toString());
        printWriter.println("#else" + Msg.eol);
        printWriter.println(this.preamble.toString());
        printWriter.println("const unsigned char rommask[] = {");
        printWriter.println(this.rom.toString() + "};");
        printWriter.println("const unsigned short romsize = sizeof rommask;" + Msg.eol);
        if (this.nExceptionEntries == 0) {
            printWriter.println("const struct exception exceptiontable[] = { NULL };");
        } else {
            printWriter.println("const struct exception exceptiontable[] = {");
            printWriter.println(this.exceptionTable.toString() + "};");
        }
        printWriter.println("const unsigned short exceptiontablesize = sizeof exceptiontable / sizeof (struct exception);" + Msg.eol);
        printWriter.println("const unsigned short staticfieldsize = " + (this.relocFieldPc - this.m_e2Base) + ";" + Msg.eol);
        printWriter.println("const unsigned char staticinit[] = {");
        if (this.staticInit.length() == 0) {
            printWriter.println(" NULL ");
        } else {
            printWriter.print(this.staticInit.toString());
        }
        printWriter.println("};");
        printWriter.println("const struct applet applets[] = {");
        if (this.applets.length() == 0) {
            printWriter.println(" NULL ");
        } else {
            printWriter.print(this.applets.toString());
        }
        printWriter.println("};" + Msg.eol + "const unsigned short napplets = (sizeof applets / sizeof (struct applet));" + Msg.eol);
        printWriter.println("#ifdef POST_ISSUANCE_INSTALL");
        printWriter.println("const struct package packages[] = {");
        printWriter.print(this.packages.toString());
        printWriter.println("};" + Msg.eol + "const unsigned short npackages = (sizeof packages / sizeof (struct package));" + Msg.eol);
        printWriter.println("const unsigned char exportComponent[] = {");
        printWriter.print(this.exportComponent.toString());
        printWriter.println("};");
        printWriter.println("const unsigned short exportComponentSize = sizeof exportComponent;" + Msg.eol);
        printWriter.println("#endif /* __POST_ISSUANCE_INSTALL__ */");
        printWriter.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        printWriter.flush();
    }
}

