/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.openide.util.CharSequences;

public abstract class APTBaseMacroMap
implements APTMacroMap {
    protected APTMacroMapSnapshot active = this.makeSnapshot(null);
    protected static final APTMacroMap EMPTY = new EmptyMacroMap();

    protected APTBaseMacroMap() {
    }

    protected final void fill(List<String> macros, boolean isSystem) {
        for (String macro : macros) {
            if (APTTraceFlags.TRACE_APT) {
                System.err.println("adding macro in map " + macro);
            }
            this.define(macro, isSystem);
        }
    }

    private void define(String macroText, boolean isSystem) {
        APTDefine defNode = APTUtils.createAPTDefine(macroText);
        if (defNode != null) {
            if (isSystem) {
                this.defineImpl(null, defNode, APTMacro.Kind.COMPILER_PREDEFINED);
            } else {
                this.defineImpl(null, defNode, APTMacro.Kind.USER_SPECIFIED);
            }
        }
    }

    @Override
    public void define(APTFile file, APTDefine define, APTMacro.Kind macroType) {
        this.defineImpl(file, define, macroType);
    }

    private void defineImpl(APTFile file, APTDefine define, APTMacro.Kind macroType) {
        APTToken name = define.getName();
        CharSequence filePath = file == null ? CharSequences.empty() : file.getPath();
        this.putMacro(name.getTextID(), this.createMacro(filePath, define, macroType));
    }

    @Override
    public void undef(APTFile file, APTToken name) {
        this.putMacro(name.getTextID(), APTMacroMapSnapshot.UNDEFINED_MACRO);
    }

    protected void putMacro(CharSequence name, APTMacro macro) {
        this.active.putMacro(name, macro);
    }

    protected abstract APTMacro createMacro(CharSequence var1, APTDefine var2, APTMacro.Kind var3);

    @Override
    public final boolean isDefined(APTToken token) {
        return this.getMacro(token) != null;
    }

    @Override
    public final boolean isDefined(CharSequence token) {
        return this.getMacro(token = CharSequences.create((CharSequence)token)) != null;
    }

    @Override
    public APTMacro getMacro(APTToken token) {
        APTMacro res = this.active.getMacro(token);
        return res != APTMacroMapSnapshot.UNDEFINED_MACRO ? res : null;
    }

    protected APTMacro getMacro(CharSequence token) {
        assert (CharSequences.isCompact((CharSequence)token)) : "must not be String object " + token;
        APTMacro res = this.active.getMacro(token);
        return res != APTMacroMapSnapshot.UNDEFINED_MACRO ? res : null;
    }

    protected abstract APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot var1);

    @Override
    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new StateImpl(this.active.parent);
    }

    protected void changeActiveSnapshotIfNeeded() {
        this.active = this.makeSnapshot(this.active);
    }

    @Override
    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((StateImpl)state).snap);
    }

    public String toString() {
        Map<CharSequence, APTMacro> tmpMap = APTMacroMapSnapshot.addAllMacros(this.active, null);
        return APTUtils.macros2String(tmpMap);
    }

    private static final class EmptyMacroMap
    implements APTMacroMap {
        private EmptyMacroMap() {
        }

        protected APTMacro createMacro(APTDefine define) {
            return null;
        }

        @Override
        public boolean pushExpanding(APTToken token) {
            return false;
        }

        @Override
        public void popExpanding() {
        }

        @Override
        public boolean isExpanding(APTToken token) {
            return false;
        }

        @Override
        public boolean isDefined(APTToken token) {
            return false;
        }

        @Override
        public boolean isDefined(CharSequence token) {
            return false;
        }

        @Override
        public APTMacro getMacro(APTToken token) {
            return null;
        }

        @Override
        public void define(APTFile file, APTDefine define, APTMacro.Kind macroType) {
        }

        @Override
        public void undef(APTFile file, APTToken name) {
        }

        @Override
        public void setState(APTMacroMap.State state) {
        }

        @Override
        public APTMacroMap.State getState() {
            return new StateImpl((APTMacroMapSnapshot)null);
        }

        public String toString() {
            return "EmptyMacroMap";
        }
    }

    public static class StateImpl
    implements APTMacroMap.State {
        public final APTMacroMapSnapshot snap;

        public StateImpl(APTMacroMapSnapshot snap) {
            this.snap = snap;
        }

        protected StateImpl(StateImpl state, boolean cleanedState) {
            this.snap = cleanedState ? this.getFirstSnapshot(state.snap) : state.snap;
        }

        public String toString() {
            return this.snap != null ? this.snap.toString() : "<no snap>";
        }

        public StateImpl copyCleaned() {
            return new StateImpl(this, true);
        }

        boolean isEmptyActiveMacroMap() {
            return this.snap == null || this.snap.isEmtpy();
        }

        public void write(DataOutput output) throws IOException {
            APTSerializeUtils.writeSnapshot(this.snap, output);
        }

        public StateImpl(DataInput input) throws IOException {
            this.snap = APTSerializeUtils.readSnapshot(input);
        }

        private APTMacroMapSnapshot getFirstSnapshot(APTMacroMapSnapshot snap) {
            if (snap != null) {
                while (snap.parent != null) {
                    snap = snap.parent;
                }
            }
            return snap;
        }
    }
}

