/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.apt.impl.support.SupportAPIAccessor;
import org.netbeans.modules.cnd.apt.support.AccessorImpl;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public final class IncludeDirEntry {
    private static final int MANAGER_DEFAULT_CAPACITY;
    private static final int MANAGER_DEFAULT_SLICED_NUMBER;
    private static final IncludeDirStorage storage;
    private volatile Boolean exists;
    private final boolean isFramework;
    private final CharSequence asCharSeq;
    private final FileSystem fileSystem;

    private IncludeDirEntry(boolean exists, boolean framework, FileSystem fileSystem, CharSequence asCharSeq) {
        this.exists = exists;
        this.isFramework = framework;
        this.fileSystem = fileSystem;
        this.asCharSeq = asCharSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludeDirEntry get(FileSystem fs, String dir) {
        Map delegate;
        CndUtils.assertAbsolutePathInConsole((String)dir);
        CharSequence key = FilePathCache.getManager().getString(CndFileSystemProvider.toUrl((FileSystem)fs, (CharSequence)dir));
        Map map = delegate = IncludeDirEntry.storage.getDelegate(key);
        synchronized (map) {
            IncludeDirEntry out = (IncludeDirEntry)delegate.get(key);
            if (out == null) {
                boolean framework = dir.endsWith("/Frameworks");
                if (dir.contains(File.separatorChar + "remote-files" + File.separatorChar)) {
                    fs = CndFileUtils.getLocalFileSystem();
                }
                boolean exists = CndFileUtils.isExistingDirectory((FileSystem)fs, (String)dir);
                FileSystem entryFS = fs;
                if (exists) {
                    FileObject fo = CndFileUtils.toFileObject((FileSystem)fs, (CharSequence)dir);
                    try {
                        entryFS = fo.getFileSystem();
                        dir = CndFileUtils.getNormalizedPath((FileObject)fo);
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                CharSequence asCharSeq = FilePathCache.getManager().getString((CharSequence)dir);
                out = new IncludeDirEntry(exists, framework, entryFS, asCharSeq);
                delegate.put(key, out);
            }
            return out;
        }
    }

    public CharSequence getAsSharedCharSequence() {
        return this.asCharSeq;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    boolean isExistingDirectory() {
        if (this.exists == null) {
            this.exists = CndFileUtils.isExistingDirectory((FileSystem)this.fileSystem, (String)this.getPath());
        }
        return this.exists;
    }

    public String getPath() {
        return ((Object)this.asCharSeq).toString();
    }

    public String toString() {
        Boolean val = this.exists;
        return (val == null ? "Not Initialized exist flag" : (val != false ? "" : "NOT EXISTING ")) + this.fileSystem + ':' + this.asCharSeq;
    }

    private void invalidateDirExistence() {
        this.exists = null;
    }

    static void disposeCache() {
        storage.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateCache() {
        WeakHashMap[] arr$ = storage.instances;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WeakHashMap map;
            WeakHashMap weakHashMap = map = arr$[i$];
            synchronized (weakHashMap) {
                for (IncludeDirEntry includeDirEntry : map.values()) {
                    includeDirEntry.invalidateDirExistence();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateFileBasedCache(String file) {
        Map delegate;
        CharSequence key = FilePathCache.getManager().getString((CharSequence)file);
        Map map = delegate = IncludeDirEntry.storage.getDelegate(key);
        synchronized (map) {
            IncludeDirEntry prev = (IncludeDirEntry)delegate.remove(key);
            if (prev != null) {
                prev.invalidateDirExistence();
            }
        }
    }

    static {
        SupportAPIAccessor.register(new AccessorImpl());
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MANAGER_DEFAULT_CAPACITY = 128;
        }
        storage = new IncludeDirStorage(MANAGER_DEFAULT_SLICED_NUMBER, MANAGER_DEFAULT_CAPACITY);
    }

    private static final class IncludeDirStorage {
        private final WeakHashMap<CharSequence, IncludeDirEntry>[] instances;
        private final int segmentMask;

        private IncludeDirStorage(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            WeakHashMap[] ar = new WeakHashMap[ssize];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = new WeakHashMap(initialCapacity);
            }
            this.instances = ar;
        }

        private Map<CharSequence, IncludeDirEntry> getDelegate(CharSequence key) {
            int index = key.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        public final IncludeDirEntry getSharedUID(CharSequence key) {
            return this.getDelegate(key).get(key);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    System.out.println("Include Dir Cache " + this.instances[i].size());
                    HashMap<Class, Integer> keyClasses = new HashMap<Class, Integer>();
                    for (CharSequence charSequence : this.instances[i].keySet()) {
                        if (charSequence == null) continue;
                        this.incCounter(keyClasses, charSequence);
                    }
                    for (Map.Entry entry : keyClasses.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
            }
        }

        private void incCounter(Map<Class, Integer> uidClasses, Object o) {
            Integer num = uidClasses.get(o.getClass());
            num = num != null ? Integer.valueOf(num + 1) : Integer.valueOf(1);
            uidClasses.put(o.getClass(), num);
        }
    }
}

